.TH "sane\-genesys" "5" "4 Jul 2012" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-genesys
.SH "NAME"
sane\-genesys \- SANE backend for GL646, GL841, GL843, GL847 and GL124 based USB flatbed scanners
.SH "DESCRIPTION"
The
.B sane\-genesys
library implements a SANE (Scanner Access Now Easy) backend that provides
access to USB flatbed scanners based on the Genesys GL646, GL841, GL843, GL847 and GL124 chips.
At present, the following scanners are known to work with this backend:
.PP
.RS
Canon LiDE 35/40/50/60/100/110/120/200/210/220/700
.br
Hewlett-Packard HP2300C/HP2400/HP3670/HP3690/G4010/G4050
.br
Medion MD5345/MD6228/MD6274
.br
Panasonic KV-SS080
.br
Plustek OpticBook 3600
.br
Pentax DSmobile 600
.br
Syscan/Ambir DocketPORT 467/485/487/665/685
.br
Visioneer OneTouch 7100/Strobe XP100 (rev3)/XP200/XP300/Roadwarrior
.br
Xerox Travel Scanner 100, OneTouch 2400
.RE

.PP
This is stable software for supported models. But if you test new or untested scanners, keep
your hand at the scanner's plug and unplug it, if the head bumps at the end of
the scan area.
.PP
If you own a scanner other than the ones listed above that works with this
backend, please let me know this by sending the scanner's exact model name and
the USB vendor and device ids (e.g. from
.IR /proc/bus/usb/devices ,
.I sane\-find\-scanner
or syslog) to the sane\-devel mailing list. Even if the scanner's name is only
slightly different from the models mentioned above, please let me know.
.PP
If you own a scanner that isn't detected by the genesys backend but has a GL646,
GL841, GL843, GL847 or GL124 chipset, you can try to add it to the backend.
.PP
.SH "CALIBRATION"
To give correct image quality, sheet fed scanners need to be calibrated using the
calibration sheet sold with the scanner. To do calibration, you must insert this target
in the feeder then start calibration either by passing the \-\-calibrate option to
.BR scanimage (1)
or by clicking on the available 'calibrate' button in the 'advanced options' in a graphical
frontend. The result of the calibration is stored in a file in the home directory of the user doing it.
If you plug the scanner in another machine or use it with another account, calibration
will have to be redone, unless you use the \-\-calibration\-file option.
If no home directory is defined,
.B USERAPPPROFILE
will be used, then
.B TMPDIR
or
.BR TMP.
If none of these directories exist, the backend will try
to write in the current working directory. Flatbed scanners also make use of the calibration file as a cache
to avoid calibration before each scan. Calibration file name is the name of the scanner model if only
one scanner is detected. In the case of several identical model, the file name will be the name
of the logical USB device name. The expiration time manages the time a calibration is valid in cache.
A value of -1 means forever, 0 means no cache.

.SH EXTRAS SCAN OPTIONS

.TP
.B \-\-lamp\-off\-time number
The lamp will be turned off after the given time (in minutes). A value of 0 means that the lamp won't be turned off.

.TP
.B \-\-threshold percent
0..100% (in steps of 1). Select minimum brightness to get a white point. Pixels
with brightness below that value will be scanned as black.

.TP
.B \-\-brightness value
\-100..100 (in steps of 1). Set the brightness enhancement. 0 for no enhancement, negative
values to decrease brightness, and positive values to increase it.

.TP
.B \-\-contrast value
\-100..100 (in steps of 1). Set the contrast enhancement. 0 for no enhancement, negative
values to decrease contrast, and positive values to increase it.

.TP
.B \-\-disable-interpolation yes|no
When using high resolutions where the horizontal resolution is smaller than vertical resolution,
data is expanded by software to preserve picture geometry. This can be disabled by this option to get
real scanned data.

.TP
.B \-\-disable-dynamic-lineart yes|no
Disable use of a software adaptive algorithm to generate lineart and rely on hardware lineart.

.TP
.B \-\-color-filter None|Red|Green|Blue
When using gray or lineart this option selects the used color. Using a color filter
will give a monochrome scan. CIS based scanners can do true gray when no filter (None value) is
selected.

.TP
.B \-\-lamp\-off\-scan
The lamp will be turned off during the scan. Calibration is still done with lamp on.

.TP
.B \-\-clear\-calibration
Clear calibration cache data, triggering a new calibration for the device when the
next scan will happen.

.TP
.B \-\-calibration\-file
Specify the calibration file name to use. At least the directory containing the file
must exist, since it won't be created. This option is disabled if the backend is run
as root. It maybe used in case of sheet-fed scanners to share a calibration file for several
users.

.TP
.B \-\-expiration\-time
Specify the time (in minutes) a cached calibration is considered valid. If older than the given value, a new
calibration is done. A value of -1 means no expiration and cached value are kept forever unless cleared by
user with the calibration clear option. A value of 0 means cache is disabled.

.PP
Additionally, several 'software' options are exposed by the backend. These
are reimplementations of features provided natively by larger scanners, but
running on the host computer. This enables smaller machines to have similar
capabilities. Please note that these features are somewhat simplistic, and
may not perform as well as the native implementations. Note also that these
features all require that the driver cache the entire image in memory. This
will almost certainly result in a reduction of scanning speed.

.TP
.B \-\-swcrop
Requests the driver to detect the extremities of the paper within the larger
image, and crop the empty edges.

.TP
.B \-\-swdeskew
Requests the driver to detect the rotation of the paper within the larger
image, and counter the rotation.

.TP
.B \-\-swdespeck  \-\-despeck X
Requests the driver to find and remove dots of X diameter or smaller from the
image, and fill the space with the average surrounding color.

.TP
.B \-\-swskip 0..100% (in steps of 1) [0]
Request driver to discard pages with low numbers of dark pixels.

.TP
.B \-\-swderotate[=(yes|no)] [no]
Request driver to detect and correct 90 degree image rotation.

.SH "SYSTEM ISSUES"
This backend needs libusb-0.1.6 or later installed, and hasn't tested in other
configuration than a linux kernel 2.6.9 or higher. However, it should work any
system with libusb where the SANE package can be compiled. For
setting permissions and general USB information look at
.BR sane\-usb (5).


.SH "CONFIGURATION"
The contents of the
.I genesys.conf
file is a list of usb lines containing vendor and product ids that correspond
to USB scanners. The file can also contain option lines.  Empty lines and
lines starting with a hash mark (#) are ignored.  The scanners are
autodetected by
.B usb vendor_id product_id
statements which are already included into
.IR genesys.conf .
"vendor_id" and "product_id" are hexadecimal numbers that identify the
scanner.
.PP

.SH "FILES"
.TP
.I @CONFIGDIR@/genesys.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @LIBDIR@/libsane\-genesys.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-genesys.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH "ENVIRONMENT"
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  On *NIX systems, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in
.IR @CONFIGDIR@ .
If the value of the environment variable ends with the directory separator
character, then the default directories are searched after the explicitly
specified directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories
.IR tmp/config ,
.IR . ,
and
.I "@CONFIGDIR@"
being searched (in this order).
.TP
.B SANE_DEBUG_GENESYS
If the library was compiled with debug support enabled, this environment
variable controls the debug level for this backend.  Higher debug levels
increase the verbosity of the output. If the debug level is set to 1 or higher,
some debug options become available that are normally hidden. Handle them with
care. This will print messages related to core genesys functions.
.TP
.B SANE_DEBUG_GENESYS_IMAGE
If the library was compiled with debug support enabled, this environment
variable enables logging of intermediate image data. To enable this mode,
set the environmental variable to 1.


Example (full and highly verbose output for gl646):
.br
export SANE_DEBUG_GENESYS=255

.SH CREDITS

Jack McGill for donating several sheetfed and flatbed scanners, which made possible to add support
for them in the genesys backend:
.RS
Hewlett-Packard HP3670
.br
Visioneer Strobe XP100 (rev3)/XP200/XP300/Roadwarrior
.br
Canon LiDE 200
.br
Pentax DSmobile 600
.br
Syscan/Ambir DocketPORT 467/485/487/665/685
.br
Xerox Travel Scanner 100, Onetouch 2400
.RE
.TP
cncsolutions sponsored and supported the work on the Panasonic KV-SS080.
.br
.TP
Brian Paavo from Benthic Science Limited for donating a Canoscan LiDE 700F.
.br
.TP
Dany Qumsiyeh for donating a Canoscan LiDE 210 and a LiDE 220.
.br
.TP
Luc Verhaegen for donating a Canoscan LiDE 120.
.br

.SH "SEE ALSO"
.BR sane (7),
.BR sane\-usb (5)
.br


.SH "AUTHOR"
Oliver Rauch
.br
Henning Meier-Geinitz
.RI < henning@meier\-geinitz.de >
.br
Gerhard Jaeger
.RI < gerhard@gjaeger.de >
.br
St\['e]phane Voltz
.RI < stef.dev@free.fr >
.br
Philipp Schmid
.RI < philipp8288@web.de >
.br
Pierre Willenbrock
.RI < pierre@pirsoft.dnsalias.org >
.br
Alexey Osipov
.RI < simba@lerlan.ru >
for HP2400 final support

.SH "LIMITATIONS"

Powersaving isn't implemented for gl646 based scanner. Dynamic (emulated from gray data and with dithering)
isn't enabled for gl646 scanners. Hardware lineart is limited up to 600 dpi for gl847 based scanners,
due to the way image sensors are built.
.PP
This backend will be much slower if not using libusb\-1.0. So be sure that sane\-backends is built with
the
.B \-\-enable-libusb_1_0
option.

.SH "BUGS"
For the LiDE 200, the scanned data at 4800 dpi is obtained "as is" from sensor.
It seems the windows driver does some digital processing to improve it, which is not implemented in the backend.
.PP
