/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.FigureSelection;
import org.jhotdraw.framework.PointConstrainer;
import org.jhotdraw.standard.DeleteFromDrawingVisitor;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.standard.FigureTransferCommand;
import org.jhotdraw.util.Clipboard;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class PasteCommand
extends FigureTransferCommand {
    public PasteCommand(String string, DrawingEditor drawingEditor) {
        super(string, drawingEditor);
    }

    public void execute() {
        super.execute();
        Point point = this.view().lastClick();
        FigureSelection figureSelection = (FigureSelection)Clipboard.getClipboard().getContents();
        if (figureSelection != null) {
            this.setUndoActivity(this.createUndoActivity());
            this.getUndoActivity().setAffectedFigures((FigureEnumerator)figureSelection.getData("org.jhotdraw.Figures"));
            if (!this.getUndoActivity().getAffectedFigures().hasNextFigure()) {
                this.setUndoActivity(null);
                return;
            }
            Rectangle rectangle = this.getBounds(this.getUndoActivity().getAffectedFigures());
            this.view().clearSelection();
            Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
            PointConstrainer pointConstrainer = this.view().getConstrainer();
            if (pointConstrainer != null) {
                pointConstrainer.constrainPoint(point2);
            }
            FigureEnumeration figureEnumeration = this.insertFigures(this.getUndoActivity().getAffectedFigures(), point2.x, point2.y);
            this.getUndoActivity().setAffectedFigures(figureEnumeration);
            this.view().checkDamage();
        }
    }

    public boolean isExecutableWithView() {
        return Clipboard.getClipboard().getContents() != null;
    }

    private Rectangle getBounds(FigureEnumeration figureEnumeration) {
        Rectangle rectangle = figureEnumeration.nextFigure().displayBox();
        while (figureEnumeration.hasNextFigure()) {
            rectangle.add(figureEnumeration.nextFigure().displayBox());
        }
        return rectangle;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        public UndoActivity(DrawingView drawingView) {
            super(drawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            DeleteFromDrawingVisitor deleteFromDrawingVisitor = new DeleteFromDrawingVisitor(this.getDrawingView().drawing());
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                figureEnumeration.nextFigure().visit(deleteFromDrawingVisitor);
            }
            this.getDrawingView().clearSelection();
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            this.setAffectedFigures(this.getDrawingView().insertFigures(this.getAffectedFigures(), 0, 0, false));
            return true;
        }
    }
}

