#include <stdlib.h>
#include <stdio.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"

#include "uwa-test-client.h"

#define ICON_URL "http://www.ubuntu.com/sites/www.ubuntu.com/files/active/02_ubuntu/U_homepage/picto-desktop.png"

static GMainLoop *mainloop = NULL;

int count = 0;

static void
close_callback (UnityWebappsContext *context, gpointer user_data)
{
  printf("Close callback \n");
  uwa_emit_test_finished ();
}

static void
context_ready (UnityWebappsContext *context, gpointer user_data)
{
  unity_webapps_context_on_close_callback (context, close_callback, NULL);
  printf("Quit the application from the test launcher icon\n");
}

gint
main (gint argc, gchar **argv)
{
  UnityWebappsService *service;
  
  g_type_init ();
  
  service = unity_webapps_service_new ();
  
  unity_webapps_context_new (service, "Test", "test.ts", ICON_URL, NULL, context_ready, NULL);
  
  mainloop = g_main_loop_new (NULL, FALSE);
  
  g_main_loop_run (mainloop);
  
  return 0;  
}
