#ifndef _UNITY_WEBAPPS_CONTEXT_PRIVATE_H__
#define _UNITY_WEBAPPS_CONTEXT_PRIVATE_H__

#include "unity-webapps-gen-context.h"
#include "unity-webapps-gen-launcher.h"
#include "unity-webapps-gen-notification.h"
#include "unity-webapps-gen-indicator.h"
#include "unity-webapps-gen-music-player.h"

struct _UnityWebappsNotificationContext {
  UnityWebappsContext *context;
  
  UnityWebappsGenNotification *notification_proxy;
  guint notification_rate;
};

struct _UnityWebappsLauncherContext {
  UnityWebappsContext *context;

  UnityWebappsGenLauncher *launcher_proxy;
  GHashTable *quicklist_callbacks_by_name;
  guint launcher_rate;
};

struct _UnityWebappsMusicPlayerContext {
  UnityWebappsContext *context;
 
  UnityWebappsGenMusicPlayer *music_player_proxy;
  guint music_player_rate;
};

struct _UnityWebappsIndicatorContext {
  UnityWebappsContext *context;

  UnityWebappsGenIndicator *indicator_proxy;
	
  GHashTable *menu_callbacks_by_name;
  GHashTable *indicator_callbacks_by_name;

  guint indicator_rate;
};



struct _UnityWebappsContextPrivate {
  UnityWebappsService *service;
  
  UnityWebappsGenContext *context_proxy;
  
  UnityWebappsNotificationContext *notification_context;
  UnityWebappsIndicatorContext *indicator_context;
  UnityWebappsMusicPlayerContext *music_player_context;
  UnityWebappsLauncherContext *launcher_context;
  
  guint global_rate;
  
  gchar *name;
  gchar *domain;
  gchar *icon_url;
  gchar *mime_types; /*capable of opening files with the given content type*/

  gchar *context_name;

  gboolean took_interest;
  gboolean user_abandoned;
  
  gint interest_id;
  
  UnityWebappsContextPreviewCallback preview_callback;
  gpointer preview_user_data;
  
  GHashTable *action_callbacks_by_name;
  
  gboolean remote_ready;
};

UnityWebappsIndicatorContext *unity_webapps_indicator_context_new (UnityWebappsContext *main_context, GError **error);
void unity_webapps_indicator_context_free (UnityWebappsIndicatorContext *context);

UnityWebappsNotificationContext *unity_webapps_notification_context_new (UnityWebappsContext *main_context, GError **error);
void unity_webapps_notification_context_free (UnityWebappsNotificationContext *context);

UnityWebappsLauncherContext *unity_webapps_launcher_context_new (UnityWebappsContext *main_context, GError **error);
void unity_webapps_launcher_context_free (UnityWebappsLauncherContext *context);

UnityWebappsMusicPlayerContext *unity_webapps_music_player_context_new (UnityWebappsContext *main_context, GError **error);
void unity_webapps_music_player_context_free (UnityWebappsMusicPlayerContext *context);





#endif
