/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.event;

class IdentityList {
    private Object[] elementData = new Object[10];
    private int elementCount = 0;

    public synchronized void add(Object o) {
        this.checkCapacity();
        this.elementData[this.elementCount++] = o;
    }

    public synchronized void remove(Object o) {
        int index = this.indexOf(o);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    public synchronized boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    private int indexOf(Object o) {
        for (int i = 0; i < this.elementCount; ++i) {
            if (o != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    private void removeElementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    private void checkCapacity() {
        int curCapacity = this.elementData.length;
        if (this.elementCount >= curCapacity) {
            Object[] oldData = this.elementData;
            int newCapacity = curCapacity * 2;
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }
}

