/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Comparator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollationFactory;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class XPathContext {
    private Controller controller;
    private SequenceIterator currentIterator;
    private int last = -1;
    private Object[] localVariableFrame;

    public XPathContext(Controller controller) {
        this.controller = controller;
        this.currentIterator = controller.getCurrentIterator();
        this.localVariableFrame = controller.getBindery().getCurrentStackFrame();
    }

    public XPathContext(XPathContext xPathContext) {
        this.controller = xPathContext.controller;
        this.currentIterator = xPathContext.currentIterator;
        this.localVariableFrame = xPathContext.localVariableFrame;
        this.last = xPathContext.last;
    }

    public XPathContext(Item item) {
        this.controller = null;
        AxisIterator axisIterator = SingletonIterator.makeIterator(item);
        axisIterator.next();
        this.currentIterator = axisIterator;
    }

    public XPathContext newContext() {
        XPathContext xPathContext = new XPathContext(this);
        return xPathContext;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setCurrentIterator(SequenceIterator sequenceIterator) {
        this.currentIterator = sequenceIterator;
        this.last = 0;
    }

    public SequenceIterator getCurrentIterator() {
        return this.currentIterator;
    }

    public int getContextPosition() throws XPathException {
        if (this.currentIterator == null) {
            throw new XPathException.Dynamic("The context item and context position are not set");
        }
        return this.currentIterator.position();
    }

    public Item getContextItem() {
        if (this.currentIterator == null) {
            return null;
        }
        return this.currentIterator.current();
    }

    public int getLast() throws XPathException {
        if (this.last > 0) {
            return this.last;
        }
        if (this.currentIterator == null) {
            throw new XPathException.Dynamic("The context item, position, and size are not set");
        }
        if (this.currentIterator instanceof LastPositionFinder) {
            this.last = ((LastPositionFinder)this.currentIterator).getLastPosition();
            return this.last;
        }
        SequenceIterator sequenceIterator = this.currentIterator.getAnother();
        this.last = 0;
        while (sequenceIterator.next() != null) {
            ++this.last;
        }
        return this.last;
    }

    public boolean isAtLast() throws XPathException {
        if (this.currentIterator instanceof LookaheadIterator) {
            return !((LookaheadIterator)this.currentIterator).hasNext();
        }
        return this.getContextPosition() == this.getLast();
    }

    public Item getCurrentStylesheetItem() throws XPathException {
        return this.getController().getCurrentItem();
    }

    public Comparator getCollation(String string) throws XPathException {
        if (string.equals(CodepointCollator.URI)) {
            return CodepointCollator.getInstance();
        }
        Comparator comparator = null;
        if (this.controller != null) {
            comparator = this.controller.getExecutable().getNamedCollation(string);
        }
        if (comparator == null) {
            try {
                comparator = CollationFactory.makeCollationFromURI(string);
                if (comparator == null) {
                    throw new XPathException.Dynamic("Unknown collation " + string);
                }
            }
            catch (TransformerException transformerException) {
                throw new XPathException.Dynamic(transformerException);
            }
        }
        return comparator;
    }

    public Comparator getDefaultCollation() {
        if (this.controller != null) {
            return this.controller.getExecutable().getDefaultCollation();
        }
        return CodepointCollator.getInstance();
    }

    public Object[] getLocalVariableFrame() {
        return this.localVariableFrame;
    }

    public void setLocalVariableFrame(Object[] objectArray) {
        this.localVariableFrame = objectArray;
    }

    public Value evaluateLocalVariable(int n) {
        return (Value)this.localVariableFrame[n + 2];
    }

    public void setLocalVariable(int n, Value value) {
        this.localVariableFrame[n + 2] = value;
    }
}

