// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: aarch64-registered-target
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s
// RUN: %clang_cc1 -DTUPLE=x2 -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=TUPLE2
// RUN: %clang_cc1 -DTUPLE=x3 -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=TUPLE3
// RUN: %clang_cc1 -DTUPLE=x4 -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=TUPLE4
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=CPP-CHECK
// RUN: %clang_cc1 -DTUPLE=x2 -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=CPP-TUPLE2
// RUN: %clang_cc1 -DTUPLE=x3 -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=CPP-TUPLE3
// RUN: %clang_cc1 -DTUPLE=x4 -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=CPP-TUPLE4
// RUN: %clang_cc1 -DSVE_OVERLOADED_FORMS -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s
// RUN: %clang_cc1 -DSVE_OVERLOADED_FORMS -DTUPLE=x2 -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=TUPLE2
// RUN: %clang_cc1 -DSVE_OVERLOADED_FORMS -DTUPLE=x3 -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=TUPLE3
// RUN: %clang_cc1 -DSVE_OVERLOADED_FORMS -DTUPLE=x4 -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=TUPLE4
// RUN: %clang_cc1 -DSVE_OVERLOADED_FORMS -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=CPP-CHECK
// RUN: %clang_cc1 -DSVE_OVERLOADED_FORMS -DTUPLE=x2 -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=CPP-TUPLE2
// RUN: %clang_cc1 -DSVE_OVERLOADED_FORMS -DTUPLE=x3 -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=CPP-TUPLE3
// RUN: %clang_cc1 -DSVE_OVERLOADED_FORMS -DTUPLE=x4 -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=CPP-TUPLE4
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +sve -S -disable-O0-optnone -Werror -Wall -o /dev/null %s

#include <arm_sve.h>

#ifdef TUPLE
#define TYPE_1(base,tuple) base ## tuple ## _t
#define TYPE_0(base,tuple) TYPE_1(base,tuple)
#define TYPE(base) TYPE_0(base,TUPLE)
#else
#define TYPE(base) base ## _t
#endif

#ifdef SVE_OVERLOADED_FORMS
#define SVE_ACLE_FUNC(A1,A2_UNUSED) A1
#else
#ifdef TUPLE
#define SVE_ACLE_FUNC_1(A1,A2,T) A1##A2##_##T
#define SVE_ACLE_FUNC_0(A1,A2,T) SVE_ACLE_FUNC_1(A1,A2,T)
#define SVE_ACLE_FUNC(A1,A2) SVE_ACLE_FUNC_0(A1,A2,TUPLE)
#else
#define SVE_ACLE_FUNC(A1,A2) A1##A2
#endif
#endif

// CHECK-LABEL: @test_svreinterpret_s8_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 16 x i8> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_s8_s8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_s8_s8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_s8_s8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z24test_svreinterpret_s8_s8u10__SVInt8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z24test_svreinterpret_s8_s810svint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z24test_svreinterpret_s8_s810svint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z24test_svreinterpret_s8_s810svint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[OP:%.*]]
//
TYPE(svint8) test_svreinterpret_s8_s8(TYPE(svint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s8,_s8)(op);
}

// CHECK-LABEL: @test_svreinterpret_s8_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s8_s16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s8_s16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s8_s16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_s8_s16u11__SVInt16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_s8_s1611svint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_s8_s1611svint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_s8_s1611svint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svint8) test_svreinterpret_s8_s16(TYPE(svint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s8,_s16)(op);
}

// CHECK-LABEL: @test_svreinterpret_s8_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s8_s32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s8_s32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s8_s32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_s8_s32u11__SVInt32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_s8_s3211svint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_s8_s3211svint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_s8_s3211svint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svint8) test_svreinterpret_s8_s32(TYPE(svint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s8,_s32)(op);
}

// CHECK-LABEL: @test_svreinterpret_s8_s64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s8_s64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s8_s64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s8_s64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_s8_s64u11__SVInt64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_s8_s6411svint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_s8_s6411svint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_s8_s6411svint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svint8) test_svreinterpret_s8_s64(TYPE(svint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s8,_s64)(op);
}

// CHECK-LABEL: @test_svreinterpret_s8_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 16 x i8> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_s8_u8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_s8_u8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_s8_u8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z24test_svreinterpret_s8_u8u11__SVUint8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z24test_svreinterpret_s8_u811svuint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z24test_svreinterpret_s8_u811svuint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z24test_svreinterpret_s8_u811svuint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[OP:%.*]]
//
TYPE(svint8) test_svreinterpret_s8_u8(TYPE(svuint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s8,_u8)(op);
}

// CHECK-LABEL: @test_svreinterpret_s8_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s8_u16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s8_u16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s8_u16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_s8_u16u12__SVUint16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_s8_u1612svuint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_s8_u1612svuint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_s8_u1612svuint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svint8) test_svreinterpret_s8_u16(TYPE(svuint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s8,_u16)(op);
}

//
// CHECK-LABEL: @test_svreinterpret_s8_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s8_u32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s8_u32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s8_u32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_s8_u32u12__SVUint32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_s8_u3212svuint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_s8_u3212svuint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_s8_u3212svuint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svint8) test_svreinterpret_s8_u32(TYPE(svuint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s8,_u32)(op);
}

//
// CHECK-LABEL: @test_svreinterpret_s8_u64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s8_u64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s8_u64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s8_u64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_s8_u64u12__SVUint64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_s8_u6412svuint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_s8_u6412svuint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_s8_u6412svuint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svint8) test_svreinterpret_s8_u64(TYPE(svuint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s8,_u64)(op);
}

// CHECK-LABEL: @test_svreinterpret_s8_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s8_f16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s8_f16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s8_f16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_s8_f16u13__SVFloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_s8_f1613svfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_s8_f1613svfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_s8_f1613svfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svint8) test_svreinterpret_s8_f16(TYPE(svfloat16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s8,_f16)(op);
}

// CHECK-LABEL: @test_svreinterpret_s8_f32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s8_f32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s8_f32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s8_f32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_s8_f32u13__SVFloat32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_s8_f3213svfloat32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_s8_f3213svfloat32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_s8_f3213svfloat32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svint8) test_svreinterpret_s8_f32(TYPE(svfloat32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s8,_f32)(op);
}

// CHECK-LABEL: @test_svreinterpret_s8_f64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s8_f64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s8_f64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s8_f64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_s8_f64u13__SVFloat64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_s8_f6413svfloat64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_s8_f6413svfloat64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_s8_f6413svfloat64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svint8) test_svreinterpret_s8_f64(TYPE(svfloat64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s8,_f64)(op);
}

// CHECK-LABEL: @test_svreinterpret_s16_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s16_s8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s16_s8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s16_s8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_s16_s8u10__SVInt8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_s16_s810svint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_s16_s810svint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_s16_s810svint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svint16) test_svreinterpret_s16_s8(TYPE(svint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s16,_s8)(op);
}

// CHECK-LABEL: @test_svreinterpret_s16_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 8 x i16> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_s16_s16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_s16_s16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_s16_s16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s16_s16u11__SVInt16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s16_s1611svint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s16_s1611svint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s16_s1611svint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[OP:%.*]]
//
TYPE(svint16) test_svreinterpret_s16_s16(TYPE(svint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s16,_s16)(op);
}

// CHECK-LABEL: @test_svreinterpret_s16_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s16_s32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s16_s32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s16_s32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s16_s32u11__SVInt32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s16_s3211svint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s16_s3211svint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s16_s3211svint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svint16) test_svreinterpret_s16_s32(TYPE(svint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s16,_s32)(op);
}

// CHECK-LABEL: @test_svreinterpret_s16_s64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s16_s64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s16_s64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s16_s64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s16_s64u11__SVInt64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s16_s6411svint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s16_s6411svint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s16_s6411svint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svint16) test_svreinterpret_s16_s64(TYPE(svint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s16,_s64)(op);
}

// CHECK-LABEL: @test_svreinterpret_s16_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s16_u8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s16_u8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s16_u8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_s16_u8u11__SVUint8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_s16_u811svuint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_s16_u811svuint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_s16_u811svuint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svint16) test_svreinterpret_s16_u8(TYPE(svuint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s16,_u8)(op);
}

// CHECK-LABEL: @test_svreinterpret_s16_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 8 x i16> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_s16_u16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_s16_u16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_s16_u16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s16_u16u12__SVUint16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s16_u1612svuint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s16_u1612svuint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s16_u1612svuint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[OP:%.*]]
//
TYPE(svint16) test_svreinterpret_s16_u16(TYPE(svuint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s16,_u16)(op);
}

// CHECK-LABEL: @test_svreinterpret_s16_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s16_u32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s16_u32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s16_u32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s16_u32u12__SVUint32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s16_u3212svuint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s16_u3212svuint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s16_u3212svuint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svint16) test_svreinterpret_s16_u32(TYPE(svuint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s16,_u32)(op);
}

// CHECK-LABEL: @test_svreinterpret_s16_u64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s16_u64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s16_u64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s16_u64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s16_u64u12__SVUint64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s16_u6412svuint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s16_u6412svuint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s16_u6412svuint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svint16) test_svreinterpret_s16_u64(TYPE(svuint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s16,_u64)(op);
}

// CHECK-LABEL: @test_svreinterpret_s16_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s16_f16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s16_f16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s16_f16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s16_f16u13__SVFloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s16_f1613svfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s16_f1613svfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s16_f1613svfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svint16) test_svreinterpret_s16_f16(TYPE(svfloat16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s16,_f16)(op);
}

// CHECK-LABEL: @test_svreinterpret_s16_f32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s16_f32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s16_f32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s16_f32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s16_f32u13__SVFloat32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s16_f3213svfloat32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s16_f3213svfloat32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s16_f3213svfloat32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svint16) test_svreinterpret_s16_f32(TYPE(svfloat32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s16,_f32)(op);
}

// CHECK-LABEL: @test_svreinterpret_s16_f64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s16_f64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s16_f64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s16_f64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s16_f64u13__SVFloat64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s16_f6413svfloat64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s16_f6413svfloat64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s16_f6413svfloat64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svint16) test_svreinterpret_s16_f64(TYPE(svfloat64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s16,_f64)(op);
}

// CHECK-LABEL: @test_svreinterpret_s32_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s32_s8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s32_s8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s32_s8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_s32_s8u10__SVInt8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_s32_s810svint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_s32_s810svint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_s32_s810svint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svint32) test_svreinterpret_s32_s8(TYPE(svint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s32,_s8)(op);
}

// CHECK-LABEL: @test_svreinterpret_s32_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s32_s16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s32_s16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s32_s16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s32_s16u11__SVInt16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s32_s1611svint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s32_s1611svint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s32_s1611svint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svint32) test_svreinterpret_s32_s16(TYPE(svint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s32,_s16)(op);
}

// CHECK-LABEL: @test_svreinterpret_s32_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 4 x i32> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_s32_s32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_s32_s32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_s32_s32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s32_s32u11__SVInt32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s32_s3211svint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s32_s3211svint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s32_s3211svint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[OP:%.*]]
//
TYPE(svint32) test_svreinterpret_s32_s32(TYPE(svint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s32,_s32)(op);
}

// CHECK-LABEL: @test_svreinterpret_s32_s64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s32_s64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s32_s64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s32_s64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s32_s64u11__SVInt64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s32_s6411svint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s32_s6411svint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s32_s6411svint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svint32) test_svreinterpret_s32_s64(TYPE(svint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s32,_s64)(op);
}

// CHECK-LABEL: @test_svreinterpret_s32_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s32_u8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s32_u8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s32_u8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_s32_u8u11__SVUint8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_s32_u811svuint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_s32_u811svuint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_s32_u811svuint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svint32) test_svreinterpret_s32_u8(TYPE(svuint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s32,_u8)(op);
}

// CHECK-LABEL: @test_svreinterpret_s32_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s32_u16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s32_u16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s32_u16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s32_u16u12__SVUint16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s32_u1612svuint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s32_u1612svuint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s32_u1612svuint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svint32) test_svreinterpret_s32_u16(TYPE(svuint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s32,_u16)(op);
}

// CHECK-LABEL: @test_svreinterpret_s32_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 4 x i32> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_s32_u32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_s32_u32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_s32_u32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s32_u32u12__SVUint32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s32_u3212svuint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s32_u3212svuint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s32_u3212svuint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[OP:%.*]]
//
TYPE(svint32) test_svreinterpret_s32_u32(TYPE(svuint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s32,_u32)(op);
}

// CHECK-LABEL: @test_svreinterpret_s32_u64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s32_u64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s32_u64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s32_u64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s32_u64u12__SVUint64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s32_u6412svuint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s32_u6412svuint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s32_u6412svuint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svint32) test_svreinterpret_s32_u64(TYPE(svuint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s32,_u64)(op);
}

// CHECK-LABEL: @test_svreinterpret_s32_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s32_f16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s32_f16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s32_f16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s32_f16u13__SVFloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s32_f1613svfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s32_f1613svfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s32_f1613svfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svint32) test_svreinterpret_s32_f16(TYPE(svfloat16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s32,_f16)(op);
}

// CHECK-LABEL: @test_svreinterpret_s32_f32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s32_f32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s32_f32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s32_f32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s32_f32u13__SVFloat32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s32_f3213svfloat32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s32_f3213svfloat32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s32_f3213svfloat32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svint32) test_svreinterpret_s32_f32(TYPE(svfloat32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s32,_f32)(op);
}

//
// CHECK-LABEL: @test_svreinterpret_s32_f64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s32_f64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s32_f64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s32_f64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s32_f64u13__SVFloat64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s32_f6413svfloat64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s32_f6413svfloat64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s32_f6413svfloat64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svint32) test_svreinterpret_s32_f64(TYPE(svfloat64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s32,_f64)(op);
}

// CHECK-LABEL: @test_svreinterpret_s64_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s64_s8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s64_s8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s64_s8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_s64_s8u10__SVInt8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_s64_s810svint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_s64_s810svint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_s64_s810svint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svint64) test_svreinterpret_s64_s8(TYPE(svint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s64,_s8)(op);
}

// CHECK-LABEL: @test_svreinterpret_s64_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s64_s16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s64_s16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s64_s16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s64_s16u11__SVInt16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s64_s1611svint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s64_s1611svint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s64_s1611svint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svint64) test_svreinterpret_s64_s16(TYPE(svint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s64,_s16)(op);
}

// CHECK-LABEL: @test_svreinterpret_s64_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s64_s32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s64_s32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s64_s32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s64_s32u11__SVInt32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s64_s3211svint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s64_s3211svint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s64_s3211svint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svint64) test_svreinterpret_s64_s32(TYPE(svint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s64,_s32)(op);
}

// CHECK-LABEL: @test_svreinterpret_s64_s64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 2 x i64> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_s64_s64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_s64_s64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_s64_s64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s64_s64u11__SVInt64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s64_s6411svint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s64_s6411svint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s64_s6411svint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[OP:%.*]]
//
TYPE(svint64) test_svreinterpret_s64_s64(TYPE(svint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s64,_s64)(op);
}

// CHECK-LABEL: @test_svreinterpret_s64_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s64_u8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s64_u8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s64_u8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_s64_u8u11__SVUint8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_s64_u811svuint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_s64_u811svuint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_s64_u811svuint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svint64) test_svreinterpret_s64_u8(TYPE(svuint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s64,_u8)(op);
}

// CHECK-LABEL: @test_svreinterpret_s64_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s64_u16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s64_u16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s64_u16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s64_u16u12__SVUint16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s64_u1612svuint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s64_u1612svuint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s64_u1612svuint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svint64) test_svreinterpret_s64_u16(TYPE(svuint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s64,_u16)(op);
}

// CHECK-LABEL: @test_svreinterpret_s64_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s64_u32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s64_u32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s64_u32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s64_u32u12__SVUint32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s64_u3212svuint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s64_u3212svuint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s64_u3212svuint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svint64) test_svreinterpret_s64_u32(TYPE(svuint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s64,_u32)(op);
}

// CHECK-LABEL: @test_svreinterpret_s64_u64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 2 x i64> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_s64_u64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_s64_u64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_s64_u64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s64_u64u12__SVUint64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s64_u6412svuint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s64_u6412svuint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s64_u6412svuint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[OP:%.*]]
//
TYPE(svint64) test_svreinterpret_s64_u64(TYPE(svuint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s64,_u64)(op);
}

// CHECK-LABEL: @test_svreinterpret_s64_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s64_f16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s64_f16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s64_f16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s64_f16u13__SVFloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s64_f1613svfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s64_f1613svfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s64_f1613svfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svint64) test_svreinterpret_s64_f16(TYPE(svfloat16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s64,_f16)(op);
}

// CHECK-LABEL: @test_svreinterpret_s64_f32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s64_f32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s64_f32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s64_f32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s64_f32u13__SVFloat32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s64_f3213svfloat32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s64_f3213svfloat32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s64_f3213svfloat32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svint64) test_svreinterpret_s64_f32(TYPE(svfloat32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s64,_f32)(op);
}

// CHECK-LABEL: @test_svreinterpret_s64_f64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s64_f64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s64_f64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s64_f64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s64_f64u13__SVFloat64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s64_f6413svfloat64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s64_f6413svfloat64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s64_f6413svfloat64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svint64) test_svreinterpret_s64_f64(TYPE(svfloat64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_s64,_f64)(op);
}

// CHECK-LABEL: @test_svreinterpret_u8_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 16 x i8> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_u8_s8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_u8_s8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_u8_s8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z24test_svreinterpret_u8_s8u10__SVInt8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z24test_svreinterpret_u8_s810svint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z24test_svreinterpret_u8_s810svint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z24test_svreinterpret_u8_s810svint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[OP:%.*]]
//
TYPE(svuint8) test_svreinterpret_u8_s8(TYPE(svint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u8,_s8)(op);
}

// CHECK-LABEL: @test_svreinterpret_u8_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u8_s16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u8_s16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u8_s16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_u8_s16u11__SVInt16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_u8_s1611svint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_u8_s1611svint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_u8_s1611svint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svuint8) test_svreinterpret_u8_s16(TYPE(svint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u8,_s16)(op);
}

// CHECK-LABEL: @test_svreinterpret_u8_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u8_s32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u8_s32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u8_s32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_u8_s32u11__SVInt32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_u8_s3211svint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_u8_s3211svint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_u8_s3211svint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svuint8) test_svreinterpret_u8_s32(TYPE(svint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u8,_s32)(op);
}

// CHECK-LABEL: @test_svreinterpret_u8_s64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u8_s64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u8_s64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u8_s64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_u8_s64u11__SVInt64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_u8_s6411svint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_u8_s6411svint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_u8_s6411svint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svuint8) test_svreinterpret_u8_s64(TYPE(svint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u8,_s64)(op);
}

// CHECK-LABEL: @test_svreinterpret_u8_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 16 x i8> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_u8_u8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_u8_u8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_u8_u8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z24test_svreinterpret_u8_u8u11__SVUint8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z24test_svreinterpret_u8_u811svuint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z24test_svreinterpret_u8_u811svuint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z24test_svreinterpret_u8_u811svuint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[OP:%.*]]
//
TYPE(svuint8) test_svreinterpret_u8_u8(TYPE(svuint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u8,_u8)(op);
}

// CHECK-LABEL: @test_svreinterpret_u8_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u8_u16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u8_u16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u8_u16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_u8_u16u12__SVUint16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_u8_u1612svuint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_u8_u1612svuint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_u8_u1612svuint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svuint8) test_svreinterpret_u8_u16(TYPE(svuint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u8,_u16)(op);
}

// CHECK-LABEL: @test_svreinterpret_u8_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u8_u32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u8_u32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u8_u32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_u8_u32u12__SVUint32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_u8_u3212svuint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_u8_u3212svuint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_u8_u3212svuint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svuint8) test_svreinterpret_u8_u32(TYPE(svuint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u8,_u32)(op);
}

// CHECK-LABEL: @test_svreinterpret_u8_u64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u8_u64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u8_u64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u8_u64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_u8_u64u12__SVUint64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_u8_u6412svuint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_u8_u6412svuint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_u8_u6412svuint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svuint8) test_svreinterpret_u8_u64(TYPE(svuint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u8,_u64)(op);
}

// CHECK-LABEL: @test_svreinterpret_u8_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u8_f16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u8_f16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u8_f16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_u8_f16u13__SVFloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_u8_f1613svfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_u8_f1613svfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_u8_f1613svfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svuint8) test_svreinterpret_u8_f16(TYPE(svfloat16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u8,_f16)(op);
}

// CHECK-LABEL: @test_svreinterpret_u8_f32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u8_f32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u8_f32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u8_f32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_u8_f32u13__SVFloat32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_u8_f3213svfloat32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_u8_f3213svfloat32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_u8_f3213svfloat32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svuint8) test_svreinterpret_u8_f32(TYPE(svfloat32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u8,_f32)(op);
}

// CHECK-LABEL: @test_svreinterpret_u8_f64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u8_f64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u8_f64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u8_f64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_u8_f64u13__SVFloat64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_u8_f6413svfloat64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_u8_f6413svfloat64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_u8_f6413svfloat64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svuint8) test_svreinterpret_u8_f64(TYPE(svfloat64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u8,_f64)(op);
}

// CHECK-LABEL: @test_svreinterpret_u16_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u16_s8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u16_s8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u16_s8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_u16_s8u10__SVInt8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_u16_s810svint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_u16_s810svint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_u16_s810svint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svuint16) test_svreinterpret_u16_s8(TYPE(svint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u16,_s8)(op);
}

// CHECK-LABEL: @test_svreinterpret_u16_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 8 x i16> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_u16_s16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_u16_s16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_u16_s16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u16_s16u11__SVInt16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u16_s1611svint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u16_s1611svint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u16_s1611svint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[OP:%.*]]
//
TYPE(svuint16) test_svreinterpret_u16_s16(TYPE(svint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u16,_s16)(op);
}

// CHECK-LABEL: @test_svreinterpret_u16_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u16_s32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u16_s32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u16_s32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u16_s32u11__SVInt32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u16_s3211svint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u16_s3211svint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u16_s3211svint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svuint16) test_svreinterpret_u16_s32(TYPE(svint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u16,_s32)(op);
}

// CHECK-LABEL: @test_svreinterpret_u16_s64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u16_s64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u16_s64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u16_s64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u16_s64u11__SVInt64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u16_s6411svint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u16_s6411svint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u16_s6411svint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svuint16) test_svreinterpret_u16_s64(TYPE(svint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u16,_s64)(op);
}

// CHECK-LABEL: @test_svreinterpret_u16_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u16_u8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u16_u8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u16_u8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_u16_u8u11__SVUint8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_u16_u811svuint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_u16_u811svuint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_u16_u811svuint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svuint16) test_svreinterpret_u16_u8(TYPE(svuint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u16,_u8)(op);
}

// CHECK-LABEL: @test_svreinterpret_u16_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 8 x i16> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_u16_u16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_u16_u16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_u16_u16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u16_u16u12__SVUint16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u16_u1612svuint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u16_u1612svuint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u16_u1612svuint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[OP:%.*]]
//
TYPE(svuint16) test_svreinterpret_u16_u16(TYPE(svuint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u16,_u16)(op);
}

// CHECK-LABEL: @test_svreinterpret_u16_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u16_u32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u16_u32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u16_u32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u16_u32u12__SVUint32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u16_u3212svuint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u16_u3212svuint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u16_u3212svuint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svuint16) test_svreinterpret_u16_u32(TYPE(svuint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u16,_u32)(op);
}

// CHECK-LABEL: @test_svreinterpret_u16_u64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u16_u64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u16_u64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u16_u64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u16_u64u12__SVUint64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u16_u6412svuint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u16_u6412svuint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u16_u6412svuint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svuint16) test_svreinterpret_u16_u64(TYPE(svuint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u16,_u64)(op);
}

// CHECK-LABEL: @test_svreinterpret_u16_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u16_f16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u16_f16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u16_f16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u16_f16u13__SVFloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u16_f1613svfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u16_f1613svfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u16_f1613svfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svuint16) test_svreinterpret_u16_f16(TYPE(svfloat16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u16,_f16)(op);
}

// CHECK-LABEL: @test_svreinterpret_u16_f32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u16_f32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u16_f32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u16_f32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u16_f32u13__SVFloat32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u16_f3213svfloat32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u16_f3213svfloat32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u16_f3213svfloat32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svuint16) test_svreinterpret_u16_f32(TYPE(svfloat32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u16,_f32)(op);
}

// CHECK-LABEL: @test_svreinterpret_u16_f64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u16_f64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u16_f64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u16_f64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u16_f64u13__SVFloat64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u16_f6413svfloat64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u16_f6413svfloat64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u16_f6413svfloat64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svuint16) test_svreinterpret_u16_f64(TYPE(svfloat64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u16,_f64)(op);
}

// CHECK-LABEL: @test_svreinterpret_u32_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u32_s8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u32_s8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u32_s8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_u32_s8u10__SVInt8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_u32_s810svint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_u32_s810svint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_u32_s810svint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svuint32) test_svreinterpret_u32_s8(TYPE(svint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u32,_s8)(op);
}

// CHECK-LABEL: @test_svreinterpret_u32_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u32_s16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u32_s16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u32_s16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u32_s16u11__SVInt16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u32_s1611svint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u32_s1611svint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u32_s1611svint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svuint32) test_svreinterpret_u32_s16(TYPE(svint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u32,_s16)(op);
}

// CHECK-LABEL: @test_svreinterpret_u32_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 4 x i32> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_u32_s32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_u32_s32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_u32_s32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u32_s32u11__SVInt32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u32_s3211svint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u32_s3211svint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u32_s3211svint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[OP:%.*]]
//
TYPE(svuint32) test_svreinterpret_u32_s32(TYPE(svint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u32,_s32)(op);
}

// CHECK-LABEL: @test_svreinterpret_u32_s64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u32_s64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u32_s64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u32_s64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u32_s64u11__SVInt64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u32_s6411svint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u32_s6411svint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u32_s6411svint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svuint32) test_svreinterpret_u32_s64(TYPE(svint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u32,_s64)(op);
}

// CHECK-LABEL: @test_svreinterpret_u32_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u32_u8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u32_u8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u32_u8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_u32_u8u11__SVUint8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_u32_u811svuint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_u32_u811svuint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_u32_u811svuint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svuint32) test_svreinterpret_u32_u8(TYPE(svuint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u32,_u8)(op);
}

// CHECK-LABEL: @test_svreinterpret_u32_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u32_u16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u32_u16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u32_u16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u32_u16u12__SVUint16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u32_u1612svuint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u32_u1612svuint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u32_u1612svuint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svuint32) test_svreinterpret_u32_u16(TYPE(svuint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u32,_u16)(op);
}

// CHECK-LABEL: @test_svreinterpret_u32_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 4 x i32> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_u32_u32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_u32_u32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_u32_u32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u32_u32u12__SVUint32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u32_u3212svuint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u32_u3212svuint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u32_u3212svuint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[OP:%.*]]
//
TYPE(svuint32) test_svreinterpret_u32_u32(TYPE(svuint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u32,_u32)(op);
}

// CHECK-LABEL: @test_svreinterpret_u32_u64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u32_u64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u32_u64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u32_u64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u32_u64u12__SVUint64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u32_u6412svuint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u32_u6412svuint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u32_u6412svuint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svuint32) test_svreinterpret_u32_u64(TYPE(svuint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u32,_u64)(op);
}

// CHECK-LABEL: @test_svreinterpret_u32_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u32_f16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u32_f16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u32_f16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u32_f16u13__SVFloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u32_f1613svfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u32_f1613svfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u32_f1613svfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svuint32) test_svreinterpret_u32_f16(TYPE(svfloat16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u32,_f16)(op);
}

// CHECK-LABEL: @test_svreinterpret_u32_f32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u32_f32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u32_f32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u32_f32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u32_f32u13__SVFloat32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u32_f3213svfloat32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u32_f3213svfloat32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u32_f3213svfloat32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svuint32) test_svreinterpret_u32_f32(TYPE(svfloat32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u32,_f32)(op);
}

// CHECK-LABEL: @test_svreinterpret_u32_f64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u32_f64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u32_f64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u32_f64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u32_f64u13__SVFloat64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u32_f6413svfloat64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u32_f6413svfloat64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u32_f6413svfloat64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svuint32) test_svreinterpret_u32_f64(TYPE(svfloat64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u32,_f64)(op);
}

// CHECK-LABEL: @test_svreinterpret_u64_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u64_s8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u64_s8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u64_s8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_u64_s8u10__SVInt8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_u64_s810svint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_u64_s810svint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_u64_s810svint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svuint64) test_svreinterpret_u64_s8(TYPE(svint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u64,_s8)(op);
}

// CHECK-LABEL: @test_svreinterpret_u64_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u64_s16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u64_s16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u64_s16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u64_s16u11__SVInt16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u64_s1611svint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u64_s1611svint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u64_s1611svint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svuint64) test_svreinterpret_u64_s16(TYPE(svint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u64,_s16)(op);
}

// CHECK-LABEL: @test_svreinterpret_u64_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u64_s32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u64_s32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u64_s32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u64_s32u11__SVInt32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u64_s3211svint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u64_s3211svint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u64_s3211svint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svuint64) test_svreinterpret_u64_s32(TYPE(svint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u64,_s32)(op);
}

// CHECK-LABEL: @test_svreinterpret_u64_s64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 2 x i64> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_u64_s64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_u64_s64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_u64_s64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u64_s64u11__SVInt64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u64_s6411svint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u64_s6411svint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u64_s6411svint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[OP:%.*]]
//
TYPE(svuint64) test_svreinterpret_u64_s64(TYPE(svint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u64,_s64)(op);
}

// CHECK-LABEL: @test_svreinterpret_u64_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u64_u8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u64_u8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u64_u8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_u64_u8u11__SVUint8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_u64_u811svuint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_u64_u811svuint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_u64_u811svuint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svuint64) test_svreinterpret_u64_u8(TYPE(svuint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u64,_u8)(op);
}

// CHECK-LABEL: @test_svreinterpret_u64_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u64_u16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u64_u16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u64_u16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u64_u16u12__SVUint16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u64_u1612svuint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u64_u1612svuint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u64_u1612svuint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svuint64) test_svreinterpret_u64_u16(TYPE(svuint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u64,_u16)(op);
}

// CHECK-LABEL: @test_svreinterpret_u64_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u64_u32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u64_u32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u64_u32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u64_u32u12__SVUint32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u64_u3212svuint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u64_u3212svuint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u64_u3212svuint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svuint64) test_svreinterpret_u64_u32(TYPE(svuint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u64,_u32)(op);
}

// CHECK-LABEL: @test_svreinterpret_u64_u64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 2 x i64> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_u64_u64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_u64_u64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_u64_u64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u64_u64u12__SVUint64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u64_u6412svuint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u64_u6412svuint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u64_u6412svuint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[OP:%.*]]
//
TYPE(svuint64) test_svreinterpret_u64_u64(TYPE(svuint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u64,_u64)(op);
}

// CHECK-LABEL: @test_svreinterpret_u64_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u64_f16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u64_f16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u64_f16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u64_f16u13__SVFloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u64_f1613svfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u64_f1613svfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u64_f1613svfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svuint64) test_svreinterpret_u64_f16(TYPE(svfloat16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u64,_f16)(op);
}

// CHECK-LABEL: @test_svreinterpret_u64_f32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u64_f32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u64_f32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u64_f32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u64_f32u13__SVFloat32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u64_f3213svfloat32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u64_f3213svfloat32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u64_f3213svfloat32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svuint64) test_svreinterpret_u64_f32(TYPE(svfloat32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u64,_f32)(op);
}

// CHECK-LABEL: @test_svreinterpret_u64_f64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u64_f64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u64_f64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u64_f64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u64_f64u13__SVFloat64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u64_f6413svfloat64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u64_f6413svfloat64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u64_f6413svfloat64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svuint64) test_svreinterpret_u64_f64(TYPE(svfloat64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_u64,_f64)(op);
}

// CHECK-LABEL: @test_svreinterpret_f16_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 8 x half>
// CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f16_s8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 16 x half>
// TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f16_s8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 24 x half>
// TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f16_s8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 32 x half>
// TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_f16_s8u10__SVInt8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 8 x half>
// CPP-CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_f16_s810svint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 16 x half>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_f16_s810svint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 24 x half>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_f16_s810svint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 32 x half>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
TYPE(svfloat16) test_svreinterpret_f16_s8(TYPE(svint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f16,_s8)(op);
}

// CHECK-LABEL: @test_svreinterpret_f16_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 8 x half>
// CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f16_s16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 16 x half>
// TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f16_s16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 24 x half>
// TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f16_s16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 32 x half>
// TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f16_s16u11__SVInt16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 8 x half>
// CPP-CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f16_s1611svint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 16 x half>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f16_s1611svint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 24 x half>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f16_s1611svint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 32 x half>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
TYPE(svfloat16) test_svreinterpret_f16_s16(TYPE(svint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f16,_s16)(op);
}

// CHECK-LABEL: @test_svreinterpret_f16_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 8 x half>
// CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f16_s32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 16 x half>
// TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f16_s32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 24 x half>
// TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f16_s32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 32 x half>
// TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f16_s32u11__SVInt32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 8 x half>
// CPP-CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f16_s3211svint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 16 x half>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f16_s3211svint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 24 x half>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f16_s3211svint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 32 x half>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
TYPE(svfloat16) test_svreinterpret_f16_s32(TYPE(svint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f16,_s32)(op);
}

// CHECK-LABEL: @test_svreinterpret_f16_s64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 8 x half>
// CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f16_s64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 16 x half>
// TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f16_s64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 24 x half>
// TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f16_s64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 32 x half>
// TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f16_s64u11__SVInt64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 8 x half>
// CPP-CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f16_s6411svint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 16 x half>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f16_s6411svint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 24 x half>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f16_s6411svint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 32 x half>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
TYPE(svfloat16) test_svreinterpret_f16_s64(TYPE(svint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f16,_s64)(op);
}

// CHECK-LABEL: @test_svreinterpret_f16_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 8 x half>
// CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f16_u8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 16 x half>
// TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f16_u8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 24 x half>
// TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f16_u8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 32 x half>
// TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_f16_u8u11__SVUint8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 8 x half>
// CPP-CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_f16_u811svuint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 16 x half>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_f16_u811svuint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 24 x half>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_f16_u811svuint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 32 x half>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
TYPE(svfloat16) test_svreinterpret_f16_u8(TYPE(svuint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f16,_u8)(op);
}

// CHECK-LABEL: @test_svreinterpret_f16_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 8 x half>
// CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f16_u16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 16 x half>
// TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f16_u16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 24 x half>
// TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f16_u16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 32 x half>
// TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f16_u16u12__SVUint16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 8 x half>
// CPP-CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f16_u1612svuint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 16 x half>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f16_u1612svuint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 24 x half>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f16_u1612svuint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 32 x half>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
TYPE(svfloat16) test_svreinterpret_f16_u16(TYPE(svuint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f16,_u16)(op);
}

// CHECK-LABEL: @test_svreinterpret_f16_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 8 x half>
// CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f16_u32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 16 x half>
// TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f16_u32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 24 x half>
// TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f16_u32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 32 x half>
// TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f16_u32u12__SVUint32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 8 x half>
// CPP-CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f16_u3212svuint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 16 x half>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f16_u3212svuint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 24 x half>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f16_u3212svuint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 32 x half>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
TYPE(svfloat16) test_svreinterpret_f16_u32(TYPE(svuint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f16,_u32)(op);
}

// CHECK-LABEL: @test_svreinterpret_f16_u64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 8 x half>
// CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f16_u64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 16 x half>
// TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f16_u64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 24 x half>
// TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f16_u64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 32 x half>
// TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f16_u64u12__SVUint64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 8 x half>
// CPP-CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f16_u6412svuint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 16 x half>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f16_u6412svuint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 24 x half>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f16_u6412svuint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 32 x half>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
TYPE(svfloat16) test_svreinterpret_f16_u64(TYPE(svuint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f16,_u64)(op);
}

// CHECK-LABEL: @test_svreinterpret_f16_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 8 x half> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_f16_f16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 16 x half> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_f16_f16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 24 x half> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_f16_f16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 32 x half> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f16_f16u13__SVFloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 8 x half> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f16_f1613svfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x half> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f16_f1613svfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x half> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f16_f1613svfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x half> [[OP:%.*]]
//
TYPE(svfloat16) test_svreinterpret_f16_f16(TYPE(svfloat16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f16,_f16)(op);
}

// CHECK-LABEL: @test_svreinterpret_f16_f32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 8 x half>
// CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f16_f32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 16 x half>
// TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f16_f32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 24 x half>
// TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f16_f32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 32 x half>
// TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f16_f32u13__SVFloat32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 8 x half>
// CPP-CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f16_f3213svfloat32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 16 x half>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f16_f3213svfloat32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 24 x half>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f16_f3213svfloat32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 32 x half>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
TYPE(svfloat16) test_svreinterpret_f16_f32(TYPE(svfloat32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f16,_f32)(op);
}

// CHECK-LABEL: @test_svreinterpret_f16_f64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 8 x half>
// CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f16_f64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 16 x half>
// TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f16_f64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 24 x half>
// TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f16_f64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 32 x half>
// TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f16_f64u13__SVFloat64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 8 x half>
// CPP-CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f16_f6413svfloat64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 16 x half>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f16_f6413svfloat64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 24 x half>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f16_f6413svfloat64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 32 x half>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
TYPE(svfloat16) test_svreinterpret_f16_f64(TYPE(svfloat64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f16,_f64)(op);
}

// CHECK-LABEL: @test_svreinterpret_f32_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 4 x float>
// CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f32_s8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 8 x float>
// TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f32_s8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 12 x float>
// TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f32_s8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 16 x float>
// TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_f32_s8u10__SVInt8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 4 x float>
// CPP-CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_f32_s810svint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 8 x float>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_f32_s810svint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 12 x float>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_f32_s810svint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 16 x float>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
TYPE(svfloat32) test_svreinterpret_f32_s8(TYPE(svint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f32,_s8)(op);
}

// CHECK-LABEL: @test_svreinterpret_f32_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 4 x float>
// CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f32_s16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 8 x float>
// TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f32_s16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 12 x float>
// TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f32_s16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 16 x float>
// TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f32_s16u11__SVInt16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 4 x float>
// CPP-CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f32_s1611svint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 8 x float>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f32_s1611svint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 12 x float>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f32_s1611svint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 16 x float>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
TYPE(svfloat32) test_svreinterpret_f32_s16(TYPE(svint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f32,_s16)(op);
}

// CHECK-LABEL: @test_svreinterpret_f32_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 4 x float>
// CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f32_s32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 8 x float>
// TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f32_s32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 12 x float>
// TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f32_s32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 16 x float>
// TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f32_s32u11__SVInt32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 4 x float>
// CPP-CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f32_s3211svint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 8 x float>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f32_s3211svint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 12 x float>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f32_s3211svint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 16 x float>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
TYPE(svfloat32) test_svreinterpret_f32_s32(TYPE(svint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f32,_s32)(op);
}

// CHECK-LABEL: @test_svreinterpret_f32_s64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 4 x float>
// CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f32_s64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 8 x float>
// TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f32_s64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 12 x float>
// TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f32_s64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 16 x float>
// TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f32_s64u11__SVInt64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 4 x float>
// CPP-CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f32_s6411svint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 8 x float>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f32_s6411svint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 12 x float>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f32_s6411svint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 16 x float>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
TYPE(svfloat32) test_svreinterpret_f32_s64(TYPE(svint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f32,_s64)(op);
}

// CHECK-LABEL: @test_svreinterpret_f32_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 4 x float>
// CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f32_u8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 8 x float>
// TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f32_u8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 12 x float>
// TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f32_u8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 16 x float>
// TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_f32_u8u11__SVUint8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 4 x float>
// CPP-CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_f32_u811svuint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 8 x float>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_f32_u811svuint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 12 x float>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_f32_u811svuint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 16 x float>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
TYPE(svfloat32) test_svreinterpret_f32_u8(TYPE(svuint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f32,_u8)(op);
}

// CHECK-LABEL: @test_svreinterpret_f32_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 4 x float>
// CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f32_u16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 8 x float>
// TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f32_u16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 12 x float>
// TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f32_u16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 16 x float>
// TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f32_u16u12__SVUint16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 4 x float>
// CPP-CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f32_u1612svuint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 8 x float>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f32_u1612svuint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 12 x float>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f32_u1612svuint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 16 x float>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
TYPE(svfloat32) test_svreinterpret_f32_u16(TYPE(svuint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f32,_u16)(op);
}

// CHECK-LABEL: @test_svreinterpret_f32_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 4 x float>
// CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f32_u32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 8 x float>
// TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f32_u32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 12 x float>
// TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f32_u32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 16 x float>
// TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f32_u32u12__SVUint32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 4 x float>
// CPP-CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f32_u3212svuint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 8 x float>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f32_u3212svuint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 12 x float>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f32_u3212svuint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 16 x float>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
TYPE(svfloat32) test_svreinterpret_f32_u32(TYPE(svuint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f32,_u32)(op);
}

// CHECK-LABEL: @test_svreinterpret_f32_u64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 4 x float>
// CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f32_u64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 8 x float>
// TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f32_u64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 12 x float>
// TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f32_u64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 16 x float>
// TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f32_u64u12__SVUint64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 4 x float>
// CPP-CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f32_u6412svuint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 8 x float>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f32_u6412svuint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 12 x float>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f32_u6412svuint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 16 x float>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
TYPE(svfloat32) test_svreinterpret_f32_u64(TYPE(svuint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f32,_u64)(op);
}

// CHECK-LABEL: @test_svreinterpret_f32_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 4 x float>
// CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f32_f16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 8 x float>
// TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f32_f16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 12 x float>
// TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f32_f16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 16 x float>
// TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f32_f16u13__SVFloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 4 x float>
// CPP-CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f32_f1613svfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 8 x float>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f32_f1613svfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 12 x float>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f32_f1613svfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 16 x float>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
TYPE(svfloat32) test_svreinterpret_f32_f16(TYPE(svfloat16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f32,_f16)(op);
}

// CHECK-LABEL: @test_svreinterpret_f32_f32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 4 x float> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_f32_f32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 8 x float> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_f32_f32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 12 x float> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_f32_f32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 16 x float> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f32_f32u13__SVFloat32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 4 x float> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f32_f3213svfloat32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x float> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f32_f3213svfloat32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x float> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f32_f3213svfloat32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x float> [[OP:%.*]]
//
TYPE(svfloat32) test_svreinterpret_f32_f32(TYPE(svfloat32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f32,_f32)(op);
}

// CHECK-LABEL: @test_svreinterpret_f32_f64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 4 x float>
// CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f32_f64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 8 x float>
// TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f32_f64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 12 x float>
// TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f32_f64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 16 x float>
// TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f32_f64u13__SVFloat64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 4 x float>
// CPP-CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f32_f6413svfloat64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 8 x float>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f32_f6413svfloat64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 12 x float>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f32_f6413svfloat64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 16 x float>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
TYPE(svfloat32) test_svreinterpret_f32_f64(TYPE(svfloat64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f32,_f64)(op);
}

// CHECK-LABEL: @test_svreinterpret_f64_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 2 x double>
// CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f64_s8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 4 x double>
// TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f64_s8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 6 x double>
// TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f64_s8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 8 x double>
// TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_f64_s8u10__SVInt8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 2 x double>
// CPP-CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_f64_s810svint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 4 x double>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_f64_s810svint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 6 x double>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_f64_s810svint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 8 x double>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
TYPE(svfloat64) test_svreinterpret_f64_s8(TYPE(svint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f64,_s8)(op);
}

// CHECK-LABEL: @test_svreinterpret_f64_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 2 x double>
// CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f64_s16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 4 x double>
// TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f64_s16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 6 x double>
// TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f64_s16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 8 x double>
// TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f64_s16u11__SVInt16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 2 x double>
// CPP-CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f64_s1611svint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 4 x double>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f64_s1611svint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 6 x double>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f64_s1611svint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 8 x double>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
TYPE(svfloat64) test_svreinterpret_f64_s16(TYPE(svint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f64,_s16)(op);
}

// CHECK-LABEL: @test_svreinterpret_f64_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 2 x double>
// CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f64_s32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 4 x double>
// TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f64_s32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 6 x double>
// TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f64_s32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 8 x double>
// TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f64_s32u11__SVInt32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 2 x double>
// CPP-CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f64_s3211svint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 4 x double>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f64_s3211svint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 6 x double>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f64_s3211svint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 8 x double>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
TYPE(svfloat64) test_svreinterpret_f64_s32(TYPE(svint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f64,_s32)(op);
}

// CHECK-LABEL: @test_svreinterpret_f64_s64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 2 x double>
// CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f64_s64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 4 x double>
// TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f64_s64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 6 x double>
// TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f64_s64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 8 x double>
// TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f64_s64u11__SVInt64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 2 x double>
// CPP-CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f64_s6411svint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 4 x double>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f64_s6411svint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 6 x double>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f64_s6411svint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 8 x double>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
TYPE(svfloat64) test_svreinterpret_f64_s64(TYPE(svint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f64,_s64)(op);
}

// CHECK-LABEL: @test_svreinterpret_f64_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 2 x double>
// CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f64_u8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 4 x double>
// TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f64_u8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 6 x double>
// TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f64_u8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 8 x double>
// TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z25test_svreinterpret_f64_u8u11__SVUint8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 2 x double>
// CPP-CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z25test_svreinterpret_f64_u811svuint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 4 x double>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z25test_svreinterpret_f64_u811svuint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 6 x double>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z25test_svreinterpret_f64_u811svuint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 8 x double>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
TYPE(svfloat64) test_svreinterpret_f64_u8(TYPE(svuint8) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f64,_u8)(op);
}

// CHECK-LABEL: @test_svreinterpret_f64_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 2 x double>
// CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f64_u16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 4 x double>
// TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f64_u16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 6 x double>
// TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f64_u16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 8 x double>
// TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f64_u16u12__SVUint16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 2 x double>
// CPP-CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f64_u1612svuint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 4 x double>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f64_u1612svuint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 6 x double>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f64_u1612svuint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 8 x double>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
TYPE(svfloat64) test_svreinterpret_f64_u16(TYPE(svuint16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f64,_u16)(op);
}

// CHECK-LABEL: @test_svreinterpret_f64_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 2 x double>
// CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f64_u32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 4 x double>
// TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f64_u32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 6 x double>
// TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f64_u32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 8 x double>
// TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f64_u32u12__SVUint32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 2 x double>
// CPP-CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f64_u3212svuint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 4 x double>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f64_u3212svuint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 6 x double>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f64_u3212svuint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 8 x double>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
TYPE(svfloat64) test_svreinterpret_f64_u32(TYPE(svuint32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f64,_u32)(op);
}

// CHECK-LABEL: @test_svreinterpret_f64_u64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 2 x double>
// CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f64_u64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 4 x double>
// TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f64_u64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 6 x double>
// TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f64_u64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 8 x double>
// TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f64_u64u12__SVUint64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 2 x double>
// CPP-CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f64_u6412svuint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 4 x double>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f64_u6412svuint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 6 x double>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f64_u6412svuint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 8 x double>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
TYPE(svfloat64) test_svreinterpret_f64_u64(TYPE(svuint64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f64,_u64)(op);
}

// CHECK-LABEL: @test_svreinterpret_f64_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 2 x double>
// CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f64_f16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 4 x double>
// TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f64_f16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 6 x double>
// TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f64_f16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 8 x double>
// TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f64_f16u13__SVFloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 2 x double>
// CPP-CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f64_f1613svfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 4 x double>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f64_f1613svfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 6 x double>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f64_f1613svfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 8 x double>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
TYPE(svfloat64) test_svreinterpret_f64_f16(TYPE(svfloat16) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f64,_f16)(op);
}

// CHECK-LABEL: @test_svreinterpret_f64_f32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 2 x double>
// CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f64_f32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 4 x double>
// TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f64_f32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 6 x double>
// TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f64_f32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 8 x double>
// TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f64_f32u13__SVFloat32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 2 x double>
// CPP-CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f64_f3213svfloat32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 4 x double>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f64_f3213svfloat32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 6 x double>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f64_f3213svfloat32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 8 x double>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
TYPE(svfloat64) test_svreinterpret_f64_f32(TYPE(svfloat32) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f64,_f32)(op);
}

// CHECK-LABEL: @test_svreinterpret_f64_f64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 2 x double> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_f64_f64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 4 x double> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_f64_f64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 6 x double> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_f64_f64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 8 x double> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_f64_f64u13__SVFloat64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 2 x double> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_f64_f6413svfloat64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x double> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_f64_f6413svfloat64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x double> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_f64_f6413svfloat64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x double> [[OP:%.*]]
//
TYPE(svfloat64) test_svreinterpret_f64_f64(TYPE(svfloat64) op)
{
  return SVE_ACLE_FUNC(svreinterpret_f64,_f64)(op);
}
