// SPDX-License-Identifier: GPL-2.0
// Generated by xdrgen. Manual edits will be lost.
// XDR specification file: ../../Documentation/sunrpc/xdr/nfs4_1.x
// XDR specification modification time: Mon Oct 14 09:10:13 2024

#include <linux/sunrpc/svc.h>

#include "nfs4xdr_gen.h"

static bool __maybe_unused
xdrgen_decode_int64_t(struct xdr_stream *xdr, int64_t *ptr)
{
	return xdrgen_decode_hyper(xdr, ptr);
};

static bool __maybe_unused
xdrgen_decode_uint32_t(struct xdr_stream *xdr, uint32_t *ptr)
{
	return xdrgen_decode_unsigned_int(xdr, ptr);
};

static bool __maybe_unused
xdrgen_decode_bitmap4(struct xdr_stream *xdr, bitmap4 *ptr)
{
	if (xdr_stream_decode_u32(xdr, &ptr->count) < 0)
		return false;
	for (u32 i = 0; i < ptr->count; i++)
		if (!xdrgen_decode_uint32_t(xdr, &ptr->element[i]))
			return false;
	return true;
};

static bool __maybe_unused
xdrgen_decode_nfstime4(struct xdr_stream *xdr, struct nfstime4 *ptr)
{
	if (!xdrgen_decode_int64_t(xdr, &ptr->seconds))
		return false;
	if (!xdrgen_decode_uint32_t(xdr, &ptr->nseconds))
		return false;
	return true;
};

static bool __maybe_unused
xdrgen_decode_fattr4_offline(struct xdr_stream *xdr, fattr4_offline *ptr)
{
	return xdrgen_decode_bool(xdr, ptr);
};

static bool __maybe_unused
xdrgen_decode_open_arguments4(struct xdr_stream *xdr, struct open_arguments4 *ptr)
{
	if (!xdrgen_decode_bitmap4(xdr, &ptr->oa_share_access))
		return false;
	if (!xdrgen_decode_bitmap4(xdr, &ptr->oa_share_deny))
		return false;
	if (!xdrgen_decode_bitmap4(xdr, &ptr->oa_share_access_want))
		return false;
	if (!xdrgen_decode_bitmap4(xdr, &ptr->oa_open_claim))
		return false;
	if (!xdrgen_decode_bitmap4(xdr, &ptr->oa_create_mode))
		return false;
	return true;
};

static bool __maybe_unused
xdrgen_decode_open_args_share_access4(struct xdr_stream *xdr, open_args_share_access4 *ptr)
{
	u32 val;

	if (xdr_stream_decode_u32(xdr, &val) < 0)
		return false;
	*ptr = val;
	return true;
}

static bool __maybe_unused
xdrgen_decode_open_args_share_deny4(struct xdr_stream *xdr, open_args_share_deny4 *ptr)
{
	u32 val;

	if (xdr_stream_decode_u32(xdr, &val) < 0)
		return false;
	*ptr = val;
	return true;
}

static bool __maybe_unused
xdrgen_decode_open_args_share_access_want4(struct xdr_stream *xdr, open_args_share_access_want4 *ptr)
{
	u32 val;

	if (xdr_stream_decode_u32(xdr, &val) < 0)
		return false;
	*ptr = val;
	return true;
}

static bool __maybe_unused
xdrgen_decode_open_args_open_claim4(struct xdr_stream *xdr, open_args_open_claim4 *ptr)
{
	u32 val;

	if (xdr_stream_decode_u32(xdr, &val) < 0)
		return false;
	*ptr = val;
	return true;
}

static bool __maybe_unused
xdrgen_decode_open_args_createmode4(struct xdr_stream *xdr, open_args_createmode4 *ptr)
{
	u32 val;

	if (xdr_stream_decode_u32(xdr, &val) < 0)
		return false;
	*ptr = val;
	return true;
}

bool
xdrgen_decode_fattr4_open_arguments(struct xdr_stream *xdr, fattr4_open_arguments *ptr)
{
	return xdrgen_decode_open_arguments4(xdr, ptr);
};

bool
xdrgen_decode_fattr4_time_deleg_access(struct xdr_stream *xdr, fattr4_time_deleg_access *ptr)
{
	return xdrgen_decode_nfstime4(xdr, ptr);
};

bool
xdrgen_decode_fattr4_time_deleg_modify(struct xdr_stream *xdr, fattr4_time_deleg_modify *ptr)
{
	return xdrgen_decode_nfstime4(xdr, ptr);
};

static bool __maybe_unused
xdrgen_decode_open_delegation_type4(struct xdr_stream *xdr, open_delegation_type4 *ptr)
{
	u32 val;

	if (xdr_stream_decode_u32(xdr, &val) < 0)
		return false;
	*ptr = val;
	return true;
}

static bool __maybe_unused
xdrgen_encode_int64_t(struct xdr_stream *xdr, const int64_t value)
{
	return xdrgen_encode_hyper(xdr, value);
};

static bool __maybe_unused
xdrgen_encode_uint32_t(struct xdr_stream *xdr, const uint32_t value)
{
	return xdrgen_encode_unsigned_int(xdr, value);
};

static bool __maybe_unused
xdrgen_encode_bitmap4(struct xdr_stream *xdr, const bitmap4 value)
{
	if (xdr_stream_encode_u32(xdr, value.count) != XDR_UNIT)
		return false;
	for (u32 i = 0; i < value.count; i++)
		if (!xdrgen_encode_uint32_t(xdr, value.element[i]))
			return false;
	return true;
};

static bool __maybe_unused
xdrgen_encode_nfstime4(struct xdr_stream *xdr, const struct nfstime4 *value)
{
	if (!xdrgen_encode_int64_t(xdr, value->seconds))
		return false;
	if (!xdrgen_encode_uint32_t(xdr, value->nseconds))
		return false;
	return true;
};

static bool __maybe_unused
xdrgen_encode_fattr4_offline(struct xdr_stream *xdr, const fattr4_offline value)
{
	return xdrgen_encode_bool(xdr, value);
};

static bool __maybe_unused
xdrgen_encode_open_arguments4(struct xdr_stream *xdr, const struct open_arguments4 *value)
{
	if (!xdrgen_encode_bitmap4(xdr, value->oa_share_access))
		return false;
	if (!xdrgen_encode_bitmap4(xdr, value->oa_share_deny))
		return false;
	if (!xdrgen_encode_bitmap4(xdr, value->oa_share_access_want))
		return false;
	if (!xdrgen_encode_bitmap4(xdr, value->oa_open_claim))
		return false;
	if (!xdrgen_encode_bitmap4(xdr, value->oa_create_mode))
		return false;
	return true;
};

static bool __maybe_unused
xdrgen_encode_open_args_share_access4(struct xdr_stream *xdr, open_args_share_access4 value)
{
	return xdr_stream_encode_u32(xdr, value) == XDR_UNIT;
}

static bool __maybe_unused
xdrgen_encode_open_args_share_deny4(struct xdr_stream *xdr, open_args_share_deny4 value)
{
	return xdr_stream_encode_u32(xdr, value) == XDR_UNIT;
}

static bool __maybe_unused
xdrgen_encode_open_args_share_access_want4(struct xdr_stream *xdr, open_args_share_access_want4 value)
{
	return xdr_stream_encode_u32(xdr, value) == XDR_UNIT;
}

static bool __maybe_unused
xdrgen_encode_open_args_open_claim4(struct xdr_stream *xdr, open_args_open_claim4 value)
{
	return xdr_stream_encode_u32(xdr, value) == XDR_UNIT;
}

static bool __maybe_unused
xdrgen_encode_open_args_createmode4(struct xdr_stream *xdr, open_args_createmode4 value)
{
	return xdr_stream_encode_u32(xdr, value) == XDR_UNIT;
}

bool
xdrgen_encode_fattr4_open_arguments(struct xdr_stream *xdr, const fattr4_open_arguments *value)
{
	return xdrgen_encode_open_arguments4(xdr, value);
};

bool
xdrgen_encode_fattr4_time_deleg_access(struct xdr_stream *xdr, const fattr4_time_deleg_access *value)
{
	return xdrgen_encode_nfstime4(xdr, value);
};

bool
xdrgen_encode_fattr4_time_deleg_modify(struct xdr_stream *xdr, const fattr4_time_deleg_modify *value)
{
	return xdrgen_encode_nfstime4(xdr, value);
};

static bool __maybe_unused
xdrgen_encode_open_delegation_type4(struct xdr_stream *xdr, open_delegation_type4 value)
{
	return xdr_stream_encode_u32(xdr, value) == XDR_UNIT;
}
