static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * 2002, 2014 (c) Øyvind Kolås pippin@gimp.org                              \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_color (from_0, _(\"From 0\"), \"black\")                             \n"
"property_color (to_0, _(\"To 0\"), \"black\")                                 \n"
"property_double (weight_0, _(\"weight 0\"), 100.0)                            \n"
"             ui_range (0.0, 220.0)                                            \n"
"property_color (from_1, _(\"From 1\"), \"black\")                             \n"
"property_color (to_1, _(\"To 1\"), \"black\")                                 \n"
"property_double (weight_1, _(\"weight 1\"), 100.0)                            \n"
"             ui_range (0.0, 220.0)                                            \n"
"property_color (from_2, _(\"From 2\"), \"black\")                             \n"
"property_color (to_2, _(\"To 2\"), \"black\")                                 \n"
"property_double (weight_2, _(\"weight 2\"), 100.0)                            \n"
"             ui_range (0.0, 220.0)                                            \n"
"property_color (from_3, _(\"From 3\"), \"black\")                             \n"
"property_color (to_3, _(\"To 3\"), \"black\")                                 \n"
"property_double (weight_3, _(\"weight 3\"), 100.0)                            \n"
"             ui_range (0.0, 220.0)                                            \n"
"property_color (from_4, _(\"From 4\"), \"black\")                             \n"
"property_color (to_4, _(\"To 4\"), \"black\")                                 \n"
"property_double (weight_4, _(\"weight 4\"), 100.0)                            \n"
"             ui_range (0.0, 220.0)                                            \n"
"property_color (from_5, _(\"From 5\"), \"black\")                             \n"
"property_color (to_5, _(\"To 5\"), \"black\")                                 \n"
"property_double (weight_5, _(\"weight 5\"), 100.0)                            \n"
"             ui_range (0.0, 220.0)                                            \n"
"property_color (from_6, _(\"From 6\"), \"black\")                             \n"
"property_color (to_6, _(\"To 6\"), \"black\")                                 \n"
"property_double (weight_6, _(\"weight 6\"), 100.0)                            \n"
"             ui_range (0.0, 220.0)                                            \n"
"property_color (from_7, _(\"From 7\"), \"black\")                             \n"
"property_color (to_7, _(\"To 7\"), \"black\")                                 \n"
"property_double (weight_7, _(\"weight 7\"), 100.0)                            \n"
"             ui_range (0.0, 220.0)                                            \n"
"property_double (weight, _(\"global weight scale\"), 1.0)                     \n"
"             ui_range (0.0, 1.0)                                              \n"
"property_double (amount, _(\"amount\"), 1.0)                                  \n"
"             ui_range (0.0, 1.0)                                              \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_C_SOURCE color-warp.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#define MAX_PAIRS 1024                                                        \n"
"                                                                              \n"
"typedef struct CoordPair {                                                    \n"
"  float a[3];                                                                 \n"
"  float b[3];                                                                 \n"
"  float weight;                                                               \n"
"} CoordPair;                                                                  \n"
"                                                                              \n"
"typedef struct CoordWarp {                                                    \n"
"  CoordPair pair[MAX_PAIRS];                                                  \n"
"  int count;                                                                  \n"
"} CoordWarp;                                                                  \n"
"                                                                              \n"
"static CoordWarp *cw_new (void)                                               \n"
"{                                                                             \n"
"  CoordWarp *cw;                                                              \n"
"  cw = calloc (sizeof (CoordWarp), 1);                                        \n"
"  return cw;                                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"static void cw_clear_pairs (CoordWarp   *cw)                                  \n"
"{                                                                             \n"
"  cw->count = 0;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void cw_destroy (CoordWarp   *cw)                                      \n"
"{                                                                             \n"
"  free (cw);                                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"static void cw_add_pair (CoordWarp   *cw,                                     \n"
"                         const float *coord_a,                                \n"
"                         const float *coord_b,                                \n"
"                         float        weight)                                 \n"
"{                                                                             \n"
"  int d;                                                                      \n"
"  if (cw->count +1 >= MAX_PAIRS)                                              \n"
"    return;                                                                   \n"
"  for (d = 0; d < 3; d++)                                                     \n"
"    cw->pair[cw->count].a[d] = coord_a[d];                                    \n"
"  for (d = 0; d < 3; d++)                                                     \n"
"    cw->pair[cw->count].b[d] = coord_b[d];                                    \n"
"  cw->pair[cw->count].weight = weight;                                        \n"
"  cw->count++;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static inline float sq_dist (CoordWarp *cw, const float *coord_a, const float *coord_b)\n"
"{                                                                             \n"
"  int d;                                                                      \n"
"  float sq_sum = 0;                                                           \n"
"  for (d = 0; d < 3; d++)                                                     \n"
"    sq_sum += (coord_b[d] - coord_a[d]) * (coord_b[d] - coord_a[d]);          \n"
"  return sq_sum;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static inline float calc_weight (float dist, float lowest_dist, float coord_weight)\n"
"{                                                                             \n"
"  float influence = coord_weight;                                             \n"
"  return expf (-dist / influence);                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static void cw_map (CoordWarp   *cw,                                          \n"
"                    const float *coord_a,                                     \n"
"                    float       *coord_b)                                     \n"
"{                                                                             \n"
"  int i;                                                                      \n"
"  int lowest_dist_no = 0;                                                     \n"
"  double lowest_dist = 12345678900000.0;                                      \n"
"  double sum_wc = 0.0;                                                        \n"
"  float warp[3] = {0,};                                                       \n"
"                                                                              \n"
"  for (i = 0; i < cw->count; i++)                                             \n"
"  {                                                                           \n"
"    float sqd = sq_dist (cw, coord_a, cw->pair[i].a);                         \n"
"    if (sqd < lowest_dist)                                                    \n"
"    {                                                                         \n"
"      lowest_dist = sqd;                                                      \n"
"      lowest_dist_no = i;                                                     \n"
"    }                                                                         \n"
"  }                                                                           \n"
"                                                                              \n"
"  for (i = 0; i < cw->count; i++)                                             \n"
"  {                                                                           \n"
"    float sqd = sq_dist (cw, coord_a, cw->pair[i].a);                         \n"
"    sum_wc += lowest_dist / sqd;                                              \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (lowest_dist > 0.0)                                                      \n"
"  {                                                                           \n"
"    for (i = 0; i < cw->count; i++)                                           \n"
"    {                                                                         \n"
"      int d;                                                                  \n"
"      float sqd = sq_dist (cw, coord_a, cw->pair[i].a);                       \n"
"      float weight = calc_weight (sqd, lowest_dist, cw->pair[i].weight);      \n"
"      weight = weight / sum_wc;                                               \n"
"                                                                              \n"
"      for (d = 0; d < 3; d++)                                                 \n"
"        warp[d] += (cw->pair[i].a[d] - cw->pair[i].b[d]) * weight;            \n"
"    }                                                                         \n"
"  }                                                                           \n"
"  else                                                                        \n"
"  {                                                                           \n"
"    int d;                                                                    \n"
"    for (d = 0; d < 3; d++)                                                   \n"
"      warp[d] = (cw->pair[lowest_dist_no].a[d] - cw->pair[lowest_dist_no].b[d]);\n"
"  }                                                                           \n"
"                                                                              \n"
"  {                                                                           \n"
"    int d;                                                                    \n"
"    for (d = 0; d < 3; d++)                                                   \n"
"      coord_b[d] = coord_a[d] - warp[d];                                      \n"
"  }                                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void maybe_add_pair (CoordWarp *cw,                                    \n"
"                            GeglColor *colorA,                                \n"
"                            GeglColor *colorB,                                \n"
"                            float      weight)                                \n"
"{                                                                             \n"
"  gfloat from[4];                                                             \n"
"  gfloat to[4];                                                               \n"
"  const Babl *colorformat = babl_format(\"CIE Lab float\");                   \n"
"  gegl_color_get_pixel (colorA, colorformat, from);                           \n"
"  gegl_color_get_pixel (colorB, colorformat, to);                             \n"
"  if (from[0] == 0.0 &&                                                       \n"
"      from[1] == 0.0 &&                                                       \n"
"      from[2] == 0.0 &&                                                       \n"
"      to[0] == 0.0 &&                                                         \n"
"      to[1] == 0.0 &&                                                         \n"
"      to[2] == 0.0)                                                           \n"
"  {                                                                           \n"
"  }                                                                           \n"
"  else                                                                        \n"
"  {                                                                           \n"
"    cw_add_pair (cw, from, to, weight);                                       \n"
"  }                                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  CoordWarp *cw;                                                              \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  const Babl *format = babl_format (\"CIE Lab float\");                       \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"                                                                              \n"
"  if (o->user_data == NULL)                                                   \n"
"    o->user_data = cw_new ();                                                 \n"
"  cw = o->user_data;                                                          \n"
"                                                                              \n"
"  cw_clear_pairs (cw);                                                        \n"
"  maybe_add_pair (cw, o->from_0, o->to_0, o->weight * o->weight_0);           \n"
"  maybe_add_pair (cw, o->from_1, o->to_1, o->weight * o->weight_1);           \n"
"  maybe_add_pair (cw, o->from_2, o->to_2, o->weight * o->weight_2);           \n"
"  maybe_add_pair (cw, o->from_3, o->to_3, o->weight * o->weight_3);           \n"
"  maybe_add_pair (cw, o->from_4, o->to_4, o->weight * o->weight_4);           \n"
"  maybe_add_pair (cw, o->from_5, o->to_5, o->weight * o->weight_5);           \n"
"  maybe_add_pair (cw, o->from_6, o->to_6, o->weight * o->weight_6);           \n"
"  maybe_add_pair (cw, o->from_7, o->to_7, o->weight * o->weight_7);           \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      cw_destroy (o->user_data);                                              \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o         = GEGL_PROPERTIES (op);                           \n"
"  gfloat         *in_pixel  = in_buf;                                         \n"
"  gfloat         *out_pixel = out_buf;                                        \n"
"  CoordWarp      *cw        = o->user_data;                                   \n"
"  float           amount    = o->amount;                                      \n"
"                                                                              \n"
"  in_pixel  = in_buf;                                                         \n"
"  out_pixel = out_buf;                                                        \n"
"                                                                              \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      if (amount == 1.0)                                                      \n"
"      {                                                                       \n"
"        cw_map (cw, in_pixel, out_pixel);                                     \n"
"      }                                                                       \n"
"      else                                                                    \n"
"      {                                                                       \n"
"        int d;                                                                \n"
"        float res[4];                                                         \n"
"        cw_map (cw, in_pixel, res);                                           \n"
"        for (d = 0; d < 3; d++)                                               \n"
"          out_pixel[d] = in_pixel[d] * (1.0-amount) + res[d] * amount;        \n"
"      }                                                                       \n"
"      in_pixel  += 3;                                                         \n"
"      out_pixel += 3;                                                         \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass                  *object_class;                                \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  object_class       = G_OBJECT_CLASS (klass);                                \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"  object_class->finalize      = finalize;                                     \n"
"  operation_class->prepare    = prepare;                                      \n"
"  point_filter_class->process = process;                                      \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:color-warp\",                                     \n"
"    \"title\",       _(\"Color warp\"),                                       \n"
"    \"categories\",  \"color\",                                               \n"
"    \"description\", _(\"Warps the colors of an image between colors with weighted distortion factors.\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
