// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

// This file is used by Code Analysis to maintain SuppressMessage
// attributes that are applied to this project.
// Project-level suppressions either have no target or are given
// a specific target and scoped to a namespace, type, member, etc.

using System.Diagnostics.CodeAnalysis;

[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> AutoCompleteResourceV2FeedProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.AutoCompleteResourceV2FeedProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1308:In method 'IdStartsWith', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.AutoCompleteResourceV3.IdStartsWith(System.String,System.Boolean,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{System.String}}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'bool.ToString()' could vary based on the current user's locale settings. Replace this call in 'AutoCompleteResourceV3.IdStartsWith(string, bool, ILogger, CancellationToken)' with a call to 'bool.ToString(IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.AutoCompleteResourceV3.IdStartsWith(System.String,System.Boolean,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{System.String}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> AutoCompleteResourceV3Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.AutoCompleteResourceV3Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'CachingSourceProvider.CachingSourceProvider(IPackageSourceProvider packageSourceProvider)', validate parameter 'packageSourceProvider' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.CachingSourceProvider.#ctor(NuGet.Configuration.IPackageSourceProvider)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void CachingSourceProvider.AddSourceRepository(SourceRepository source)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.CachingSourceProvider.AddSourceRepository(NuGet.Protocol.Core.Types.SourceRepository)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'SourceRepository CachingSourceProvider.CreateRepository(PackageSource source, FeedType type)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.CachingSourceProvider.CreateRepository(NuGet.Configuration.PackageSource,NuGet.Protocol.FeedType)~NuGet.Protocol.Core.Types.SourceRepository")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string CachingUtility.ComputeHash(string value, bool addIdentifiableCharacters = true)', validate parameter 'value' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.CachingUtility.ComputeHash(System.String,System.Boolean)~System.String")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'IsFileAlreadyOpen' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.CachingUtility.IsFileAlreadyOpen(System.String)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1303:Method 'DownloadResourceResult.DownloadResourceResult(DownloadResourceResultStatus status)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message, string paramName)'. Retrieve the following string(s) from a resource table instead: \"A stream should be provided when the result is available.\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.DownloadResourceResult.#ctor(NuGet.Protocol.Core.Types.DownloadResourceResultStatus)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'FindPackageByIdDependencyInfo FindPackageByIdResource.GetDependencyInfo(NuspecReader reader)', validate parameter 'reader' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.FindPackageByIdResource.GetDependencyInfo(NuGet.Packaging.NuspecReader)~NuGet.Protocol.Core.Types.FindPackageByIdDependencyInfo")]
[assembly: SuppressMessage("Build", "CA1307:The behavior of 'string.Equals(string)' could vary based on the current user's locale settings. Replace this call in 'NuGet.Protocol.Core.Types.OfflineFeedUtility.AddPackageToSource(NuGet.Protocol.Core.Types.OfflineFeedAddContext, System.Threading.CancellationToken)' with a call to 'string.Equals(string, System.StringComparison)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.OfflineFeedUtility.AddPackageToSource(NuGet.Protocol.Core.Types.OfflineFeedAddContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string OfflineFeedUtility.GetPackageDirectory(PackageIdentity packageIdentity, string offlineFeed)', validate parameter 'packageIdentity' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.OfflineFeedUtility.GetPackageDirectory(NuGet.Packaging.Core.PackageIdentity,System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageSearchMetadataBuilder PackageSearchMetadataBuilder.FromIdentity(PackageIdentity identity)', validate parameter 'identity' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PackageSearchMetadataBuilder.FromIdentity(NuGet.Packaging.Core.PackageIdentity)~NuGet.Protocol.Core.Types.PackageSearchMetadataBuilder")]
[assembly: SuppressMessage("Build", "CA1822:Member ConvertSkipDuplicateParamToHttpStatusCode does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PackageUpdateResource.ConvertSkipDuplicateParamToHttpStatusCode(System.Boolean)~System.Nullable{System.Net.HttpStatusCode}")]
[assembly: SuppressMessage("Build", "CA2000:Call System.IDisposable.Dispose on object created by 'new StreamContent(fileStream)' before all references to it are out of scope.", Justification = "The responsibility to dispose the object is transferred to another object or wrapper that's created in the method and returned to the caller", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PackageUpdateResource.CreateRequest(System.Uri,System.String,System.String,NuGet.Common.ILogger)~System.Net.Http.HttpRequestMessage")]
[assembly: SuppressMessage("Build", "CA1822:Member CreateRequest does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PackageUpdateResource.CreateRequest(System.Uri,System.String,System.String,NuGet.Common.ILogger)~System.Net.Http.HttpRequestMessage")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object, object, object)' could vary based on the current user's locale settings. Replace this call in 'PackageUpdateResource.Delete(string, string, Func<string, string>, Func<string, bool>, bool, ILogger)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PackageUpdateResource.Delete(System.String,System.String,System.Func{System.String,System.String},System.Func{System.String,System.Boolean},System.Boolean,NuGet.Common.ILogger)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task PackageUpdateResource.Delete(string packageId, string packageVersion, Func<string, string> getApiKey, Func<string, bool> confirm, bool noServiceEndpoint, ILogger log)', validate parameter 'getApiKey' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PackageUpdateResource.Delete(System.String,System.String,System.Func{System.String,System.String},System.Func{System.String,System.Boolean},System.Boolean,NuGet.Common.ILogger)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1801:Parameter logger of method DeletePackageFromFileSystem is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PackageUpdateResource.DeletePackageFromFileSystem(System.String,System.String,System.String,NuGet.Common.ILogger)")]
[assembly: SuppressMessage("Build", "CA1822:Member ForceDeleteFile does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PackageUpdateResource.ForceDeleteFile(System.String)")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object, object)' could vary based on the current user's locale settings. Replace this call in 'PackageUpdateResource.GetSecureApiKey(PackageIdentity, string, bool, TimeSpan, ILogger, CancellationToken)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PackageUpdateResource.GetSecureApiKey(NuGet.Packaging.Core.PackageIdentity,System.String,System.Boolean,System.TimeSpan,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.String}")]
[assembly: SuppressMessage("Build", "CA1822:Member GetServiceEndpointUrl does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PackageUpdateResource.GetServiceEndpointUrl(System.String,System.String,System.Boolean)~System.Uri")]
[assembly: SuppressMessage("Build", "CA1822:Member IsSourceNuGetSymbolServer does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PackageUpdateResource.IsSourceNuGetSymbolServer(System.String)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1822:Member IsV2LocalRepository does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PackageUpdateResource.IsV2LocalRepository(System.String)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task PackageUpdateResource.Push(string packagePath, string symbolSource, int timeoutInSecond, bool disableBuffering, Func<string, string> getApiKey, Func<string, string> getSymbolApiKey, bool noServiceEndpoint, bool skipDuplicate, SymbolPackageUpdateResourceV3 symbolPackageUpdateResource, ILogger log)', validate parameter 'getApiKey' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PackageUpdateResource.Push(System.String,System.String,System.Int32,System.Boolean,System.Func{System.String,System.String},System.Func{System.String,System.String},System.Boolean,System.Boolean,NuGet.Protocol.Core.Types.SymbolPackageUpdateResourceV3,NuGet.Common.ILogger)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1801:Parameter packageSize of method PushPackageToServer is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PackageUpdateResource.PushPackageToServer(System.String,System.String,System.String,System.Int64,System.Boolean,System.Boolean,System.TimeSpan,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1308:In method 'CreatePackageInfo', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PluginFindPackageByIdResource.CreatePackageInfo(System.String,System.String,System.String)~NuGet.Protocol.Core.Types.PluginFindPackageByIdResource.PackageInfo")]
[assembly: SuppressMessage("Build", "CA1822:Member CreatePackageInfo does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PluginFindPackageByIdResource.CreatePackageInfo(System.String,System.String,System.String)~NuGet.Protocol.Core.Types.PluginFindPackageByIdResource.PackageInfo")]
[assembly: SuppressMessage("Build", "CA1801:Parameter cacheContext of method FindPackagesByIdAsync is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.PluginFindPackageByIdResource.FindPackagesByIdAsync(System.String,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.SortedDictionary{NuGet.Versioning.NuGetVersion,NuGet.Protocol.Core.Types.PluginFindPackageByIdResource.PackageInfo}}")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter contentUri of method RemoteSourceDependencyInfo.RemoteSourceDependencyInfo(PackageIdentity, bool, IEnumerable<PackageDependencyGroup>, string) from string to System.Uri, or provide an overload to RemoteSourceDependencyInfo.RemoteSourceDependencyInfo(PackageIdentity, bool, IEnumerable<PackageDependencyGroup>, string) that allows contentUri to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.RemoteSourceDependencyInfo.#ctor(NuGet.Packaging.Core.PackageIdentity,System.Boolean,System.Collections.Generic.IEnumerable{NuGet.Packaging.PackageDependencyGroup},System.String)")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter sourceUrl of method Repository.CreateSource(IEnumerable<Lazy<INuGetResourceProvider>>, string) from string to System.Uri, or provide an overload to Repository.CreateSource(IEnumerable<Lazy<INuGetResourceProvider>>, string) that allows sourceUrl to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.Repository.CreateSource(System.Collections.Generic.IEnumerable{System.Lazy{NuGet.Protocol.Core.Types.INuGetResourceProvider}},System.String)~NuGet.Protocol.Core.Types.SourceRepository")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter sourceUrl of method Repository.CreateSource(IEnumerable<Lazy<INuGetResourceProvider>>, string, FeedType) from string to System.Uri, or provide an overload to Repository.CreateSource(IEnumerable<Lazy<INuGetResourceProvider>>, string, FeedType) that allows sourceUrl to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.Repository.CreateSource(System.Collections.Generic.IEnumerable{System.Lazy{NuGet.Protocol.Core.Types.INuGetResourceProvider}},System.String,NuGet.Protocol.FeedType)~NuGet.Protocol.Core.Types.SourceRepository")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'Dispose' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.SourceCacheContext.Dispose(System.Boolean)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'SourceRepositoryProvider.SourceRepositoryProvider(IPackageSourceProvider packageSourceProvider, IEnumerable<Lazy<INuGetResourceProvider>> resourceProviders)', validate parameter 'packageSourceProvider' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Core.Types.SourceRepositoryProvider.#ctor(NuGet.Configuration.IPackageSourceProvider,System.Collections.Generic.IEnumerable{System.Lazy{NuGet.Protocol.Core.Types.INuGetResourceProvider}})")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'ProcessAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.DedicatedAsynchronousProcessingThread.ProcessAsync~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void DedicatedAsynchronousProcessingThread.ThrowIfAlreadyStarted()' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"The processing thread is already started.\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.DedicatedAsynchronousProcessingThread.ThrowIfAlreadyStarted")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void DedicatedAsynchronousProcessingThread.ThrowIfNotAlreadyStarted()' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"The processing thread is not started yet.\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.DedicatedAsynchronousProcessingThread.ThrowIfNotAlreadyStarted")]
[assembly: SuppressMessage("Build", "CA1305:'DependencyInfoResourceV2Feed.ResolvePackage(PackageIdentity, NuGetFramework, SourceCacheContext, ILogger, CancellationToken)' passes 'CultureInfo.CurrentUICulture' as the 'IFormatProvider' parameter to 'string.Format(IFormatProvider, string, object, object)'. This property returns a culture that is inappropriate for formatting methods.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.DependencyInfoResourceV2Feed.ResolvePackage(NuGet.Packaging.Core.PackageIdentity,NuGet.Frameworks.NuGetFramework,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo}")]
[assembly: SuppressMessage("Build", "CA1305:'DependencyInfoResourceV2Feed.ResolvePackages(string, NuGetFramework, SourceCacheContext, ILogger, CancellationToken)' passes 'CultureInfo.CurrentUICulture' as the 'IFormatProvider' parameter to 'string.Format(IFormatProvider, string, object, object)'. This property returns a culture that is inappropriate for formatting methods.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.DependencyInfoResourceV2Feed.ResolvePackages(System.String,NuGet.Frameworks.NuGetFramework,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> DependencyInfoResourceV2FeedProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.DependencyInfoResourceV2FeedProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1801:Parameter token of method GetPackagesFromRegistration is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.DependencyInfoResourceV3.GetPackagesFromRegistration(NuGet.Protocol.RegistrationInfo,System.Threading.CancellationToken)~System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo}")]
[assembly: SuppressMessage("Build", "CA1305:'DependencyInfoResourceV3.ResolvePackage(PackageIdentity, NuGetFramework, SourceCacheContext, ILogger, CancellationToken)' passes 'CultureInfo.CurrentUICulture' as the 'IFormatProvider' parameter to 'string.Format(IFormatProvider, string, object, object)'. This property returns a culture that is inappropriate for formatting methods.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.DependencyInfoResourceV3.ResolvePackage(NuGet.Packaging.Core.PackageIdentity,NuGet.Frameworks.NuGetFramework,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo}")]
[assembly: SuppressMessage("Build", "CA1305:'DependencyInfoResourceV3.ResolvePackages(string, NuGetFramework, SourceCacheContext, ILogger, CancellationToken)' passes 'CultureInfo.CurrentUICulture' as the 'IFormatProvider' parameter to 'string.Format(IFormatProvider, string, object, object)'. This property returns a culture that is inappropriate for formatting methods.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.DependencyInfoResourceV3.ResolvePackages(System.String,NuGet.Frameworks.NuGetFramework,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo}}")]
[assembly: SuppressMessage("Build", "CA1305:'DependencyInfoResourceV3.ResolvePackages(string, SourceCacheContext, ILogger, CancellationToken)' passes 'CultureInfo.CurrentUICulture' as the 'IFormatProvider' parameter to 'string.Format(IFormatProvider, string, object, object)'. This property returns a culture that is inappropriate for formatting methods.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.DependencyInfoResourceV3.ResolvePackages(System.String,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.RemoteSourceDependencyInfo}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> DependencyInfoResourceV3Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.DependencyInfoResourceV3Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> DownloadResourceV2FeedProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.DownloadResourceV2FeedProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1308:In method 'GetDownloadUrl', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.DownloadResourceV3.GetDownloadUrl(NuGet.Packaging.Core.PackageIdentity,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Uri}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> DownloadResourceV3Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.DownloadResourceV3Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object, object)' could vary based on the current user's locale settings. Replace this call in 'DownloadTimeoutStream.ReadAsync(byte[], int, int, CancellationToken)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.DownloadTimeoutStream.ReadAsync(System.Byte[],System.Int32,System.Int32,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Int32}")]
[assembly: SuppressMessage("Build", "CA2000:Call System.IDisposable.Dispose on object created by 'new DownloadTimeoutStream(downloadName, networkStream, timeout)' before all references to it are out of scope.", Justification = "The responsibility to dispose the object is transferred to base object", Scope = "member", Target = "~M:NuGet.Protocol.DownloadTimeoutStreamContent.#ctor(System.String,System.IO.Stream,System.TimeSpan)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'ProtocolDiagnosticHttpEventBase.ProtocolDiagnosticHttpEventBase(ProtocolDiagnosticHttpEventBase other)', validate parameter 'other' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Events.ProtocolDiagnosticHttpEventBase.#ctor(NuGet.Protocol.Events.ProtocolDiagnosticHttpEventBase)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> FeedTypeResourceProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.FeedTypeResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'FeedType FeedTypeUtility.GetFeedType(PackageSource packageSource)', validate parameter 'packageSource' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.FeedTypeUtility.GetFeedType(NuGet.Configuration.PackageSource)~NuGet.Protocol.FeedType")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> FindLocalPackagesResourcePackagesConfigProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.FindLocalPackagesResourcePackagesConfigProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> FindLocalPackagesResourceUnzippedProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.FindLocalPackagesResourceUnzippedProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> FindLocalPackagesResourceV2Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.FindLocalPackagesResourceV2Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> FindLocalPackagesResourceV3Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.FindLocalPackagesResourceV3Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter url of method FindPackagesByIdNupkgDownloader.CopyNupkgToStreamAsync(PackageIdentity, string, Stream, SourceCacheContext, ILogger, CancellationToken) from string to System.Uri, or provide an overload to FindPackagesByIdNupkgDownloader.CopyNupkgToStreamAsync(PackageIdentity, string, Stream, SourceCacheContext, ILogger, CancellationToken) that allows url to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.FindPackagesByIdNupkgDownloader.CopyNupkgToStreamAsync(NuGet.Packaging.Core.PackageIdentity,System.String,System.IO.Stream,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter url of method FindPackagesByIdNupkgDownloader.GetNuspecReaderFromNupkgAsync(PackageIdentity, string, SourceCacheContext, ILogger, CancellationToken) from string to System.Uri, or provide an overload to FindPackagesByIdNupkgDownloader.GetNuspecReaderFromNupkgAsync(PackageIdentity, string, SourceCacheContext, ILogger, CancellationToken) that allows url to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.FindPackagesByIdNupkgDownloader.GetNuspecReaderFromNupkgAsync(NuGet.Packaging.Core.PackageIdentity,System.String,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Packaging.NuspecReader}")]
[assembly: SuppressMessage("Build", "CA1822:Member ProcessCacheEntryAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.FindPackagesByIdNupkgDownloader.ProcessCacheEntryAsync(NuGet.Protocol.FindPackagesByIdNupkgDownloader.CacheEntry,System.Func{System.IO.Stream,System.Threading.Tasks.Task},System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1308:In method 'ProcessHttpSourceResultAsync', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.FindPackagesByIdNupkgDownloader.ProcessHttpSourceResultAsync``1(NuGet.Packaging.Core.PackageIdentity,System.String,System.Func{NuGet.Protocol.HttpSourceResult,System.Threading.Tasks.Task{``0}},NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{``0}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void GetDownloadResultUtility.CleanUpDirectDownloads(PackageDownloadContext downloadContext)', validate parameter 'downloadContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.GetDownloadResultUtility.CleanUpDirectDownloads(NuGet.Protocol.Core.Types.PackageDownloadContext)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetDownloadResultAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.GetDownloadResultUtility.GetDownloadResultAsync(NuGet.Protocol.HttpSource,NuGet.Packaging.Core.PackageIdentity,System.Uri,NuGet.Protocol.Core.Types.PackageDownloadContext,System.String,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.DownloadResourceResult}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<DownloadResourceResult> GetDownloadResultUtility.GetDownloadResultAsync(HttpSource client, PackageIdentity identity, Uri uri, PackageDownloadContext downloadContext, string globalPackagesFolder, ILogger logger, CancellationToken token)', validate parameter 'downloadContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.GetDownloadResultUtility.GetDownloadResultAsync(NuGet.Protocol.HttpSource,NuGet.Packaging.Core.PackageIdentity,System.Uri,NuGet.Protocol.Core.Types.PackageDownloadContext,System.String,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.DownloadResourceResult}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Task<DownloadResourceResult> GetDownloadResultUtility.GetDownloadResultAsync(HttpSource client, PackageIdentity identity, Uri uri, PackageDownloadContext downloadContext, string globalPackagesFolder, ILogger logger, CancellationToken token)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Reached an unexpected point in the code\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.GetDownloadResultUtility.GetDownloadResultAsync(NuGet.Protocol.HttpSource,NuGet.Packaging.Core.PackageIdentity,System.Uri,NuGet.Protocol.Core.Types.PackageDownloadContext,System.String,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.DownloadResourceResult}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task HttpCacheUtility.CreateCacheFileAsync(HttpCacheResult result, HttpResponseMessage response, Action<Stream> ensureValidContents, CancellationToken cancellationToken)', validate parameter 'result' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpCacheUtility.CreateCacheFileAsync(NuGet.Protocol.HttpCacheResult,System.Net.Http.HttpResponseMessage,System.Action{System.IO.Stream},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'HttpCacheResult HttpCacheUtility.InitializeHttpCacheResult(string httpCacheDirectory, Uri sourceUri, string cacheKey, HttpSourceCacheContext context)', validate parameter 'context' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpCacheUtility.InitializeHttpCacheResult(System.String,System.Uri,System.String,NuGet.Protocol.Core.Types.HttpSourceCacheContext)~NuGet.Protocol.HttpCacheResult")]
[assembly: SuppressMessage("Build", "CA1308:In method 'BuildModel', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpFileSystemBasedFindPackageByIdResource.BuildModel(System.String,System.String,System.String)~NuGet.Protocol.HttpFileSystemBasedFindPackageByIdResource.PackageInfo")]
[assembly: SuppressMessage("Build", "CA1822:Member BuildModel does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpFileSystemBasedFindPackageByIdResource.BuildModel(System.String,System.String,System.String)~NuGet.Protocol.HttpFileSystemBasedFindPackageByIdResource.PackageInfo")]
[assembly: SuppressMessage("Build", "CA1308:In method 'FindPackagesByIdAsync', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpFileSystemBasedFindPackageByIdResource.FindPackagesByIdAsync(System.String,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.SortedDictionary{NuGet.Versioning.NuGetVersion,NuGet.Protocol.HttpFileSystemBasedFindPackageByIdResource.PackageInfo}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> HttpFileSystemBasedFindPackageByIdResourceProvider.TryCreate(SourceRepository sourceRepository, CancellationToken token)', validate parameter 'sourceRepository' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpFileSystemBasedFindPackageByIdResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> HttpHandlerResourceV3Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpHandlerResourceV3Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpSource.GetAsync``1(NuGet.Protocol.HttpSourceCachedRequest,System.Func{NuGet.Protocol.HttpSourceResult,System.Threading.Tasks.Task{``0}},NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{``0}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<T> HttpSource.GetAsync<T>(HttpSourceCachedRequest request, Func<HttpSourceResult, Task<T>> processAsync, ILogger log, CancellationToken token)', validate parameter 'request' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpSource.GetAsync``1(NuGet.Protocol.HttpSourceCachedRequest,System.Func{NuGet.Protocol.HttpSourceResult,System.Threading.Tasks.Task{``0}},NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{``0}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<T> HttpSource.ProcessResponseAsync<T>(HttpSourceRequest request, Func<HttpResponseMessage, Task<T>> processAsync, SourceCacheContext cacheContext, ILogger log, CancellationToken token)', validate parameter 'processAsync' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpSource.ProcessResponseAsync``1(NuGet.Protocol.HttpSourceRequest,System.Func{System.Net.Http.HttpResponseMessage,System.Threading.Tasks.Task{``0}},NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{``0}")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter uri of method HttpSource.TryReadCacheFile(string, TimeSpan, string) from string to System.Uri, or provide an overload to HttpSource.TryReadCacheFile(string, TimeSpan, string) that allows uri to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpSource.TryReadCacheFile(System.String,System.TimeSpan,System.String)~System.IO.Stream")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'PromptForCredentialsAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpSourceAuthenticationHandler.PromptForCredentialsAsync(NuGet.Configuration.CredentialRequestType,System.String,NuGet.Protocol.AmbientAuthenticationState,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Net.ICredentials}")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter uri of method HttpSourceCachedRequest.HttpSourceCachedRequest(string, string, HttpSourceCacheContext) from string to System.Uri, or provide an overload to HttpSourceCachedRequest.HttpSourceCachedRequest(string, string, HttpSourceCacheContext) that allows uri to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpSourceCachedRequest.#ctor(System.String,System.String,NuGet.Protocol.Core.Types.HttpSourceCacheContext)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> HttpSourceResourceProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpSourceResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void HttpStreamValidation.ValidateJObject(string uri, Stream stream)' passes a literal string as parameter 'message' of a call to 'JsonReaderException.JsonReaderException(string message)'. Retrieve the following string(s) from a resource table instead: \"The JSON document is not an object.\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpStreamValidation.ValidateJObject(System.String,System.IO.Stream)")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter uri of method HttpStreamValidation.ValidateJObject(string, Stream) from string to System.Uri, or provide an overload to HttpStreamValidation.ValidateJObject(string, Stream) that allows uri to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpStreamValidation.ValidateJObject(System.String,System.IO.Stream)")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter uri of method HttpStreamValidation.ValidateNupkg(string, Stream) from string to System.Uri, or provide an overload to HttpStreamValidation.ValidateNupkg(string, Stream) that allows uri to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpStreamValidation.ValidateNupkg(System.String,System.IO.Stream)")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter uri of method HttpStreamValidation.ValidateXml(string, Stream) from string to System.Uri, or provide an overload to HttpStreamValidation.ValidateXml(string, Stream) that allows uri to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpStreamValidation.ValidateXml(System.String,System.IO.Stream)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void HttpStreamValidation.ValidateXml(string uri, Stream stream)' passes a literal string as parameter 'message' of a call to 'JsonReaderException.JsonReaderException(string message)'. Retrieve the following string(s) from a resource table instead: \"The XML document is not complete.\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.HttpStreamValidation.ValidateXml(System.String,System.IO.Stream)")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter sourceUri of method IHttpRetryHandler.SendAsync(HttpRetryHandlerRequest, string, ILogger, CancellationToken) from string to System.Uri, or provide an overload to IHttpRetryHandler.SendAsync(HttpRetryHandlerRequest, string, ILogger, CancellationToken) that allows sourceUri to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.IHttpRetryHandler.SendAsync(NuGet.Protocol.HttpRetryHandlerRequest,System.String,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Net.Http.HttpResponseMessage}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object JsonExtensions.FromJToken(JToken jtoken, Type type)', validate parameter 'jtoken' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.JsonExtensions.FromJToken(Newtonsoft.Json.Linq.JToken,System.Type)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'T JsonExtensions.FromJToken<T>(JToken jtoken)', validate parameter 'jtoken' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.JsonExtensions.FromJToken``1(Newtonsoft.Json.Linq.JToken)~``0")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool? JsonExtensions.GetBoolean(JObject json, string propertyName)', validate parameter 'json' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.JsonExtensions.GetBoolean(Newtonsoft.Json.Linq.JObject,System.String)~System.Nullable{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'T JsonExtensions.GetJObjectProperty<T>(JObject jobject, string propertyName)', validate parameter 'jobject' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.JsonExtensions.GetJObjectProperty``1(Newtonsoft.Json.Linq.JObject,System.String)~``0")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetCapabilitiesAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LegacyFeedCapabilityResourceV2Feed.GetCapabilitiesAsync(System.String,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.LegacyFeedCapabilityResourceV2Feed.Capabilities}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> LocalAutoCompleteResourceProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalAutoCompleteResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1305:'LocalDependencyInfoResource.ResolvePackage(PackageIdentity, NuGetFramework, SourceCacheContext, ILogger, CancellationToken)' passes 'CultureInfo.CurrentUICulture' as the 'IFormatProvider' parameter to 'string.Format(IFormatProvider, string, object, object)'. This property returns a culture that is inappropriate for formatting methods.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalDependencyInfoResource.ResolvePackage(NuGet.Packaging.Core.PackageIdentity,NuGet.Frameworks.NuGetFramework,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Task<SourcePackageDependencyInfo> LocalDependencyInfoResource.ResolvePackage(PackageIdentity package, NuGetFramework projectFramework, SourceCacheContext sourceCacheContext, ILogger log, CancellationToken token)' passes a literal string as parameter 'message' of a call to 'ArgumentNullException.ArgumentNullException(string paramName, string message)'. Retrieve the following string(s) from a resource table instead: \"package\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalDependencyInfoResource.ResolvePackage(NuGet.Packaging.Core.PackageIdentity,NuGet.Frameworks.NuGetFramework,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo}")]
[assembly: SuppressMessage("Build", "CA1305:'LocalDependencyInfoResource.ResolvePackages(string, NuGetFramework, SourceCacheContext, ILogger, CancellationToken)' passes 'CultureInfo.CurrentUICulture' as the 'IFormatProvider' parameter to 'string.Format(IFormatProvider, string, object, object)'. This property returns a culture that is inappropriate for formatting methods.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalDependencyInfoResource.ResolvePackages(System.String,NuGet.Frameworks.NuGetFramework,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourcePackageDependencyInfo}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> LocalDependencyInfoResourceProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalDependencyInfoResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> LocalDownloadResourceProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalDownloadResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetDirectoriesSafe' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalFolderUtility.GetDirectoriesSafe(System.IO.DirectoryInfo,NuGet.Common.ILogger)~System.IO.DirectoryInfo[]")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetDirectoriesSafe' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalFolderUtility.GetDirectoriesSafe(System.IO.DirectoryInfo,System.String,System.IO.SearchOption,NuGet.Common.ILogger)~System.IO.DirectoryInfo[]")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetFilesSafe' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalFolderUtility.GetFilesSafe(System.IO.DirectoryInfo,System.String,NuGet.Common.ILogger)~System.IO.FileInfo[]")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<string> LocalFolderUtility.ResolvePackageFromPath(string packagePath, bool isSnupkg = false)', validate parameter 'packagePath' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalFolderUtility.ResolvePackageFromPath(System.String,System.Boolean)~System.Collections.Generic.IEnumerable{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<KeyValuePair<string, NuGetVersion>>> LocalMetadataResource.GetLatestVersions(IEnumerable<string> packageIds, bool includePrerelease, bool includeUnlisted, SourceCacheContext sourceCacheContext, ILogger log, CancellationToken token)', validate parameter 'packageIds' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalMetadataResource.GetLatestVersions(System.Collections.Generic.IEnumerable{System.String},System.Boolean,System.Boolean,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{System.Collections.Generic.KeyValuePair{System.String,NuGet.Versioning.NuGetVersion}}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> LocalMetadataResourceProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalMetadataResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1822:Member GetRuntimeGraph does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalPackageFileCache.GetRuntimeGraph(System.String)~NuGet.RuntimeModel.RuntimeGraph")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> LocalPackageMetadataResourceProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalPackageMetadataResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'LoadFileAsText' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalPackageSearchMetadata.LoadFileAsText(System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1801:Parameter cancellationToken of method CreatePackageSearchResult is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalPackageSearchResource.CreatePackageSearchResult(NuGet.Protocol.LocalPackageInfo,NuGet.Protocol.Core.Types.SearchFilter,NuGet.Common.ILogger,System.Threading.CancellationToken)~NuGet.Protocol.Core.Types.IPackageSearchMetadata")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object)' could vary based on the current user's locale settings. Replace this call in 'LocalPackageSearchResource.SearchAsync(string, SearchFilter, int, int, ILogger, CancellationToken)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalPackageSearchResource.SearchAsync(System.String,NuGet.Protocol.Core.Types.SearchFilter,System.Int32,System.Int32,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> LocalPackageSearchResourceProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalPackageSearchResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> LocalPackageListResourceProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalRepositories.LocalPackageListResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> LocalV2FindPackageByIdResourceProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalV2FindPackageByIdResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> LocalV3FindPackageByIdResourceProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.LocalV3FindPackageByIdResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object MetadataFieldConverter.ReadJson(JsonReader reader, Type objectType, object existingValue, JsonSerializer serializer)', validate parameter 'serializer' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.MetadataFieldConverter.ReadJson(Newtonsoft.Json.JsonReader,System.Type,System.Object,Newtonsoft.Json.JsonSerializer)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<KeyValuePair<string, NuGetVersion>>> MetadataResourceV2Feed.GetLatestVersions(IEnumerable<string> packageIds, bool includePrerelease, bool includeUnlisted, SourceCacheContext sourceCacheContext, ILogger log, CancellationToken token)', validate parameter 'packageIds' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.MetadataResourceV2Feed.GetLatestVersions(System.Collections.Generic.IEnumerable{System.String},System.Boolean,System.Boolean,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{System.Collections.Generic.KeyValuePair{System.String,NuGet.Versioning.NuGetVersion}}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> MetadataResourceV2FeedProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.MetadataResourceV2FeedProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<KeyValuePair<string, NuGetVersion>>> MetadataResourceV3.GetLatestVersions(IEnumerable<string> packageIds, bool includePrerelease, bool includeUnlisted, SourceCacheContext sourceCacheContext, ILogger log, CancellationToken token)', validate parameter 'packageIds' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.MetadataResourceV3.GetLatestVersions(System.Collections.Generic.IEnumerable{System.String},System.Boolean,System.Boolean,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{System.Collections.Generic.KeyValuePair{System.String,NuGet.Versioning.NuGetVersion}}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> MetadataResourceV3Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.MetadataResourceV3Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object NuGetVersionConverter.ReadJson(JsonReader reader, Type objectType, object existingValue, JsonSerializer serializer)', validate parameter 'reader' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.NuGetVersionConverter.ReadJson(Newtonsoft.Json.JsonReader,System.Type,System.Object,Newtonsoft.Json.JsonSerializer)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void NuGetVersionConverter.WriteJson(JsonWriter writer, object value, JsonSerializer serializer)', validate parameter 'serializer' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.NuGetVersionConverter.WriteJson(Newtonsoft.Json.JsonWriter,System.Object,Newtonsoft.Json.JsonSerializer)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'ODataServiceDocumentResourceV2.ODataServiceDocumentResourceV2(string baseAddress, DateTime requestTime)', validate parameter 'baseAddress' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.ODataServiceDocumentResourceV2.#ctor(System.String,System.DateTime)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> ODataServiceDocumentResourceV2Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.ODataServiceDocumentResourceV2Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter uriTemplate of method PackageDetailsUriResourceV3.CreateOrNull(string) from string to System.Uri, or provide an overload to PackageDetailsUriResourceV3.CreateOrNull(string) that allows uriTemplate to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.PackageDetailsUriResourceV3.CreateOrNull(System.String)~NuGet.Protocol.PackageDetailsUriResourceV3")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Uri PackageDetailsUriResourceV3.GetUri(string id, NuGetVersion version)', validate parameter 'version' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.PackageDetailsUriResourceV3.GetUri(System.String,NuGet.Versioning.NuGetVersion)~System.Uri")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> PackageDetailsUriResourceV3Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.PackageDetailsUriResourceV3Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> PackageMetadataResourceV2FeedProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.PackageMetadataResourceV2FeedProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> PackageMetadataResourceV3Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.PackageMetadataResourceV3Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageSearchMetadataV2Feed.PackageSearchMetadataV2Feed(V2FeedPackageInfo package)', validate parameter 'package' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.PackageSearchMetadataV2Feed.#ctor(NuGet.Protocol.V2FeedPackageInfo)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageSearchMetadataV2Feed.PackageSearchMetadataV2Feed(V2FeedPackageInfo package, MetadataReferenceCache metadataCache)', validate parameter 'metadataCache' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.PackageSearchMetadataV2Feed.#ctor(NuGet.Protocol.V2FeedPackageInfo,NuGet.Protocol.MetadataReferenceCache)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> PackageSearchResourceV2FeedProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.PackageSearchResourceV2FeedProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> PackageSearchResourceV3Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.PackageSearchResourceV3Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> PackageUpdateResourceV2Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.PackageUpdateResourceV2Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> PackageUpdateResourceV3Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.PackageUpdateResourceV3Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'Dispose' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.AutomaticProgressReporter.Dispose")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'OnTimer' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.AutomaticProgressReporter.OnTimer(System.Object)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'BeginFaultAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.InboundRequestContext.BeginFaultAsync(NuGet.Protocol.Plugins.Message,System.Exception)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'Dispose' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.InboundRequestContext.Dispose")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'ProcessResponseAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.InboundRequestContext.ProcessResponseAsync(NuGet.Protocol.Plugins.IRequestHandler,NuGet.Protocol.Plugins.Message,NuGet.Protocol.Plugins.IResponseHandler)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA2000:Call System.IDisposable.Dispose on object created by 'CreateOutboundRequestContext<TIncoming>(' before all references to it are out of scope.", Justification = "Keep the request context around if cancellation was requested.", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.MessageDispatcher.DispatchWithNewContextAsync``2(NuGet.Protocol.Plugins.IConnection,NuGet.Protocol.Plugins.MessageType,NuGet.Protocol.Plugins.MessageMethod,``0,System.Threading.CancellationToken)~System.Threading.Tasks.Task{``1}")]
[assembly: SuppressMessage("Build", "CA1801:Parameter connection of method GetIsKeepAlive is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.MessageDispatcher.GetIsKeepAlive(NuGet.Protocol.Plugins.IConnection,NuGet.Protocol.Plugins.MessageType,NuGet.Protocol.Plugins.MessageMethod)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1801:Parameter connection of method HandleInboundCancel is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.MessageDispatcher.HandleInboundCancel(NuGet.Protocol.Plugins.IConnection,NuGet.Protocol.Plugins.Message)")]
[assembly: SuppressMessage("Build", "CA1801:Parameter connection of method HandleInboundFault is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.MessageDispatcher.HandleInboundFault(NuGet.Protocol.Plugins.IConnection,NuGet.Protocol.Plugins.Message)")]
[assembly: SuppressMessage("Build", "CA2000:Call System.IDisposable.Dispose on object created by 'CreateInboundRequestContext(message, cancellationToken)' before all references to it are out of scope.", Justification = "The responsibility to dispose the object is transferred to another object", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.MessageDispatcher.HandleInboundRequest(NuGet.Protocol.Plugins.IConnection,NuGet.Protocol.Plugins.Message)")]
[assembly: SuppressMessage("Build", "CA1801:Parameter connection of method HandleInboundRequest is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.MessageDispatcher.HandleInboundRequest(NuGet.Protocol.Plugins.IConnection,NuGet.Protocol.Plugins.Message)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'HandleResponseAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.MonitorNuGetProcessExitRequestHandler.HandleResponseAsync(NuGet.Protocol.Plugins.IConnection,NuGet.Protocol.Plugins.Message,NuGet.Protocol.Plugins.IResponseHandler,System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'Close' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.OutboundRequestContext`1.Close")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'TryCancel' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.OutboundRequestContext`1.TryCancel")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'Guid.ToString(string)' could vary based on the current user's locale settings. Replace this call in 'Plugin.CreateNewId()' with a call to 'Guid.ToString(string, IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.Plugin.CreateNewId~System.String")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'FireBeforeClose' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.Plugin.FireBeforeClose")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'FireClosed' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.Plugin.FireClosed")]
[assembly: SuppressMessage("Build", "CA2000:Call System.IDisposable.Dispose on object created by 'new MonitorNuGetProcessExitRequestHandler(plugin)' before all references to it are out of scope.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.PluginFactory.CreateFromCurrentProcessAsync(NuGet.Protocol.Plugins.IRequestHandlers,NuGet.Protocol.Plugins.ConnectionOptions,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Plugins.IPlugin}")]
[assembly: SuppressMessage("Build", "CA2000:Use recommended dispose pattern to ensure that object created by 'new PluginProcess(startInfo)' is disposed on all paths. If possible, wrap the creation within a 'using' statement or a 'using' declaration. Otherwise, use a try-finally pattern, with a dedicated local variable declared before the try region and an unconditional Dispose invocation on non-null value in the 'finally' region, say 'x?.Dispose()'. If the object is explicitly disposed within the try region or the dispose ownership is transfered to another object or method, assign 'null' to the local variable just after such an operation to prevent double dispose in 'finally'.", Justification = "The responsibility to dispose the object is transferred to another object or wrapper that's created in the method and returned to the caller", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.PluginFactory.CreatePluginAsync(System.String,System.Collections.Generic.IEnumerable{System.String},NuGet.Protocol.Plugins.IRequestHandlers,NuGet.Protocol.Plugins.ConnectionOptions,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Plugins.IPlugin}")]
[assembly: SuppressMessage("Build", "CA1801:Parameter sender of method OnPluginProcessExited is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.PluginFactory.OnPluginProcessExited(System.Object,NuGet.Protocol.Plugins.IPluginProcess,System.String)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'SendCloseRequest' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.PluginFactory.SendCloseRequest(NuGet.Protocol.Plugins.IPlugin)")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'DateTime.ToString(string)' could vary based on the current user's locale settings. Replace this call in 'PluginLogMessage.ToString(string, JObject)' with a call to 'DateTime.ToString(string, IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.PluginLogMessage.ToString(System.String,Newtonsoft.Json.Linq.JObject)~System.String")]
[assembly: SuppressMessage("Build", "CA1822:Member GetPluginOperationClaimsAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.PluginManager.GetPluginOperationClaimsAsync(NuGet.Protocol.Plugins.IPlugin,System.String,Newtonsoft.Json.Linq.JObject,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IReadOnlyList{NuGet.Protocol.Plugins.OperationClaim}}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'TryCreatePluginAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.PluginManager.TryCreatePluginAsync(NuGet.Protocol.Plugins.PluginDiscoveryResult,NuGet.Protocol.Plugins.OperationClaim,NuGet.Protocol.Plugins.PluginManager.PluginRequestKey,System.String,Newtonsoft.Json.Linq.JObject,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Plugins.PluginCreationResult}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool PluginPackageReader.CanVerifySignedPackages(SignedPackageVerifierSettings verifierSettings)', validate parameter 'verifierSettings' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.PluginPackageReader.CanVerifySignedPackages(NuGet.Packaging.Signing.SignedPackageVerifierSettings)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'Dispose' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.PluginPackageReader.FileStreamCreator.Dispose")]
[assembly: SuppressMessage("Build", "CA1801:Parameter cancellationToken of method GetStreamInternalAsync is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.PluginPackageReader.GetStreamInternalAsync(System.String,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Plugins.PluginPackageReader.FileStreamCreator}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'Kill' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.PluginProcess.Kill")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'DateTime.ToString(string)' could vary based on the current user's locale settings. Replace this call in 'ProcessLogMessage.ToString()' with a call to 'DateTime.ToString(string, IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.ProcessLogMessage.ToString~System.String")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'Dispose' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.StandardInputReceiver.Dispose")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'Receive' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.StandardInputReceiver.Receive(System.Object)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'OnLineRead' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.StandardOutputReceiver.OnLineRead(System.Object,NuGet.Protocol.Plugins.LineReadEventArgs)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetTimeout' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.TimeoutUtilities.GetTimeout(System.String,System.TimeSpan)~System.TimeSpan")]
[assembly: SuppressMessage("Build", "CA1303:Method 'bool UnixAndMonoPlatformsEmbeddedSignatureVerifier.IsValid(string filePath)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"filePath\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Plugins.UnixAndMonoPlatformsEmbeddedSignatureVerifier.IsValid(System.String)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1801:Parameter ex of method ProxyAuthenticationRequired is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.ProxyAuthenticationHandler.AcquireCredentialsAsync(System.Uri,System.Guid,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'PromptForProxyCredentialsAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.ProxyAuthenticationHandler.PromptForProxyCredentialsAsync(System.Uri,System.Net.IWebProxy,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Net.NetworkCredential}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'SearchPage' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RawSearchResourceV3.SearchPage(System.String,NuGet.Protocol.Core.Types.SearchFilter,System.Int32,System.Int32,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{Newtonsoft.Json.Linq.JObject}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'int.ToString()' could vary based on the current user's locale settings. Replace this call in 'RawSearchResourceV3.SearchPage(string, SearchFilter, int, int, ILogger, CancellationToken)' with a call to 'int.ToString(IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RawSearchResourceV3.SearchPage(System.String,NuGet.Protocol.Core.Types.SearchFilter,System.Int32,System.Int32,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{Newtonsoft.Json.Linq.JObject}")]
[assembly: SuppressMessage("Build", "CA1308:In method 'SearchPage', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RawSearchResourceV3.SearchPage(System.String,NuGet.Protocol.Core.Types.SearchFilter,System.Int32,System.Int32,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{Newtonsoft.Json.Linq.JObject}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<JObject> RawSearchResourceV3.SearchPage(string searchTerm, SearchFilter filters, int skip, int take, ILogger log, CancellationToken cancellationToken)', validate parameter 'filters' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RawSearchResourceV3.SearchPage(System.String,NuGet.Protocol.Core.Types.SearchFilter,System.Int32,System.Int32,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{Newtonsoft.Json.Linq.JObject}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> RawSearchResourceV3Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RawSearchResourceV3Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<JObject> RegistrationResourceV3.GetPackageMetadata(PackageIdentity identity, SourceCacheContext cacheContext, ILogger log, CancellationToken token)', validate parameter 'identity' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RegistrationResourceV3.GetPackageMetadata(NuGet.Packaging.Core.PackageIdentity,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{Newtonsoft.Json.Linq.JObject}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<JObject>> RegistrationResourceV3.GetPackageMetadata(string packageId, VersionRange range, bool includePrerelease, bool includeUnlisted, SourceCacheContext cacheContext, ILogger log, CancellationToken token)', validate parameter 'range' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RegistrationResourceV3.GetPackageMetadata(System.String,NuGet.Versioning.VersionRange,System.Boolean,System.Boolean,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{Newtonsoft.Json.Linq.JObject}}")]
[assembly: SuppressMessage("Build", "CA1308:In method 'GetUri', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RegistrationResourceV3.GetUri(NuGet.Packaging.Core.PackageIdentity)~System.Uri")]
[assembly: SuppressMessage("Build", "CA1308:In method 'GetUri', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RegistrationResourceV3.GetUri(System.String)~System.Uri")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> RegistrationResourceV3Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RegistrationResourceV3Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<JObject>> RegistrationUtility.LoadRanges(HttpSource httpSource, Uri registrationUri, string packageId, VersionRange range, SourceCacheContext cacheContext, ILogger log, CancellationToken token)', validate parameter 'httpSource' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RegistrationUtility.LoadRanges(NuGet.Protocol.HttpSource,System.Uri,System.String,NuGet.Versioning.VersionRange,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{Newtonsoft.Json.Linq.JObject}}")]
[assembly: SuppressMessage("Build", "CA1308:In method 'LoadRanges', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RegistrationUtility.LoadRanges(NuGet.Protocol.HttpSource,System.Uri,System.String,NuGet.Versioning.VersionRange,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{Newtonsoft.Json.Linq.JObject}}")]
[assembly: SuppressMessage("Build", "CA1307:The behavior of 'string.EndsWith(string)' could vary based on the current user's locale settings. Replace this call in 'NuGet.Protocol.RemoteV2FindPackageByIdResource.RemoteV2FindPackageByIdResource(NuGet.Configuration.PackageSource, NuGet.Protocol.HttpSource)' with a call to 'string.EndsWith(string, System.StringComparison)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RemoteV2FindPackageByIdResource.#ctor(NuGet.Configuration.PackageSource,NuGet.Protocol.HttpSource)")]
[assembly: SuppressMessage("Build", "CA1308:In method 'FindPackagesByIdAsyncCore', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RemoteV2FindPackageByIdResource.FindPackagesByIdAsyncCore(System.String,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.Protocol.RemoteV2FindPackageByIdResource.PackageInfo}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> RemoteV2FindPackageByIdResourceProvider.TryCreate(SourceRepository sourceRepository, CancellationToken token)', validate parameter 'sourceRepository' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RemoteV2FindPackageByIdResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> RemoteV3FindPackageByIdResourceProvider.TryCreate(SourceRepository sourceRepository, CancellationToken token)', validate parameter 'sourceRepository' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RemoteV3FindPackageByIdResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter uriTemplate of method ReportAbuseResourceV3.ReportAbuseResourceV3(string) from string to System.Uri, or provide an overload to ReportAbuseResourceV3.ReportAbuseResourceV3(string) that allows uriTemplate to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.ReportAbuseResourceV3.#ctor(System.String)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Uri ReportAbuseResourceV3.GetReportAbuseUrl(string id, NuGetVersion version)', validate parameter 'version' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.ReportAbuseResourceV3.GetReportAbuseUrl(System.String,NuGet.Versioning.NuGetVersion)~System.Uri")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> ReportAbuseResourceV3Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.ReportAbuseResourceV3Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'RepositorySignatureResource.RepositorySignatureResource(JObject repoSignInformationContent, SourceRepository source)', validate parameter 'repoSignInformationContent' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RepositorySignatureResource.#ctor(Newtonsoft.Json.Linq.JObject,NuGet.Protocol.Core.Types.SourceRepository)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> RepositorySignatureResourceProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.RepositorySignatureResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object SafeBoolConverter.ReadJson(JsonReader reader, Type objectType, object existingValue, JsonSerializer serializer)', validate parameter 'reader' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.SafeBoolConverter.ReadJson(Newtonsoft.Json.JsonReader,System.Type,System.Object,Newtonsoft.Json.JsonSerializer)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object SafeUriConverter.ReadJson(JsonReader reader, Type objectType, object existingValue, JsonSerializer serializer)', validate parameter 'reader' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.SafeUriConverter.ReadJson(Newtonsoft.Json.JsonReader,System.Type,System.Object,Newtonsoft.Json.JsonSerializer)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object SemanticVersionConverter.ReadJson(JsonReader reader, Type objectType, object existingValue, JsonSerializer serializer)', validate parameter 'reader' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.SemanticVersionConverter.ReadJson(Newtonsoft.Json.JsonReader,System.Type,System.Object,Newtonsoft.Json.JsonSerializer)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void SemanticVersionConverter.WriteJson(JsonWriter writer, object value, JsonSerializer serializer)', validate parameter 'serializer' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.SemanticVersionConverter.WriteJson(Newtonsoft.Json.JsonWriter,System.Object,Newtonsoft.Json.JsonSerializer)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'ServiceIndexResourceV3.ServiceIndexResourceV3(JObject index, DateTime requestTime)', validate parameter 'index' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.ServiceIndexResourceV3.#ctor(Newtonsoft.Json.Linq.JObject,System.DateTime)")]
[assembly: SuppressMessage("Build", "CA1822:Member ConsumeServiceIndexStreamAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.ServiceIndexResourceV3Provider.ConsumeServiceIndexStreamAsync(System.IO.Stream,System.DateTime,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.ServiceIndexResourceV3}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> ServiceIndexResourceV3Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.ServiceIndexResourceV3Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task StreamExtensions.CopyToAsync(Stream stream, Stream destination, CancellationToken token)', validate parameter 'stream' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.StreamExtensions.CopyToAsync(System.IO.Stream,System.IO.Stream,System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<HttpResponseMessage> StsAuthenticationHandler.SendAsync(HttpRequestMessage request, CancellationToken cancellationToken)', validate parameter 'request' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.StsAuthenticationHandler.SendAsync(System.Net.Http.HttpRequestMessage,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Net.Http.HttpResponseMessage}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool StsAuthenticationHandler.TryRetrieveSTSToken(HttpResponseMessage response)', validate parameter 'response' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.StsAuthenticationHandler.TryRetrieveSTSToken(System.Net.Http.HttpResponseMessage)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> SymbolPackageUpdateResourceV3Provider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.SymbolPackageUpdateResourceV3Provider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<T> TimeoutUtility.StartWithTimeout<T>(Func<CancellationToken, Task<T>> getTask, TimeSpan timeout, string timeoutMessage, CancellationToken token)', validate parameter 'getTask' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.TimeoutUtility.StartWithTimeout``1(System.Func{System.Threading.CancellationToken,System.Threading.Tasks.Task{``0}},System.TimeSpan,System.String,System.Threading.CancellationToken)~System.Threading.Tasks.Task{``0}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void TokenStore.AddToken(Uri sourceUri, string token)', validate parameter 'sourceUri' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.TokenStore.AddToken(System.Uri,System.String)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string TokenStore.GetToken(Uri sourceUri)', validate parameter 'sourceUri' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.TokenStore.GetToken(System.Uri)~System.String")]
[assembly: SuppressMessage("Build", "CA1801:Parameter id of method Pass1 is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Trim.Pass1(NuGet.Protocol.PackageInfo,System.String,System.Collections.Generic.KeyValuePair{System.String,NuGet.Versioning.VersionRange})")]
[assembly: SuppressMessage("Build", "CA1801:Parameter id of method Pass2 is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.Trim.Pass2(NuGet.Protocol.PackageInfo,System.String,System.Boolean@)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> V2FeedListResourceProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedListResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter licenseUrl of method V2FeedPackageInfo.V2FeedPackageInfo(PackageIdentity, string, string, string, IEnumerable<string>, IEnumerable<string>, string, string, string, string, string, string, DateTimeOffset?, DateTimeOffset?, DateTimeOffset?, string, bool, string, string, string, string, NuGetVersion) from string to System.Uri, or provide an overload to V2FeedPackageInfo.V2FeedPackageInfo(PackageIdentity, string, string, string, IEnumerable<string>, IEnumerable<string>, string, string, string, string, string, string, DateTimeOffset?, DateTimeOffset?, DateTimeOffset?, string, bool, string, string, string, string, NuGetVersion) that allows licenseUrl to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedPackageInfo.#ctor(NuGet.Packaging.Core.PackageIdentity,System.String,System.String,System.String,System.Collections.Generic.IEnumerable{System.String},System.Collections.Generic.IEnumerable{System.String},System.String,System.String,System.String,System.String,System.String,System.String,System.Nullable{System.DateTimeOffset},System.Nullable{System.DateTimeOffset},System.Nullable{System.DateTimeOffset},System.String,System.Boolean,System.String,System.String,System.String,System.String,NuGet.Versioning.NuGetVersion)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'V2FeedPackageInfo.V2FeedPackageInfo(PackageIdentity identity, string title, string summary, string description, IEnumerable<string> authors, IEnumerable<string> owners, string iconUrl, string licenseUrl, string projectUrl, string reportAbuseUrl, string galleryDetailsUrl, string tags, DateTimeOffset? created, DateTimeOffset? lastEdited, DateTimeOffset? published, string dependencies, bool requireLicenseAccept, string downloadUrl, string downloadCount, string packageHash, string packageHashAlgorithm, NuGetVersion minClientVersion)', validate parameter 'identity' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedPackageInfo.#ctor(NuGet.Packaging.Core.PackageIdentity,System.String,System.String,System.String,System.Collections.Generic.IEnumerable{System.String},System.Collections.Generic.IEnumerable{System.String},System.String,System.String,System.String,System.String,System.String,System.String,System.Nullable{System.DateTimeOffset},System.Nullable{System.DateTimeOffset},System.Nullable{System.DateTimeOffset},System.String,System.Boolean,System.String,System.String,System.String,System.String,NuGet.Versioning.NuGetVersion)")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter nextUri of method V2FeedPage.V2FeedPage(List<V2FeedPackageInfo>, string) from string to System.Uri, or provide an overload to V2FeedPage.V2FeedPage(List<V2FeedPackageInfo>, string) that allows nextUri to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedPage.#ctor(System.Collections.Generic.List{NuGet.Protocol.V2FeedPackageInfo},System.String)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Task<IReadOnlyList<V2FeedPackageInfo>> V2FeedParser.FindPackagesByIdAsync(string id, bool includeUnlisted, bool includePrerelease, SourceCacheContext sourceCacheContext, ILogger log, CancellationToken token)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"id\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedParser.FindPackagesByIdAsync(System.String,System.Boolean,System.Boolean,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IReadOnlyList{NuGet.Protocol.V2FeedPackageInfo}}")]
[assembly: SuppressMessage("Build", "CA1822:Member GetCacheKey does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedParser.GetCacheKey(System.String,System.Int32)~System.String")]
[assembly: SuppressMessage("Build", "CA1822:Member ParsePackage does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedParser.ParsePackage(System.String,System.Xml.Linq.XElement,NuGet.Protocol.MetadataReferenceCache)~NuGet.Protocol.V2FeedPackageInfo")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter relativeUri of method V2FeedParser.QueryV2FeedAsync(string, string, int, bool, SourceCacheContext, ILogger, CancellationToken) from string to System.Uri, or provide an overload to V2FeedParser.QueryV2FeedAsync(string, string, int, bool, SourceCacheContext, ILogger, CancellationToken) that allows relativeUri to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedParser.QueryV2FeedAsync(System.String,System.String,System.Int32,System.Boolean,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.V2FeedPage}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object, object)' could vary based on the current user's locale settings. Replace this call in 'V2FeedParser.QueryV2FeedAsync(string, string, int, bool, SourceCacheContext, ILogger, CancellationToken)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedParser.QueryV2FeedAsync(System.String,System.String,System.Int32,System.Boolean,NuGet.Protocol.Core.Types.SourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.V2FeedPage}")]
[assembly: SuppressMessage("Build", "CA1822:Member BuildFieldSearchClause does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedQueryBuilder.BuildFieldSearchClause(System.String,System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1822:Member BuildFindPackagesByIdUri does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedQueryBuilder.BuildFindPackagesByIdUri(System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'StringBuilder.AppendFormat(string, object)' could vary based on the current user's locale settings. Replace this call in 'V2FeedQueryBuilder.BuildGetPackagesUri(string, SearchFilter, int?, int?)' with a call to 'StringBuilder.AppendFormat(IFormatProvider, string, object)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedQueryBuilder.BuildGetPackagesUri(System.String,NuGet.Protocol.Core.Types.SearchFilter,System.Nullable{System.Int32},System.Nullable{System.Int32})~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string V2FeedQueryBuilder.BuildGetPackagesUri(string searchTerm, SearchFilter filters, int? skip, int? take)', validate parameter 'filters' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedQueryBuilder.BuildGetPackagesUri(System.String,NuGet.Protocol.Core.Types.SearchFilter,System.Nullable{System.Int32},System.Nullable{System.Int32})~System.String")]
[assembly: SuppressMessage("Build", "CA1822:Member BuildGetPackageUri does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedQueryBuilder.BuildGetPackageUri(NuGet.Packaging.Core.PackageIdentity)~System.String")]
[assembly: SuppressMessage("Build", "CA1303:Method 'string V2FeedQueryBuilder.BuildGetPackageUri(PackageIdentity package)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"Version\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedQueryBuilder.BuildGetPackageUri(NuGet.Packaging.Core.PackageIdentity)~System.String")]
[assembly: SuppressMessage("Build", "CA1822:Member BuildOrderBy does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedQueryBuilder.BuildOrderBy(System.Nullable{NuGet.Protocol.Core.Types.SearchOrderBy})~System.String")]
[assembly: SuppressMessage("Build", "CA1822:Member BuildPropertyFilter does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedQueryBuilder.BuildPropertyFilter(System.Nullable{NuGet.Protocol.Core.Types.SearchFilterType})~System.String")]
[assembly: SuppressMessage("Build", "CA1308:In method 'BuildSearchUri', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedQueryBuilder.BuildSearchUri(System.String,NuGet.Protocol.Core.Types.SearchFilter,System.Int32,System.Int32)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string V2FeedQueryBuilder.BuildSearchUri(string searchTerm, SearchFilter filters, int skip, int take)', validate parameter 'filters' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedQueryBuilder.BuildSearchUri(System.String,NuGet.Protocol.Core.Types.SearchFilter,System.Int32,System.Int32)~System.String")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'bool.ToString()' could vary based on the current user's locale settings. Replace this call in 'V2FeedQueryBuilder.BuildSearchUri(string, SearchFilter, int, int)' with a call to 'bool.ToString(IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedQueryBuilder.BuildSearchUri(System.String,NuGet.Protocol.Core.Types.SearchFilter,System.Int32,System.Int32)~System.String")]
[assembly: SuppressMessage("Build", "CA1822:Member BuildSkip does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedQueryBuilder.BuildSkip(System.Nullable{System.Int32})~System.String")]
[assembly: SuppressMessage("Build", "CA1822:Member BuildTop does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V2FeedQueryBuilder.BuildTop(System.Nullable{System.Int32})~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<bool, INuGetResource>> V3FeedListResourceProvider.TryCreate(SourceRepository source, CancellationToken token)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.V3FeedListResourceProvider.TryCreate(NuGet.Protocol.Core.Types.SourceRepository,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.Boolean,NuGet.Protocol.Core.Types.INuGetResource}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object VersionRangeConverter.ReadJson(JsonReader reader, Type objectType, object existingValue, JsonSerializer serializer)', validate parameter 'reader' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.VersionRangeConverter.ReadJson(Newtonsoft.Json.JsonReader,System.Type,System.Object,Newtonsoft.Json.JsonSerializer)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void VersionRangeConverter.WriteJson(JsonWriter writer, object value, JsonSerializer serializer)', validate parameter 'serializer' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Protocol.VersionRangeConverter.WriteJson(Newtonsoft.Json.JsonWriter,System.Object,Newtonsoft.Json.JsonSerializer)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void NuGetv3LocalRepository.ClearCacheForIds(IEnumerable<string> packageIds)', validate parameter 'packageIds' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Repositories.NuGetv3LocalRepository.ClearCacheForIds(System.Collections.Generic.IEnumerable{System.String})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'LocalPackageInfo NuGetv3LocalRepository.FindPackage(string packageId, NuGetVersion version)', validate parameter 'version' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Repositories.NuGetv3LocalRepository.FindPackage(System.String,NuGet.Versioning.NuGetVersion)~NuGet.Repositories.LocalPackageInfo")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'LocalPackageSourceInfo NuGetv3LocalRepositoryUtility.GetPackage(IReadOnlyList<NuGetv3LocalRepository> repositories, string id, NuGetVersion version)', validate parameter 'repositories' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Repositories.NuGetv3LocalRepositoryUtility.GetPackage(System.Collections.Generic.IReadOnlyList{NuGet.Repositories.NuGetv3LocalRepository},System.String,NuGet.Versioning.NuGetVersion)~NuGet.Repositories.LocalPackageSourceInfo")]
[assembly: SuppressMessage("Build", "CA1801:Parameter utcNow of method CreateODataServiceDocumentResourceV2 is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:ODataServiceDocumentUtils.CreateODataServiceDocumentResourceV2(System.String,NuGet.Protocol.HttpSource,System.DateTime,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.ODataServiceDocumentResourceV2}")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property RemoteSourceDependencyInfo.ContentUri from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Protocol.Core.Types.RemoteSourceDependencyInfo.ContentUri")]
[assembly: SuppressMessage("Build", "CA2227:Change 'AddHeaders' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Protocol.HttpRetryHandlerRequest.AddHeaders")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property HttpSourceCachedRequest.Uri from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Protocol.HttpSourceCachedRequest.Uri")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Protocol.PackageSearchMetadata.ParsedVersions")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property RepositoryCertificateInfo.ContentUrl from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Protocol.RepositoryCertificateInfo.ContentUrl")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property V2FeedPackageInfo.DownloadUrl from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Protocol.V2FeedPackageInfo.DownloadUrl")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property V2FeedPackageInfo.GalleryDetailsUrl from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Protocol.V2FeedPackageInfo.GalleryDetailsUrl")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property V2FeedPackageInfo.IconUrl from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Protocol.V2FeedPackageInfo.IconUrl")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property V2FeedPackageInfo.LicenseUrl from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Protocol.V2FeedPackageInfo.LicenseUrl")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property V2FeedPackageInfo.ProjectUrl from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Protocol.V2FeedPackageInfo.ProjectUrl")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property V2FeedPackageInfo.ReportAbuseUrl from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Protocol.V2FeedPackageInfo.ReportAbuseUrl")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property V2FeedPage.NextUri from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Protocol.V2FeedPage.NextUri")]
[assembly: SuppressMessage("Build", "CA1012:Abstract type NuGetProtocolException should not have constructors", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Protocol.Core.Types.NuGetProtocolException")]
[assembly: SuppressMessage("Build", "CA2237:Add [Serializable] to NuGetProtocolException as this type implements ISerializable", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Protocol.Core.Types.NuGetProtocolException")]
[assembly: SuppressMessage("Build", "CA1012:Abstract type ResourceProvider should not have constructors", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Protocol.Core.Types.ResourceProvider")]
[assembly: SuppressMessage("Build", "CA1010:Collection 'HttpSourceCredentials' directly or indirectly inherits 'IEnumerable' without implementing 'IEnumerable<T>'. Publicly-visible collections should implement the generic version to broaden usability.", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Protocol.HttpSourceCredentials")]
[assembly: SuppressMessage("Build", "CA1012:Abstract type InvalidCacheProtocolException should not have constructors", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Protocol.InvalidCacheProtocolException")]
[assembly: SuppressMessage("Build", "CA1001:Type 'ODataServiceDocumentResourceV2Provider' owns disposable field(s) '_semaphore' but is not disposable", Justification = "The inheritance hierarchy of 'ODataServiceDocumentResourceV2Provider' doesn't support 'IDisposable' pattern without requiring explicit cast by the caller", Scope = "type", Target = "~T:NuGet.Protocol.ODataServiceDocumentResourceV2Provider")]
[assembly: SuppressMessage("Build", "CA2237:Add [Serializable] to PluginException as this type implements ISerializable", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Protocol.Plugins.PluginException")]
[assembly: SuppressMessage("Build", "CA2237:Add [Serializable] to ProtocolException as this type implements ISerializable", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Protocol.Plugins.ProtocolException")]
[assembly: SuppressMessage("Build", "CA1001:Type 'RemoteV3FindPackageByIdResource' owns disposable field(s) '_dependencyInfoSemaphore, _httpSource' but is not disposable", Justification = "The inheritance hierarchy of 'RemoteV3FindPackageByIdResource' doesn't support 'IDisposable' pattern without requiring explicit cast by the caller", Scope = "type", Target = "~T:NuGet.Protocol.RemoteV3FindPackageByIdResource")]
[assembly: SuppressMessage("Build", "CA1001:Type 'ServiceIndexResourceV3Provider' owns disposable field(s) '_semaphore' but is not disposable", Justification = "The inheritance hierarchy of 'ServiceIndexResourceV3Provider' doesn't support 'IDisposable' pattern without requiring explicit cast by the caller", Scope = "type", Target = "~T:NuGet.Protocol.ServiceIndexResourceV3Provider")]
[assembly: SuppressMessage("Globalization", "CA1308:Normalize strings to uppercase", Justification = "We intentionally making to lower case because we're creating web api query.", Scope = "member", Target = "~M:NuGet.Protocol.PackageSearchResourceV3.SearchPage``1(System.Func{System.Uri,System.Threading.Tasks.Task{``0}},System.String,NuGet.Protocol.Core.Types.SearchFilter,System.Int32,System.Int32,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{``0}")]
[assembly: SuppressMessage("Globalization", "CA1308:Normalize strings to uppercase", Justification = "We convert packageId to lower case for api call.", Scope = "member", Target = "~M:NuGet.Protocol.PackageMetadataResourceV3.GetRegistratioIndexPageAsync(NuGet.Protocol.HttpSource,System.String,System.String,NuGet.Versioning.NuGetVersion,NuGet.Versioning.NuGetVersion,NuGet.Protocol.Core.Types.HttpSourceCacheContext,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Model.RegistrationPage}")]
[assembly: SuppressMessage("Globalization", "CA1308:Normalize strings to uppercase", Justification = "We convert packageId to lower case for api call.", Scope = "member", Target = "~M:NuGet.Protocol.PackageMetadataResourceV3.LoadRegistrationIndexAsync(NuGet.Protocol.HttpSource,System.Uri,System.String,NuGet.Protocol.Core.Types.SourceCacheContext,System.Func{NuGet.Protocol.HttpSourceResult,System.Threading.Tasks.Task{NuGet.Protocol.Model.RegistrationIndex}},NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.ValueTuple{NuGet.Protocol.Model.RegistrationIndex,NuGet.Protocol.Core.Types.HttpSourceCacheContext}}")]
