/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JList;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.driver.JListCellBoundsQuery;
import org.fest.swing.driver.JListCellCenterQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.StringTextMatcher;
import org.fest.swing.util.TextMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JListMatchingItemQuery {
    @RunsInEDT
    static Point centerOfMatchingItemCell(final JList list, final String value, final JListCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                int itemIndex = JListMatchingItemQuery.matchingItemIndex(list, new StringTextMatcher(value), cellReader);
                return JListCellCenterQuery.cellCenter(list, JListCellBoundsQuery.cellBounds(list, itemIndex));
            }
        });
    }

    @RunsInCurrentThread
    static int matchingItemIndex(JList list, TextMatcher matcher, JListCellReader cellReader) {
        int size = list.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            if (!matcher.isMatching(cellReader.valueAt(list, i))) continue;
            return i;
        }
        return -1;
    }

    @RunsInEDT
    static List<Integer> matchingItemIndices(final JList list, final TextMatcher matcher, final JListCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<List<Integer>>(){

            @Override
            protected List<Integer> executeInEDT() {
                HashSet<Integer> indices = new HashSet<Integer>();
                int size = list.getModel().getSize();
                for (int i = 0; i < size; ++i) {
                    if (!matcher.isMatching(cellReader.valueAt(list, i))) continue;
                    indices.add(i);
                }
                ArrayList<Integer> indexList = new ArrayList<Integer>(indices);
                Collections.sort(indexList);
                return indexList;
            }
        });
    }

    @RunsInEDT
    static List<String> matchingItemValues(final JList list, final TextMatcher matcher, final JListCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<List<String>>(){

            @Override
            protected List<String> executeInEDT() {
                ArrayList<String> values = new ArrayList<String>();
                int size = list.getModel().getSize();
                for (int i = 0; i < size; ++i) {
                    String value = cellReader.valueAt(list, i);
                    if (!matcher.isMatching(value)) continue;
                    values.add(value);
                }
                return values;
            }
        });
    }

    private JListMatchingItemQuery() {
    }
}

