/*
 * Decompiled with CFR 0.152.
 */
package jay.yydebug;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.JTextArea;

public class yyJInputStream
extends InputStream
implements KeyListener {
    protected final StringBuffer line = new StringBuffer();
    protected ArrayList queue = new ArrayList();

    @Override
    public synchronized int available() throws IOException {
        if (this.queue == null) {
            throw new IOException("closed");
        }
        return this.queue.isEmpty() ? 0 : ((byte[])this.queue.get(0)).length;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.queue == null) {
            throw new IOException("closed");
        }
        this.queue = null;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.queue == null) {
            throw new IOException("closed");
        }
        while (this.queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("interrupted");
            }
        }
        byte[] byArray = (byte[])this.queue.get(0);
        switch (byArray.length) {
            case 0: {
                return -1;
            }
            case 1: {
                this.queue.remove(0);
                break;
            }
            default: {
                byte[] byArray2 = new byte[byArray.length - 1];
                System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
                this.queue.set(0, byArray2);
                this.notifyAll();
            }
        }
        return byArray[0] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.queue == null) {
            throw new IOException("closed");
        }
        while (this.queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("interrupted");
            }
        }
        byte[] byArray2 = (byte[])this.queue.get(0);
        if (byArray2.length == 0) {
            return -1;
        }
        if (byArray2.length <= n2) {
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            this.queue.remove(0);
            return byArray2.length;
        }
        System.arraycopy(byArray2, 0, byArray, n, n2);
        byte[] byArray3 = new byte[byArray2.length - n2];
        System.arraycopy(byArray2, n2, byArray3, 0, byArray3.length);
        this.queue.set(0, byArray3);
        this.notifyAll();
        return n2;
    }

    @Override
    public long skip(long l) {
        return 0L;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        JTextArea jTextArea = (JTextArea)keyEvent.getComponent();
        int n = keyEvent.getKeyCode();
        if (keyEvent.isControlDown()) {
            try {
                switch (n) {
                    case 67: {
                        jTextArea.getToolkit().getSystemClipboard().setContents(new StringSelection(jTextArea.getSelectedText()), new ClipboardOwner(){

                            @Override
                            public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                            }
                        });
                        keyEvent.consume();
                        break;
                    }
                    case 86: {
                        String string = (String)jTextArea.getToolkit().getSystemClipboard().getContents(this).getTransferData(DataFlavor.stringFlavor);
                        for (int i = 0; i < string.length(); ++i) {
                            this.doKey(jTextArea, string.charAt(i), true);
                        }
                        keyEvent.consume();
                        break;
                    }
                    default: {
                        if (n < 65 || n > 90) {
                            return;
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n2 = jTextArea.getText().length();
        jTextArea.setCaretPosition(n2);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        JTextArea jTextArea = (JTextArea)keyEvent.getComponent();
        this.doKey(jTextArea, keyEvent.getKeyChar(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doKey(JTextArea jTextArea, char c, boolean bl) {
        switch (c) {
            case '\n': 
            case '\r': {
                this.line.append('\n');
                if (!bl) break;
                jTextArea.append("\n");
                break;
            }
            case '\u0004': {
                jTextArea.append("^D\n");
                jTextArea.setCaretPosition(jTextArea.getText().length());
                break;
            }
            case '\b': {
                int n = this.line.length();
                if (n > 0) {
                    this.line.setLength(n - 1);
                }
                if (bl) {
                    jTextArea.append("\b");
                }
                return;
            }
            case '\u0015': {
                this.line.setLength(0);
                jTextArea.append("^U\n");
                jTextArea.setCaretPosition(jTextArea.getText().length());
            }
            case '\u0003': 
            case '\u0016': {
                return;
            }
            default: {
                this.line.append(c);
                if (bl) {
                    jTextArea.append("" + c);
                }
                return;
            }
        }
        yyJInputStream yyJInputStream2 = this;
        synchronized (yyJInputStream2) {
            this.queue.add(this.line.toString().getBytes());
            this.notifyAll();
        }
        this.line.setLength(0);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

