/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.EditorPane;
import WIMSchem.MainPanel;
import WIMSchem.Molecule;
import WIMSchem.MoleculeStream;
import WIMSchem.SVGMolecule;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JApplet;

public class MainApplet
extends JApplet
implements ComponentListener {
    MainPanel mainPanel = null;
    long id;
    String zoom_js;
    public static String g_id = "g_SVG_1000000";
    public static String svg_id = "SVG_1000000";
    static String[] TOOLS = new String[]{"TOOL_CURSOR", "TOOL_ROTATOR", "TOOL_ERASOR", "TOOL_DIALOG", "TOOL_EDIT", "TOOL_SETATOM", "TOOL_SINGLE", "TOOL_DOUBLE", "TOOL_TRIPLE", "TOOL_ZERO", "TOOL_INCLINED", "TOOL_DECLINED", "TOOL_UNKNOWN", "TOOL_CHARGE", "TOOL_UNDO", "TOOL_REDO", "TOOL_TEMPLATE", "TOOL_CUT", "TOOL_COPY", "TOOL_PASTE", "TOOL_UNSELECT", "TOOL_SELECT"};
    static String[] MENUS = new String[]{"MENU_BLOCK", "MENU_SELECT", "MENU_TRANSFORM", "MENU_ZOOM", "MENU_SHOW", "MENU_HYDROGEN", "MENU_STEREO", "MENU_HELP"};
    static int TOOL_COUNT = TOOLS.length;
    static int MENU_COUNT = MENUS.length;
    public static String[] templateURL;
    public static AppletContext applet_context;
    public static String[] myAtoms;
    public static int rotation;
    public static boolean viewC;
    public static boolean viewH;
    public static boolean[] TOOL_SELECTION;
    public static boolean[] MENU_SELECTION;
    public static boolean USER_SELECTION;
    public static int GLOBAL_ALPHA;
    public static int ATOM_SELECT_HTML_COLOR;
    public static int BOND_SELECT_HTML_COLOR;
    public static Color ATOM_SELECT_COLOR;
    public static Color BOND_SELECT_COLOR;
    public static int[] ExternalAtomSelection;
    public static Color[] SelectedAtomColorArray;
    public static int[] ExternalBondSelection;
    public static Color[] SelectedBondColorArray;
    public static int[] SelectedAtomColorInt;
    public static int[] SelectedBondColorInt;
    public static boolean ATOM_BUTTONS;
    public static boolean SUPERUSER_SELECTION;
    public static String language;

    public void init() {
        ATOM_BUTTONS = this.getBool("atom_button_row", false);
        USER_SELECTION = this.getBool("user_selection", false);
        if (USER_SELECTION) {
            GLOBAL_ALPHA = this.getInt("color_alpha", 140);
            if (GLOBAL_ALPHA > 250) {
                GLOBAL_ALPHA = 140;
            }
            ATOM_SELECT_COLOR = this.getColor("default_atom_select_color", GLOBAL_ALPHA, 255, 0, 0);
            BOND_SELECT_COLOR = this.getColor("default_bond_select_color", GLOBAL_ALPHA, 0, 0, 255);
            ATOM_SELECT_HTML_COLOR = this.RGB2int("default_atom_select_color", 255);
            BOND_SELECT_HTML_COLOR = this.RGB2int("default_bond_select_color", 65280);
        }
        this.zoom_js = "";
        language = this.getLanguage();
        TOOL_SELECTION = this.getTools();
        MENU_SELECTION = this.getMenus();
        ExternalAtomSelection = this.SetAtomSelection();
        ExternalBondSelection = this.SetBondSelection();
        rotation = this.getInt("rotation", 0);
        myAtoms = this.GetMyAtoms();
        templateURL = this.getTemplateURL();
        viewC = this.getBool("show_carbon", true);
        viewH = this.getBool("show_hydrogen", true);
        System.out.println("viewC = " + viewC + "\nviewH = " + viewH);
        this.getContentPane().setLayout(new BorderLayout());
        this.mainPanel = new MainPanel(null, 2, null);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.addComponentListener(this);
        this.getFile();
        this.repaint(1000L);
    }

    public String getAppletInfo() {
        return "WIMSchem: Applet version of chemistry\nmolecular diagram drawing tool.";
    }

    public boolean SetMoleculeNative(String Source) {
        try {
            Molecule mol = MoleculeStream.readNative(new BufferedReader(new StringReader(Source.toString())));
            this.mainPanel.setMolecule(mol);
            this.mainPanel.repaint();
            return true;
        }
        catch (IOException e) {
            System.out.println("problems parsing:\n" + Source.toString() + "\n" + e);
            return false;
        }
    }

    public boolean SetMoleculeMDLMol(String Source) {
        try {
            Molecule mol = MoleculeStream.readMDLMOL(new BufferedReader(new StringReader(Source.toString())));
            this.mainPanel.setMolecule(mol);
            this.mainPanel.repaint();
            return true;
        }
        catch (IOException e) {
            System.out.println("problems parsing:\n" + Source.toString() + "\n" + e);
            return false;
        }
    }

    public boolean SetMolecule(String Source, boolean is_molfile) {
        try {
            Molecule mol = is_molfile ? MoleculeStream.readMDLMOL(new BufferedReader(new StringReader(Source.toString()))) : MoleculeStream.readUnknown(new BufferedReader(new StringReader(Source.toString())));
            this.mainPanel.setMolecule(mol);
            this.mainPanel.repaint();
            return true;
        }
        catch (IOException e) {
            System.out.println("error in applet : setMolecule( String Source ) :\ncan not parse : " + Source.toString());
            return false;
        }
    }

    public boolean AppendMolecule(String Source, boolean is_molfile) {
        try {
            Molecule mol = is_molfile ? MoleculeStream.readMDLMOL(new BufferedReader(new StringReader(Source.toString()))) : MoleculeStream.readUnknown(new BufferedReader(new StringReader(Source.toString())));
            this.mainPanel.addMolecule(mol);
            this.mainPanel.repaint();
            return true;
        }
        catch (IOException e) {
            System.out.println("error in applet : appendMolelcule( String Source ) : " + e.toString());
            return false;
        }
    }

    public String GetMoleculeNative() {
        try {
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            MoleculeStream.writeNative(bw, this.mainPanel.molData());
            return sw.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String GetMoleculeMDLMol() {
        try {
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            MoleculeStream.writeMDLMOL(bw, this.mainPanel.molData());
            return sw.toString();
        }
        catch (IOException iOException) {
            return "error getting MDLMol file from applet";
        }
    }

    public int RGB2int(String p, int d) {
        String param = this.getParameter(p);
        if (param != null && param.length() > 0) {
            int k = 0;
            String hex = "";
            String tmp = "";
            StringTokenizer q = new StringTokenizer(param, ",");
            int c = q.countTokens();
            if (c != 3) {
                System.out.println("use R,G,B for colours ; use param color_alpha for transparency");
                return d;
            }
            for (int a = 0; a < 3; ++a) {
                k = Integer.parseInt(q.nextToken(), 10);
                tmp = Integer.toHexString(k);
                while (tmp.length() < 2) {
                    tmp = "0" + tmp;
                }
                hex = hex + "" + tmp;
            }
            return Integer.parseInt(hex, 16);
        }
        return d;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        this.mainPanel.scaleToFit();
        this.mainPanel.repaint();
    }

    public String getSelected() {
        boolean num = false;
        String reply = "";
        Molecule mol = this.mainPanel.editor.molData();
        for (int n = 1; n < mol.numAtoms(); ++n) {
            if (!this.mainPanel.editor.selected[n - 1]) continue;
            reply = reply + mol.atomElement(n - 1) + "\n";
        }
        return reply;
    }

    public String getSVG(String type) {
        SVGMolecule svgmol;
        if (type.equals("1")) {
            try {
                System.out.println("ok : exporting user drawing to SVG");
                svgmol = new SVGMolecule(this.mainPanel.editor.molData());
            }
            catch (Exception e) {
                return e.toString();
            }
        }
        type = this.getString("file2");
        USER_SELECTION = false;
        SUPERUSER_SELECTION = true;
        if (type != null) {
            try {
                String correct_answer = this.loadAny(type);
                Molecule answer_mol = MoleculeStream.readMDLMOL(new BufferedReader(new StringReader(correct_answer.toString())));
                svgmol = new SVGMolecule(answer_mol);
                System.out.println("ok : exporting file2 to SVG");
            }
            catch (Exception e) {
                return e.toString();
            }
        }
        try {
            svgmol = new SVGMolecule(this.mainPanel.editor.molData());
            System.out.println("ok : exporting molecule in applet window to SVG\npossibly colouring atoms and bonds\naccording to color params");
        }
        catch (Exception e) {
            return e.toString();
        }
        double zoom_factor = this.getDouble("zoomfactor", 1.0);
        if (zoom_factor != 1.0) {
            this.id = System.currentTimeMillis();
            g_id = ("g_SVG_" + this.id).toString();
            svg_id = ("SVG_" + this.id).toString();
            this.zoom_js = "<script type=\"text/javascript\">var flip = 0;function SVG_zoom(svg,g,w0,h0){var svg = document.getElementById(svg);var g = document.getElementById(g);var f = " + zoom_factor + ";" + "if( flip == 1 ){" + "flip = 0;" + "var w1 = parseInt(w0*f);" + "var h1 = parseInt(h0*f);" + "svg.setAttributeNS(null, 'viewBox', '0 0 '+w1+' '+h1);" + "svg.setAttributeNS(null, 'width',w1);" + "svg.setAttributeNS(null, 'height',h1);" + "g.setAttributeNS(null,'transform','matrix('+f+' 0 0 '+f+' 0 0)');" + "}else{" + "flip = 1;" + "svg.setAttributeNS(null, 'viewBox', '0 0 '+w0+' '+h0);" + "svg.setAttributeNS(null, 'width',w0);" + "svg.setAttributeNS(null, 'height',h0);" + "g.setAttributeNS(null,'transform','matrix(1 0 0 1 0 0)');" + "};};</script>";
        }
        svgmol.draw();
        String reply = "";
        reply = (svgmol + this.zoom_js).toString();
        return reply.replaceAll("(\\n|\\r|\\  )", " ");
    }

    public boolean[] getTools() {
        boolean[] TOOL_SELECTION = new boolean[TOOL_COUNT];
        for (int p = 0; p < TOOL_COUNT; ++p) {
            String param = this.getParameter(TOOLS[p]);
            TOOL_SELECTION[p] = false;
            if (param == null || !param.equalsIgnoreCase("yes") && !param.equals("1")) continue;
            TOOL_SELECTION[p] = true;
        }
        return TOOL_SELECTION;
    }

    public boolean[] getMenus() {
        boolean[] MENU_SELECTION = new boolean[MENU_COUNT];
        for (int p = 0; p < MENU_COUNT; ++p) {
            String param = this.getParameter(MENUS[p]);
            MENU_SELECTION[p] = false;
            if (param == null || param.length() <= 0 || !param.equalsIgnoreCase("yes") && !param.equals("1")) continue;
            MENU_SELECTION[p] = true;
        }
        return MENU_SELECTION;
    }

    public String[] getTemplateURL() {
        String param = this.getParameter("template1");
        if (param != null && param.length() > 0) {
            int p = 0;
            while (param != null && param.length() != 0) {
                param = this.getParameter("template" + ++p);
            }
            String[] templateURL = new String[p - 1];
            for (int s = 1; s < p; ++s) {
                param = this.getParameter("template" + s);
                System.out.println("loading template url : " + param);
                templateURL[s - 1] = param;
            }
            return templateURL;
        }
        return null;
    }

    public boolean getFile() {
        String showfile = this.getParameter("showfile");
        if (showfile != null && showfile.length() > 0) {
            String filename;
            if ((showfile.equalsIgnoreCase("yes") || showfile.equals("1")) && (filename = this.getParameter("file")) != null && filename.length() > 0) {
                String demomol = this.loadAny(filename);
                if (demomol.indexOf("V2000") < 1) {
                    this.SetMolecule(demomol, false);
                } else {
                    this.SetMolecule(demomol, true);
                }
                return true;
            }
        } else {
            System.out.println("not using external file loading");
        }
        return false;
    }

    public String getString(String p) {
        String param = this.getParameter(p);
        if (param != null && param.length() > 0) {
            return param.toString();
        }
        return null;
    }

    public Boolean getBool(String p, boolean d) {
        String param = this.getParameter(p);
        if (param != null && param.length() > 0) {
            if ((param = param.toLowerCase()).equals("1") || param.equalsIgnoreCase("yes") || param.equalsIgnoreCase("true")) {
                return true;
            }
            if (param.equals("0") || param.equalsIgnoreCase("no") || param.equalsIgnoreCase("false")) {
                return false;
            }
        }
        return d;
    }

    public int getInt(String p, int d) {
        String param = this.getParameter(p);
        if (param != null && param.length() > 0) {
            return Integer.parseInt(param);
        }
        return d;
    }

    public double getDouble(String p, double d) {
        String param = this.getParameter(p);
        if (param != null && param.length() > 0) {
            return Double.parseDouble(param);
        }
        return d;
    }

    public Color getColor(String p, int alpha, int r0, int g0, int b0) {
        String param = this.getParameter(p);
        if (param != null && param.length() > 0) {
            int R1 = 0;
            int G1 = 0;
            int B1 = 0;
            int rgb = 0;
            StringTokenizer q = new StringTokenizer(param, ",");
            int c = q.countTokens();
            if (c != 3) {
                System.out.println("use R,G,B for colours ; use param color_alpha for transparency");
                return new Color(0, 0, 255, 255);
            }
            for (int a = 0; a < 3; ++a) {
                String k = q.nextToken();
                rgb = Integer.parseInt(k, 10);
                if (rgb < 0) {
                    rgb = 0;
                }
                if (rgb > 255) {
                    rgb = 255;
                }
                if (a == 0) {
                    R1 = rgb;
                    continue;
                }
                if (a == 1) {
                    G1 = rgb;
                    continue;
                }
                B1 = rgb;
            }
            return new Color(R1, G1, B1, alpha);
        }
        return new Color(r0, g0, b0, alpha);
    }

    public String[] GetMyAtoms() {
        String param = this.getParameter("atoms");
        if (param != null && param.length() > 0) {
            return this.String2Array(param);
        }
        return null;
    }

    public String getLanguage() {
        String param = this.getParameter("language");
        if (param != null && param.length() == 2) {
            return param.toLowerCase();
        }
        return "en";
    }

    public String ReadAtomSelection() {
        boolean[] S = EditorPane.atomselection;
        String selection = "";
        for (int p = 1; p < S.length; ++p) {
            if (!S[p]) continue;
            selection = selection != "" ? selection + "," + p : "" + p;
        }
        return selection;
    }

    public String ReadBondSelection() {
        boolean[] S = EditorPane.bondselection;
        String selection = "";
        for (int p = 0; p < S.length; ++p) {
            if (!S[p]) continue;
            selection = selection == "" ? "" + p : selection + "," + p;
        }
        return selection;
    }

    public String loadAny(String filename) {
        String demomol = "";
        try {
            return MainApplet.load(filename).toString();
        }
        catch (Exception e) {
            System.out.println("HMMMM");
            return demomol;
        }
    }

    public static byte[] loadURL(URL url) throws IOException {
        int n;
        int bufSize = 2048;
        byte[] buf = new byte[bufSize];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        while ((n = in.read(buf)) > 0) {
            bout.write(buf, 0, n);
        }
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bout.toByteArray();
    }

    public static String loadFile(String fname) throws IOException {
        try {
            byte[] bytes = MainApplet.loadURL(new URL("file:" + fname));
            return new String(bytes);
        }
        catch (Exception e) {
            System.out.println("loadFile error :" + e.toString());
            return null;
        }
    }

    public static String load(String fileOrURL) throws IOException {
        try {
            URL url = new URL(fileOrURL);
            return new String(MainApplet.loadURL(url));
        }
        catch (Exception e) {
            return MainApplet.loadFile(fileOrURL);
        }
    }

    public String[] String2Array(String t) {
        StringTokenizer q;
        if (t.indexOf(",") != -1) {
            q = new StringTokenizer(t, ",");
        } else if (t.indexOf(":") != -1) {
            q = new StringTokenizer(t, ":");
        } else if (t.indexOf(";") != -1) {
            q = new StringTokenizer(t, ";");
        } else if (t.indexOf(" ") > 2) {
            q = new StringTokenizer(t, " ");
        } else {
            return null;
        }
        int max = q.countTokens();
        if (max > 50) {
            max = 50;
        }
        String[] tmp = new String[max];
        String s = "";
        for (int p = 0; p < max; ++p) {
            s = q.nextToken();
            if (s.length() != 1 && s.length() != 2) continue;
            System.out.println("atom = " + s);
            tmp[p] = s;
        }
        return tmp;
    }

    public void send_to_wims(int type) {
        applet_context = this.getAppletContext();
        String wims_ref_name = this.getString("wims_ref_name");
        String session = this.getString("session");
        String module = this.getString("module");
        String replyargs = this.getString("replyarguments");
        if (wims_ref_name == null) {
            System.out.println("param wims_ref_name is not set POST will not work !!");
        } else {
            String student_MDL_molecule = this.GetMoleculeMDLMol();
            String student_svg_molecule = this.getSVG("1");
            String correct_svg_molecule = this.getSVG("2");
            String reply = "";
            switch (type) {
                case 0: {
                    reply = student_MDL_molecule;
                    break;
                }
                case 1: {
                    reply = student_svg_molecule + "\n" + student_MDL_molecule;
                    break;
                }
                case 2: {
                    reply = correct_svg_molecule + "\n" + student_svg_molecule + "\n" + student_MDL_molecule;
                    break;
                }
                default: {
                    reply = "send_to_wims(type) \ntype=1: MDLmol student drawing\ntype=2: student SVG \\n MDLmol student drawing\ntype=3: answer SVG \\n student SVG \\n MDLmol student drawing ";
                }
            }
            try {
                reply = URLEncoder.encode(reply, "UTF-8");
            }
            catch (Exception e) {
                reply = e.toString();
            }
            String back_url_string = wims_ref_name + "?session=" + session + "&module=" + module + "&cmd=reply&" + replyargs;
            back_url_string = back_url_string.replaceAll(" ", "");
            try {
                URL backurl = new URL(back_url_string + reply);
                applet_context.showDocument(backurl, "_self");
            }
            catch (MalformedURLException e) {
                Object backurl = null;
                System.out.println("could not send  to wims " + back_url_string);
            }
        }
    }

    public int[] SetAtomSelection() {
        String param = this.getParameter("select_atoms");
        if (param != null && param.length() > 0) {
            int rgb = 0;
            int R1 = 255;
            int G1 = 0;
            int B1 = 0;
            param = param.replaceAll(";", ",");
            param = param.replaceAll(":", ",");
            StringTokenizer i = new StringTokenizer(param, ",");
            int max = i.countTokens();
            ExternalAtomSelection = new int[max];
            SelectedAtomColorArray = new Color[max];
            SelectedAtomColorInt = new int[max];
            for (int p = 0; p < max; ++p) {
                MainApplet.ExternalAtomSelection[p] = Integer.parseInt(i.nextToken());
                MainApplet.SelectedAtomColorInt[p] = this.RGB2int("select_atom_color" + ExternalAtomSelection[p] + "", 65280);
                String ColorParam = this.getParameter("select_atom_color" + ExternalAtomSelection[p]);
                if (ColorParam != null && ColorParam.length() > 0) {
                    ColorParam = ColorParam.replaceAll(":", ",");
                    ColorParam = ColorParam.replace(";", ",");
                    StringTokenizer q = new StringTokenizer(ColorParam, ",");
                    for (int a = 0; a < 3; ++a) {
                        String k = q.nextToken();
                        rgb = Integer.parseInt(k, 10);
                        if (rgb < 0) {
                            rgb = 0;
                        }
                        if (rgb > 255) {
                            rgb = 255;
                        }
                        if (a == 0) {
                            R1 = rgb;
                            continue;
                        }
                        if (a == 1) {
                            G1 = rgb;
                            continue;
                        }
                        B1 = rgb;
                    }
                    MainApplet.SelectedAtomColorArray[p] = new Color(R1, G1, B1, GLOBAL_ALPHA);
                    continue;
                }
                MainApplet.SelectedAtomColorArray[p] = ATOM_SELECT_COLOR;
            }
            SUPERUSER_SELECTION = true;
        } else {
            ExternalAtomSelection = null;
        }
        return ExternalAtomSelection;
    }

    public int[] SetBondSelection() {
        String param = this.getParameter("select_bonds");
        if (param != null && param.length() > 0) {
            int rgb = 0;
            int R1 = 255;
            int G1 = 0;
            int B1 = 0;
            param = param.replaceAll(";", ",");
            param = param.replaceAll(":", ",");
            StringTokenizer i = new StringTokenizer(param, ",");
            int max = i.countTokens();
            ExternalBondSelection = new int[max];
            SelectedBondColorArray = new Color[max];
            SelectedBondColorInt = new int[max];
            for (int p = 0; p < max; ++p) {
                MainApplet.ExternalBondSelection[p] = Integer.parseInt(i.nextToken());
                MainApplet.SelectedBondColorInt[p] = this.RGB2int("select_bond_color" + ExternalBondSelection[p] + "", 255);
                String ColorParam = this.getParameter("select_bond_color" + ExternalBondSelection[p]);
                if (ColorParam != null && ColorParam.length() > 0) {
                    ColorParam = ColorParam.replaceAll(":", ",");
                    ColorParam = ColorParam.replace(";", ",");
                    StringTokenizer q = new StringTokenizer(ColorParam, ",");
                    for (int a = 0; a < 3; ++a) {
                        String k = q.nextToken();
                        rgb = Integer.parseInt(k, 10);
                        if (rgb < 0) {
                            rgb = 0;
                        }
                        if (rgb > 255) {
                            rgb = 255;
                        }
                        if (a == 0) {
                            R1 = rgb;
                            continue;
                        }
                        if (a == 1) {
                            G1 = rgb;
                            continue;
                        }
                        B1 = rgb;
                    }
                    MainApplet.SelectedBondColorArray[p] = new Color(R1, G1, B1, GLOBAL_ALPHA);
                    continue;
                }
                MainApplet.SelectedBondColorArray[p] = BOND_SELECT_COLOR;
            }
            SUPERUSER_SELECTION = true;
        } else {
            ExternalBondSelection = null;
        }
        return ExternalBondSelection;
    }

    public String ReadApplet() {
        try {
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            MoleculeStream.writeNative(bw, this.mainPanel.molData());
            String nativemol = sw.toString();
            nativemol = nativemol.replaceAll(" ", "");
            return this.moleculeData(nativemol);
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public String moleculeData(String S) {
        String sign;
        int p;
        int N = Molecule.ELEMENTS.length;
        double[] WEIGHTS = new double[]{0.0, 1.00794, 4.002602, 6.941, 9.01218, 10.811, 12.011, 14.00674, 15.9994, 18.998403, 20.1797, 22.989768, 24.305, 26.981539, 28.0855, 30.973762, 32.066, 35.4527, 39.948, 39.0983, 40.078, 44.95591, 47.88, 50.9415, 51.9961, 54.93805, 55.847, 58.9332, 58.6934, 63.546, 65.39, 69.723, 72.61, 74.92159, 78.96, 79.904, 83.8, 85.4678, 87.62, 88.90585, 91.224, 92.90638, 95.94, 97.9072, 101.07, 102.9055, 106.42, 107.8682, 112.411, 114.818, 118.71, 121.76, 127.6, 126.90447, 131.29, 132.90543, 137.327, 138.9055, 140.115, 140.90765, 144.24, 144.9127, 150.36, 151.965, 157.25, 158.92534, 162.5, 164.93032, 167.26, 168.93421, 173.04, 174.967, 178.49, 180.9479, 183.84, 186.207, 190.23, 192.22, 195.08, 196.96654, 200.59, 204.3833, 207.2, 208.98037, 208.9824, 209.9871, 222.0176, 223.0197, 226.0254, 227.0278, 232.0381, 231.03588, 238.0289, 237.048, 244.0642, 243.0614, 247.0703, 247.0703, 251.0796, 252.083, 257.0951, 258.1, 259.1009, 262.11};
        String[] s = S.split("\n");
        int s1 = s[0].indexOf(40);
        int s2 = s[0].indexOf(44);
        int s3 = s[0].indexOf(41);
        int n_s = Integer.parseInt(s[0].substring(s1 + 1, s2).trim());
        int b_s = Integer.parseInt(s[0].substring(s2 + 1, s3).trim());
        String[] E_s = new String[n_s];
        int[] H_s = new int[n_s];
        int[] C_s = new int[n_s];
        int[] R_s = new int[n_s];
        int[] this_A = new int[N];
        int[] this_C = new int[N];
        int[] this_R = new int[N];
        int[] this_H = new int[N];
        String plainformula = "";
        String htmlformula = "";
        String latexformula = "";
        String R_plain = "";
        String R_html = "";
        String R_latex = "";
        String C_plain = "";
        String C_html = "";
        String C_latex = "";
        double weight_s = 0.0;
        int r = 0;
        for (p = 0; p < n_s; ++p) {
            String[] atom = s[p + 1].split("[\\=\\,\\;]");
            E_s[p] = atom[0];
            r = 0;
            for (int n = 0; n < N; ++n) {
                if (!atom[0].equals(Molecule.ELEMENTS[n])) continue;
                weight_s += WEIGHTS[n];
                int n2 = n;
                this_A[n2] = this_A[n2] + 1;
                r = n;
                n = N;
            }
            C_s[p] = Integer.parseInt(atom[3]);
            this_C[r] = C_s[p];
            R_s[p] = Integer.parseInt(atom[4]);
            this_R[p] = R_s[p];
            if (atom[5].indexOf("i") != -1) {
                atom[5] = atom[5].replaceAll("i", "");
                H_s[p] = Integer.parseInt(atom[5]);
                this_H[r] = H_s[p];
                this_A[1] = this_A[1] + H_s[p];
            } else {
                atom[5] = atom[5].replaceAll("e", "");
                H_s[p] = Integer.parseInt(atom[5]);
                this_H[r] = H_s[p];
                this_A[1] = this_A[1] + H_s[p];
            }
            weight_s += (double)H_s[p];
        }
        if (this_A[6] != 0) {
            if (this_R[6] != 0) {
                R_plain = "\u2022";
                R_latex = "^{^{\\cdot}}";
                R_html = "<sup>&cdot;</sup>";
            }
            if (this_C[6] != 0) {
                if (this_C[6] > 0) {
                    sign = "+";
                } else {
                    sign = "-";
                    this_C[6] = Math.abs(this_C[6]);
                }
                C_plain = this_C[6] + sign;
                C_latex = "^{" + this_C[6] + sign + "}";
                C_html = "<sup><small>" + this_C[6] + sign + "</small></sup>";
            }
            if (this_A[6] == 1) {
                plainformula = "C" + C_plain + R_plain + " ";
                htmlformula = "<span style=\"fontsize:110%\" ><tt>C" + C_html + R_html + "</tt></span>";
                latexformula = "\\Bf{C" + C_latex + R_latex + "}";
            } else {
                plainformula = "C" + C_plain + R_plain + this_A[6];
                htmlformula = "<span style=\"fontsize:110%\" ><tt>C" + C_html + R_html + "</tt></span><sub><small>" + this_A[6] + "</small></sub>";
                latexformula = "\\Bf{C" + C_latex + R_latex + "}_{" + this_A[6] + "}";
            }
        }
        for (p = 0; p < N; ++p) {
            if (p == 6) {
                p = 7;
            }
            if (this_A[p] == 0) continue;
            R_plain = "";
            R_html = "";
            R_latex = "";
            C_plain = "";
            C_html = "";
            C_latex = "";
            sign = "";
            if (this_R[p] != 0) {
                R_plain = this_R[p] + "\u2022";
                R_latex = "^{^{" + this_R[p] + "\\cdot}}";
                R_html = "<sup><sup>" + this_R[p] + "&cdot;</sup></sup>";
            }
            if (this_C[p] != 0) {
                if (this_C[p] > 0) {
                    sign = "+";
                } else {
                    sign = "-";
                    this_C[p] = -1 * this_C[p];
                }
                C_plain = this_C[p] + sign;
                C_latex = "^{" + this_C[p] + sign + "}";
                C_html = "<sup><small>" + this_C[p] + sign + "</small></sup>";
            }
            if (this_A[p] == 1) {
                plainformula = plainformula + " " + Molecule.ELEMENTS[p] + "" + C_plain + "" + R_plain;
                htmlformula = htmlformula + " <span style=\"fontsize:110%\" ><tt>" + Molecule.ELEMENTS[p] + C_html + R_html + "</tt></span>";
                latexformula = latexformula + "\\,\\Bf{" + Molecule.ELEMENTS[p] + C_latex + R_latex + "}";
                continue;
            }
            plainformula = plainformula + " " + Molecule.ELEMENTS[p] + "" + C_plain + "" + R_plain + "" + this_A[p];
            htmlformula = htmlformula + " <span style=\"fontsize:110%\" ><tt>" + Molecule.ELEMENTS[p] + C_html + R_html + "</tt></span><sub><small>" + this_A[p] + "</small></sub>";
            latexformula = latexformula + "\\,\\Bf{" + Molecule.ELEMENTS[p] + C_latex + R_latex + "}_{" + this_A[p] + "}";
        }
        DecimalFormat df = new DecimalFormat("#.#", new DecimalFormatSymbols(Locale.US));
        return df.format(weight_s) + "\n" + plainformula + "\n" + htmlformula + "\n" + plainformula + "\n" + latexformula;
    }

    static {
        USER_SELECTION = false;
        GLOBAL_ALPHA = 140;
        ATOM_BUTTONS = true;
        SUPERUSER_SELECTION = false;
    }
}

