/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.util.Enumeration;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.CircleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.TwoPointLineObject;

public class IntersectionObject
extends PointObject {
    protected ConstructionObject P1;
    protected ConstructionObject P2;
    private static Count N = new Count();
    protected Expression Away;
    protected boolean StayAway = true;
    protected boolean First;
    protected boolean Switched;
    protected boolean Restricted;
    protected boolean Alternate;

    public IntersectionObject(Construction construction, ConstructionObject constructionObject, ConstructionObject constructionObject2) {
        super(construction, 0.0, 0.0);
        this.Moveable = false;
        this.P1 = constructionObject;
        this.P2 = constructionObject2;
        this.updateText();
        this.First = true;
        this.Switched = false;
        this.Restricted = true;
        this.Alternate = false;
    }

    public String getTag() {
        return "Intersection";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        try {
            this.setText(IntersectionObject.text2(Zirkel.name("text.intersection"), this.P1.getName(), this.P2.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFirst(boolean bl) {
        this.First = bl;
    }

    public boolean isFirst() {
        return this.First;
    }

    public void validate() {
        this.Valid = this.P1.valid() && this.P2.valid();
    }

    public void validate(double d2, double d3) {
    }

    public void printArgs(XmlWriter xmlWriter) {
        xmlWriter.printArg("first", this.P1.getName());
        xmlWriter.printArg("second", this.P2.getName());
        if (this.getAway() != null) {
            if (this.StayAway) {
                xmlWriter.printArg("awayfrom", this.getAway().getName());
            } else {
                xmlWriter.printArg("closeto", this.getAway().getName());
            }
        }
        this.printType(xmlWriter);
        if (!this.Restricted) {
            xmlWriter.printArg("valid", "true");
        }
        if (this.Alternate) {
            xmlWriter.printArg("alternate", "true");
        }
    }

    public String away() {
        if (this.getAway() != null) {
            return this.getAway().getName();
        }
        return "";
    }

    public boolean stayAway() {
        return this.StayAway;
    }

    public boolean setAway(String string, boolean bl) {
        this.Away = null;
        if (string.equals("")) {
            return true;
        }
        if (this.Cn == null) {
            return true;
        }
        this.Away = new Expression("@\"" + string + "\"", this.Cn, this);
        this.StayAway = bl;
        return this.getAway() != null;
    }

    public boolean setAway(String string) {
        return this.setAway(string, true);
    }

    public Enumeration depending() {
        super.depending();
        return this.depset(this.P1, this.P2);
    }

    public void translate() {
        this.P1 = this.P1.getTranslation();
        this.P2 = this.P2.getTranslation();
        if (this.getAway() != null) {
            this.setAway(this.getAway().getName(), this.StayAway);
            this.Away.translate();
        }
    }

    public boolean isSwitchable() {
        return false;
    }

    public void autoAway() {
        if (!this.autoAway(this.P1, this.P2)) {
            this.autoAway(this.P2, this.P1);
        }
    }

    boolean autoAway(ConstructionObject constructionObject, ConstructionObject constructionObject2) {
        if (constructionObject instanceof CircleObject) {
            PointObject pointObject = ((CircleObject)constructionObject).getP2();
            if (pointObject.isHidden()) {
                return false;
            }
            if (pointObject.dependsOn(constructionObject2) && !this.nearto(pointObject)) {
                this.setAway(pointObject.getName());
                return true;
            }
            if (constructionObject2 instanceof CircleObject) {
                PointObject pointObject2 = ((CircleObject)constructionObject2).getP2();
                if (pointObject2.isHidden()) {
                    return false;
                }
                if (pointObject == pointObject2 && !this.nearto(pointObject)) {
                    this.setAway(pointObject.getName());
                    return true;
                }
                return false;
            }
            if (constructionObject2 instanceof PrimitiveLineObject) {
                Enumeration enumeration = ((PrimitiveLineObject)constructionObject2).points();
                while (enumeration.hasMoreElements()) {
                    ConstructionObject constructionObject3 = (ConstructionObject)enumeration.nextElement();
                    if (!(constructionObject3 instanceof PointObject)) continue;
                    PointObject pointObject3 = (PointObject)constructionObject3;
                    if (pointObject3.isHidden()) {
                        return false;
                    }
                    if (pointObject != pointObject3 || this.nearto(pointObject)) continue;
                    this.setAway(pointObject.getName());
                    return true;
                }
            }
        } else if (constructionObject instanceof TwoPointLineObject) {
            PointObject pointObject = ((TwoPointLineObject)constructionObject).getP1();
            if (!pointObject.isHidden() && pointObject.dependsOn(constructionObject2) && !this.nearto(pointObject)) {
                this.setAway(pointObject.getName());
                return true;
            }
            PointObject pointObject4 = ((TwoPointLineObject)constructionObject).getP2();
            if (!pointObject4.isHidden() && pointObject4.dependsOn(constructionObject2) && !this.nearto(pointObject4)) {
                this.setAway(pointObject4.getName());
                return true;
            }
        }
        return false;
    }

    public void switchBack() {
        if (this.Switched) {
            this.First = !this.First;
        }
        this.Switched = false;
    }

    public void doSwitch() {
        this.Switched = !this.Switched;
        this.First = !this.First;
    }

    public boolean isSwitched() {
        return this.Switched;
    }

    public boolean isRestricted() {
        return this.Restricted;
    }

    public void setRestricted(boolean bl) {
        this.Restricted = bl;
    }

    public PointObject getAway() {
        return IntersectionObject.getPointObject(this.Away);
    }

    public void setAlternate(boolean bl) {
        this.Alternate = bl;
    }

    public boolean isAlternate() {
        return this.Alternate;
    }

    public boolean canAlternate() {
        return false;
    }
}

