/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.CompiledFunction;
import org.javia.arity.Function;
import org.javia.arity.SimpleCodeGen;
import org.javia.arity.Symbol;
import org.javia.arity.SyntaxException;
import org.javia.arity.Token;

class OptCodeGen
extends SimpleCodeGen {
    double[] stack = new double[128];
    int sp = -1;
    double[] traceConsts = new double[1];
    Function[] traceFuncs = new Function[1];
    byte[] traceCode = new byte[1];
    CompiledFunction tracer = new CompiledFunction(0, this.traceCode, this.traceConsts, this.traceFuncs);
    int intrinsicArity;

    OptCodeGen(SyntaxException syntaxException) {
        super(syntaxException);
    }

    @Override
    void start() {
        super.start();
        this.sp = -1;
        this.intrinsicArity = 0;
    }

    @Override
    void push(Token token) throws SyntaxException {
        byte by;
        switch (token.id) {
            case 9: {
                by = 1;
                this.traceConsts[0] = token.value;
                break;
            }
            case 10: 
            case 11: {
                Symbol symbol = this.symbols.lookup(token.name, token.arity);
                if (symbol == null) {
                    throw this.exception.set("undefined '" + token.name + "' with arity " + token.arity, token.position);
                }
                if (symbol.op > 0) {
                    int n;
                    by = symbol.op;
                    if (by < 37 || by > 41 || (n = by - 37) + 1 <= this.intrinsicArity) break;
                    this.intrinsicArity = n + 1;
                    break;
                }
                if (symbol.fun != null) {
                    by = 2;
                    this.traceFuncs[0] = symbol.fun;
                    break;
                }
                by = 1;
                this.traceConsts[0] = symbol.value;
                break;
            }
            default: {
                by = token.vmop;
                if (by > 0) break;
                throw new Error("wrong vmop: " + by);
            }
        }
        int n = this.sp++;
        this.traceCode[0] = by;
        if (by != 8) {
            this.sp = this.tracer.execWithoutCheck(this.stack, this.sp);
        } else {
            this.stack[this.sp] = Double.NaN;
        }
        if (!Double.isNaN(this.stack[this.sp]) || by == 1) {
            this.code.pop(n + 1 - this.sp);
            this.consts.pop(n + 1 - this.sp);
            this.consts.push(this.stack[this.sp]);
            by = 1;
        } else if (by == 2) {
            this.funcs.push(this.traceFuncs[0]);
        }
        this.code.push(by);
    }

    CompiledFunction getFun(int n) {
        return new CompiledFunction(n, this.code.toArray(), this.consts.toArray(), this.funcs.toArray());
    }
}

