/*-------------------------------------------------------------------------*\

	FILE........: FOUR_SH3.C
	TYPE........: C function
	COMPANY.....: VoiceTronix
	AUTHOR......: John Kostogiannis
	DATE CREATED: 26/6/96

	Fixed point development of the fft routine compatible with the
	C5x code by Papamichalis and four1() in Numerical recipes in C.
	Note only the first N/2 points of the N point FFT are determined.

\*-------------------------------------------------------------------------*/

#include 	<math.h>
#include     	"defines.h"
#include        "four_sh3.h"
#include 	"fftstage.h"
#include        "dftrf.h"
#include        "dftif.h"

#define SWAP(a,b) tempr=(a);(a)=(b);(b)=tempr

void four_sh3(int *data,int *datafx, int nn,int *cos_tables)
/* int data[];		  	ptr to complex output array	*/
/* int datafx[];		ptr to real input array		*/
/* int nn,                      number of points in the FFT	*/
/* int cos_tables[]		twiddle tables			*/
{
    int n,m,j,i;
    int tempr;

    /* bit reversal */

    n=nn ;
    j=1;
    for (i=1;i<n;i++)
    {
	if (j > i)
	{
	    SWAP(datafx[j],datafx[i]);
	}
	m=n >> 	1;
	while (m >= 1 && j > m)
	{
	    j -= m;
	    m >>= 1;
	}
	j += m;
    }

	/* 1st stage */

	fft_stage_1(datafx,nn);

	/* 2nd stage	*/

	fft_stage_2(datafx,nn);

	/* 3rd stage */

	fft_stage_3(datafx,nn);

	/* stage 4 */

	fft_stage_4(datafx,nn);

	/* stage 5 */

	fft_stage_5(datafx,nn,cos_tables);

	/* stage 6 */

	fft_stage_6(datafx,nn,cos_tables);

	/* stage 7 */

	fft_stage_7(datafx,nn,cos_tables);

	/* stage 8 */

	fft_stage_8(datafx,nn,cos_tables);

	/* format output array from FFT into a complex output array of the
	   form real,imag,real, imag,......real, imag		      	*/
/*	data[1] = datafx[1];
	for (i=2,j=3;i<=nn/2+1;i++,j+=2)
	    data[j] = datafx[i];
	for(i=nn,j=3;i>nn/2+1;i--,j+=2)
	    data[j+1] = datafx[i];*/

	dft_real_format(&data[1],&datafx[1],nn/2+1);
	dft_imag_format(&data[4],&datafx[nn],nn/2);
}

