#include <assert.h>

#include "hackerlab/vu/vu.h"
#include "hackerlab/vu/vu-sys.h"

#include "hackerlab/vu/vu.h"
#include "vu-pathcompress.h"

#include <stdio.h>
#include <string.h>

#define MAX_PATH_LEN 32768

int traverse(char* path, int ls, int rm, int find, int recurse, int longfmt)
{

  DIR* dir;
  int err;

  if (vu_opendir(&err, &dir, path) < 0) {
    printf("dir %s failed\n", path);
  } else {
    if ((recurse<2) && (!find)) {
      if (longfmt) {
	char compressed[1024];
	char uncompressed[1024];
	pathcompress_compress_path(path, compressed, NULL);
	sprintf(uncompressed, "%s:", path);
	printf("%-40s%s\n", uncompressed, compressed);
      } else {
	printf("%s:\n", path);
      }
    }
    char* file = NULL;
    for(;;) {
      int rvl;
      rvl = vu_readdir(&err, 0, &file, dir);
      if (file == NULL || rvl != 0) {
	break;
      }
      if (
	  (strcmp(file, ".")==0)
	  || (strcmp(file, "..")==0)
	  ) {
	lim_free(0, file);
	continue;
      }

      char* filepath = (char*)lim_malloc(0, MAX_PATH_LEN);
      sprintf(filepath, "%s/%s", path, file);
      struct stat buf;
      if (vu_stat(&err, filepath, &buf)!= 0) {
	printf("stat(%s)=%d\n", filepath, err);
      } else
      if (S_ISREG(buf.st_mode)) {
	if (0) { printf("%d\t", strlen(filepath)); }
	if (ls) {
	  printf("%*.*s%s\n", recurse, recurse, "", file);
	}
	if (find) {
	  printf("%s\n", filepath);
	}
	if (rm) {
	  printf("unlink(%s)\n", filepath);
	  vu_chmod(&err, filepath, S_IWUSR);
	  vu_unlink(&err, filepath);
	}
      } else {
	if (0) { printf("%d\t", strlen(filepath)); }
	if (find) {
	  printf("%s\n", filepath);
	}
	if (ls) {
          if (longfmt) {
            char compressed[1024];
            char uncompressed[1024];
            pathcompress_compress_path(filepath, compressed, NULL);
            sprintf(uncompressed, "%s:", file);
	    printf("%*.*s%-40s%s\n", recurse, recurse, "", uncompressed, compressed);
          } else {
	    printf("%*.*s%s:\n", recurse, recurse, "", file);
          }
	}
	if (recurse || find) {
	  {
	    traverse(filepath, ls, rm, find, recurse+1, longfmt);
	  }
	}
	lim_free(0, filepath);
      }
    }
    vu_closedir(&err, dir);
    if (rm) {
      vu_chmod(&err, path, 0777);
      vu_rmdir(&err, path);
    }
  }
  return 0;
}


int main(int argc, char* argv[])
{
  regex_t reg;
  char* pattern="";
  int rm = 0;
  int ls = 0;
  int find = 0;
  int r = 0;
  int l = 0;
  char* dirpath = "/arch/ller/w32/wd/hello-world/todel";
  dirpath=".";

  if (argc<2) {
	ls = 1;
	r = 0;
  }
  char* prog = argv[0];
  char* p = prog+strlen(prog);
  while (p>prog) {
	if (strcmp(p,".exe")==0) { *p=0; }
	if (*p=='/') { prog=p+1; break; }
	if (*p=='\\') { prog=p+1; break; }
	p--;
  }
  if (prog[0] == 'c')
    prog++;
  else if (prog[0] == 'v' && prog[1] == 'u' && prog[2] == '-')
    prog += 3;
  if (strcmp(prog,"ls")==0) {
	ls = 1;
	if (argc>1) {
	  if (strcmp(argv[1],"-r")==0) {
		r = 1;
	  }
	  if (strcmp(argv[1],"-l")==0) {
		l = 1;
	  }
	  if (argc>2) {
	    if (strcmp(argv[2],"-r")==0) {
		r = 1;
	    }
	    if (strcmp(argv[2],"-l")==0) {
		l = 1;
	    }
	  }
	}
  }
  if (strcmp(prog,"find")==0) {
	ls = 0;
	r = 0;
	find = 1;
  }
  if (strcmp(prog,"rm")==0) {
	rm = 1;
	if (argc>1) {
	  if (strcmp(argv[1],"-r")==0) {
		r = 1;
	  }
	}
  }
  if (argc>1) {
    if (argv[1][0] == '-') {
      if (argc>2) {
	if (argv[2][0] == '-') {
	  if (argc>3) {
	    dirpath = argv[3];
	  }
	} else {
	  dirpath = argv[2];
	}
      } else {
	if (argc>2) {
	  dirpath = argv[2];
	}
      }
    } else {
      if (argc>1) {
	dirpath = argv[1];
      }
    }
  }

  p = dirpath+strlen(dirpath)-1;
  while (p>dirpath) {
	if (*p=='/') {
	  *p=0;
	} else {
	  break;
	}
	p--;
  }

#ifdef PUSH
  if (strcmp("pathcompress", PUSH)==0) {
    pattern = "/*";
    regcomp(&reg, pattern, 0);
    vu_push_name_handler("pathcompress", NULL, &reg, 0, &pathcompress_fs_vtable, NULL, 0);
  }
#endif

  //printf("%s ls=%d rm=%d, find=%d, r=%d\n", prog, ls, rm, find, r);
  traverse(dirpath, ls, rm, find, r, l);
  return 0;
}
