/* ComboBox.h */

/* Copyright (C) 2011-2020 Michael Lugmair (Lucio Carreras)
 *
 * This file is part of sayonara player
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SAYONARACOMBOBOX_H
#define SAYONARACOMBOBOX_H

#include "Gui/Utils/Widgets/Widget.h"
#include <QComboBox>

namespace Gui
{
	/**
	 * @brief A custom combobox which also uses the Gui::ComboBoxDelegate
	 * @ingroup Widgets
	 */
	class ComboBox :
			public Gui::WidgetTemplate<QComboBox>
	{
		Q_OBJECT

		public:
			explicit ComboBox(QWidget* parent=nullptr);
			virtual ~ComboBox() override;

		protected:
			void changeEvent(QEvent* e) override;
	};
}

#endif // SAYONARACOMBOBOX_H
