# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.simple_reader import SimpleReader


class DataReader(SimpleReader):
    r"""
    DataReader - helper superclass for objects that read vtk data files
    
    Superclass: SimpleReader
    
    DataReader is a helper superclass that reads the vtk data file
    header, dataset type, and attribute data (point and cell attributes
    such as scalars, vectors, normals, etc.) from a vtk data file.  See
    text for the format of the various vtk file types.
    
    @sa
    PolyDataReader StructuredPointsReader StructuredGridReader
    UnstructuredGridReader RectilinearGridReader
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDataReader, obj, update, **traits)
    
    read_all_color_scalars = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable reading all color scalars.
        """
    )

    def _read_all_color_scalars_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReadAllColorScalars,
                        self.read_all_color_scalars_)

    read_all_fields = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable reading all fields.
        """
    )

    def _read_all_fields_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReadAllFields,
                        self.read_all_fields_)

    read_all_normals = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable reading all normals.
        """
    )

    def _read_all_normals_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReadAllNormals,
                        self.read_all_normals_)

    read_all_scalars = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable reading all scalars.
        """
    )

    def _read_all_scalars_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReadAllScalars,
                        self.read_all_scalars_)

    read_all_t_coords = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable reading all tcoords.
        """
    )

    def _read_all_t_coords_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReadAllTCoords,
                        self.read_all_t_coords_)

    read_all_tensors = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable reading all tensors.
        """
    )

    def _read_all_tensors_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReadAllTensors,
                        self.read_all_tensors_)

    read_all_vectors = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable reading all vectors.
        """
    )

    def _read_all_vectors_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReadAllVectors,
                        self.read_all_vectors_)

    read_from_input_string = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable reading from an input_string or input_array instead of the
        default, a file.
        """
    )

    def _read_from_input_string_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReadFromInputString,
                        self.read_from_input_string_)

    field_data_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set the name of the field data to extract. If not specified, uses
        first field data encountered in file.
        """
    )

    def _field_data_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFieldDataName,
                        self.field_data_name)

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Specify file name of vtk data file to read. This is just a
        convenience method that calls the superclass' add_file_name method.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    def _get_input_array(self):
        return wrap_vtk(self._vtk_obj.GetInputArray())
    def _set_input_array(self, arg):
        old_val = self._get_input_array()
        my_arg = deref_array([arg], [['vtkCharArray']])
        self._wrap_call(self._vtk_obj.SetInputArray,
                        my_arg[0])
        self.trait_property_changed('input_array', old_val, arg)
    input_array = traits.Property(_get_input_array, _set_input_array, desc=\
        r"""
        
        """
    )

    input_string = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _input_string_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInputString,
                        self.input_string)

    lookup_table_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set the name of the lookup table data to extract. If not
        specified, uses lookup table named by scalar. Otherwise, this
        specification supersedes.
        """
    )

    def _lookup_table_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLookupTableName,
                        self.lookup_table_name)

    normals_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set the name of the normal data to extract. If not specified,
        first normal data encountered is extracted.
        """
    )

    def _normals_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormalsName,
                        self.normals_name)

    scalars_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set the name of the scalar data to extract. If not specified,
        first scalar data encountered is extracted.
        """
    )

    def _scalars_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScalarsName,
                        self.scalars_name)

    t_coords_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set the name of the texture coordinate data to extract. If not
        specified, first texture coordinate data encountered is
        extracted.
        """
    )

    def _t_coords_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTCoordsName,
                        self.t_coords_name)

    tensors_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set the name of the tensor data to extract. If not specified,
        first tensor data encountered is extracted.
        """
    )

    def _tensors_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTensorsName,
                        self.tensors_name)

    vectors_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set the name of the vector data to extract. If not specified,
        first vector data encountered is extracted.
        """
    )

    def _vectors_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVectorsName,
                        self.vectors_name)

    def get_field_data_name_in_file(self, *args):
        """
        get_field_data_name_in_file(self, i:int) -> str
        C++: const char *get_field_data_name_in_file(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetFieldDataNameInFile, *args)
        return ret

    def _get_file_major_version(self):
        return self._vtk_obj.GetFileMajorVersion()
    file_major_version = traits.Property(_get_file_major_version, desc=\
        r"""
        
        """
    )

    def _get_file_minor_version(self):
        return self._vtk_obj.GetFileMinorVersion()
    file_minor_version = traits.Property(_get_file_minor_version, desc=\
        r"""
        
        """
    )

    def _get_file_type(self):
        return self._vtk_obj.GetFileType()
    file_type = traits.Property(_get_file_type, desc=\
        r"""
        Get the type of file (ASCII or BINARY). Returned value only valid
        after file has been read.
        """
    )

    def _get_file_version(self):
        return self._vtk_obj.GetFileVersion()
    file_version = traits.Property(_get_file_version, desc=\
        r"""
        Return the version of the file read; for example, VTK legacy
        readers will return the version of the VTK legacy file. (In the
        case of VTK legacy files, see DataWriter.h for the enum types
        returned.) This method only returns useful information after a
        successful read is performed; and some derived classes may not
        return relevant information.) Note that for VTK legacy readers,
        the file_version is defined by the compositing the major version
        digits with the minor version digit. Extremely ancient VTK files
        (e.g., before version 4.2) will return a file_version of 3.0.
        """
    )

    def _get_header(self):
        return self._vtk_obj.GetHeader()
    header = traits.Property(_get_header, desc=\
        r"""
        Get the header from the vtk data file.
        """
    )

    def _get_input_string_length(self):
        return self._vtk_obj.GetInputStringLength()
    input_string_length = traits.Property(_get_input_string_length, desc=\
        r"""
        
        """
    )

    def get_normals_name_in_file(self, *args):
        """
        get_normals_name_in_file(self, i:int) -> str
        C++: const char *get_normals_name_in_file(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetNormalsNameInFile, *args)
        return ret

    def _get_number_of_field_data_in_file(self):
        return self._vtk_obj.GetNumberOfFieldDataInFile()
    number_of_field_data_in_file = traits.Property(_get_number_of_field_data_in_file, desc=\
        r"""
        
        """
    )

    def _get_number_of_normals_in_file(self):
        return self._vtk_obj.GetNumberOfNormalsInFile()
    number_of_normals_in_file = traits.Property(_get_number_of_normals_in_file, desc=\
        r"""
        
        """
    )

    def _get_number_of_scalars_in_file(self):
        return self._vtk_obj.GetNumberOfScalarsInFile()
    number_of_scalars_in_file = traits.Property(_get_number_of_scalars_in_file, desc=\
        r"""
        How many attributes of various types are in this file? This
        requires reading the file, so the filename must be set prior to
        invoking this operation. (Note: file characteristics are cached,
        so only a single read is necessary to return file
        characteristics.)
        """
    )

    def _get_number_of_t_coords_in_file(self):
        return self._vtk_obj.GetNumberOfTCoordsInFile()
    number_of_t_coords_in_file = traits.Property(_get_number_of_t_coords_in_file, desc=\
        r"""
        
        """
    )

    def _get_number_of_tensors_in_file(self):
        return self._vtk_obj.GetNumberOfTensorsInFile()
    number_of_tensors_in_file = traits.Property(_get_number_of_tensors_in_file, desc=\
        r"""
        
        """
    )

    def _get_number_of_vectors_in_file(self):
        return self._vtk_obj.GetNumberOfVectorsInFile()
    number_of_vectors_in_file = traits.Property(_get_number_of_vectors_in_file, desc=\
        r"""
        
        """
    )

    def get_scalars_name_in_file(self, *args):
        """
        get_scalars_name_in_file(self, i:int) -> str
        C++: const char *get_scalars_name_in_file(int i)
        What is the name of the ith attribute of a certain type in this
        file? This requires reading the file, so the filename must be set
        prior to invoking this operation.
        """
        ret = self._wrap_call(self._vtk_obj.GetScalarsNameInFile, *args)
        return ret

    def get_t_coords_name_in_file(self, *args):
        """
        get_t_coords_name_in_file(self, i:int) -> str
        C++: const char *get_t_coords_name_in_file(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetTCoordsNameInFile, *args)
        return ret

    def get_tensors_name_in_file(self, *args):
        """
        get_tensors_name_in_file(self, i:int) -> str
        C++: const char *get_tensors_name_in_file(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetTensorsNameInFile, *args)
        return ret

    def get_vectors_name_in_file(self, *args):
        """
        get_vectors_name_in_file(self, i:int) -> str
        C++: const char *get_vectors_name_in_file(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetVectorsNameInFile, *args)
        return ret

    def close_vtk_file(self):
        """
        close_vtk_file(self) -> None
        C++: void close_vtk_file()
        Close the vtk file.
        """
        ret = self._vtk_obj.CloseVTKFile()
        return ret
        

    def is_file_poly_data(self):
        """
        is_file_poly_data(self) -> int
        C++: int is_file_poly_data()"""
        ret = self._vtk_obj.IsFilePolyData()
        return ret
        

    def is_file_rectilinear_grid(self):
        """
        is_file_rectilinear_grid(self) -> int
        C++: int is_file_rectilinear_grid()"""
        ret = self._vtk_obj.IsFileRectilinearGrid()
        return ret
        

    def is_file_structured_grid(self):
        """
        is_file_structured_grid(self) -> int
        C++: int is_file_structured_grid()"""
        ret = self._vtk_obj.IsFileStructuredGrid()
        return ret
        

    def is_file_structured_points(self):
        """
        is_file_structured_points(self) -> int
        C++: int is_file_structured_points()"""
        ret = self._vtk_obj.IsFileStructuredPoints()
        return ret
        

    def is_file_unstructured_grid(self):
        """
        is_file_unstructured_grid(self) -> int
        C++: int is_file_unstructured_grid()"""
        ret = self._vtk_obj.IsFileUnstructuredGrid()
        return ret
        

    def is_file_valid(self, *args):
        """
        is_file_valid(self, dstype:str) -> int
        C++: int is_file_valid(const char *dstype)
        Is the file a valid vtk file of the passed dataset type ? The
        dataset type is passed as a lower case string.
        """
        ret = self._wrap_call(self._vtk_obj.IsFileValid, *args)
        return ret

    def lower_case(self, *args):
        """
        lower_case(self, str:str, len:int=256) -> str
        C++: char *lower_case(char *str, const size_t len=256)
        Helper method for reading in data.
        """
        ret = self._wrap_call(self._vtk_obj.LowerCase, *args)
        return ret

    def open_vtk_file(self, *args):
        """
        open_vtk_file(self, fname:str=...) -> int
        C++: int open_vtk_file(const char *fname=nullptr)
        Open a vtk data file. Returns zero if error.
        """
        ret = self._wrap_call(self._vtk_obj.OpenVTKFile, *args)
        return ret

    def peek(self, *args):
        """
        peek(self, str:str, n:int) -> int
        C++: size_t peek(char *str, size_t n)
        Read n character from the stream into str, then reset the stream
        position. Returns the number of characters actually read.
        """
        ret = self._wrap_call(self._vtk_obj.Peek, *args)
        return ret

    def read(self, *args):
        """
        read(self, __a:str) -> int
        C++: int read(char *)
        read(self, __a:[int, ...]) -> int
        C++: int read(int *)
        read(self, __a:[int, ...]) -> int
        C++: int read(long *)
        read(self, result:[int, ...]) -> int
        C++: int read(long long *result)
        read(self, __a:[float, ...]) -> int
        C++: int read(double *)
        Internal function to read in a value.  Returns zero if there was
        an error.
        """
        ret = self._wrap_call(self._vtk_obj.Read, *args)
        return ret

    def read_array(self, *args):
        """
        read_array(self, dataType:str, numTuples:int, numComp:int)
            -> AbstractArray
        C++: AbstractArray *read_array(const char *dataType,
            IdType numTuples, IdType numComp)
        Helper functions for reading data.
        """
        ret = self._wrap_call(self._vtk_obj.ReadArray, *args)
        return wrap_vtk(ret)

    def read_cell_data(self, *args):
        """
        read_cell_data(self, ds:DataSet, numCells:int) -> int
        C++: int read_cell_data(DataSet *ds, IdType numCells)
        Read the cell data of a vtk data file. The number of cells (from
        the dataset) must match the number of cells defined in cell
        attributes (unless no geometry was defined).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadCellData, *my_args)
        return ret

    def read_cells(self, *args):
        """
        read_cells(self, cellArray:SmartPointer_I12vtkCellArrayE) -> int
        C++: int read_cells(SmartPointer<vtkCellArray> &cellArray)
        Read cells in a CellArray, and update the smartpointer
        reference passed in. If no cells are present in the file,
        cellArray will be set to nullptr. Returns 0 if error.
        """
        my_args = deref_array(args, [['vtkSmartPointer_I12vtkCellArrayE']])
        ret = self._wrap_call(self._vtk_obj.ReadCells, *my_args)
        return ret

    def read_cells_legacy(self, *args):
        """
        read_cells_legacy(self, size:int, data:[int, ...]) -> int
        C++: int read_cells_legacy(IdType size, int *data)
        read_cells_legacy(self, size:int, data:[int, ...], skip1:int,
            read2:int, skip3:int) -> int
        C++: int read_cells_legacy(IdType size, int *data, int skip1,
            int read2, int skip3)
        Read a bunch of "cells". Return 0 if error.
        
        ote Legacy implementation for file versions < 5.0.
        """
        ret = self._wrap_call(self._vtk_obj.ReadCellsLegacy, *args)
        return ret

    def read_coordinates(self, *args):
        """
        read_coordinates(self, rg:RectilinearGrid, axes:int,
            numCoords:int) -> int
        C++: int read_coordinates(RectilinearGrid *rg, int axes,
            int numCoords)
        Read the coordinates for a rectilinear grid. The axes parameter
        specifies which coordinate axes (0,1,2) is being read.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadCoordinates, *my_args)
        return ret

    def read_edge_data(self, *args):
        """
        read_edge_data(self, g:Graph, numEdges:int) -> int
        C++: int read_edge_data(Graph *g, IdType numEdges)
        Read the edge data of a vtk data file. The number of edges (from
        the graph) must match the number of edges defined in edge
        attributes (unless no geometry was defined).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadEdgeData, *my_args)
        return ret

    def read_field_data(self, *args):
        """
        read_field_data(self, fieldType:FieldType=...) -> FieldData
        C++: FieldData *read_field_data(FieldType fieldType=FIELD_DATA)"""
        ret = self._wrap_call(self._vtk_obj.ReadFieldData, *args)
        return wrap_vtk(ret)

    def read_header(self, *args):
        """
        read_header(self, fname:str=...) -> int
        C++: int read_header(const char *fname=nullptr)
        Read the header of a vtk data file. Returns 0 if error.
        """
        ret = self._wrap_call(self._vtk_obj.ReadHeader, *args)
        return ret

    def read_line(self, *args):
        """
        read_line(self, result:[str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str]) -> int
        C++: int read_line(char result[256])
        Internal function to read in a line up to 256 characters. Returns
        zero if there was an error.
        """
        ret = self._wrap_call(self._vtk_obj.ReadLine, *args)
        return ret

    def read_point_coordinates(self, *args):
        """
        read_point_coordinates(self, ps:PointSet, numPts:int) -> int
        C++: int read_point_coordinates(PointSet *ps, IdType numPts)
        read_point_coordinates(self, g:Graph, numPts:int) -> int
        C++: int read_point_coordinates(Graph *g, IdType numPts)
        Read point coordinates. Return 0 if error.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadPointCoordinates, *my_args)
        return ret

    def read_point_data(self, *args):
        """
        read_point_data(self, ds:DataSet, numPts:int) -> int
        C++: int read_point_data(DataSet *ds, IdType numPts)
        Read the point data of a vtk data file. The number of points
        (from the dataset) must match the number of points defined in
        point attributes (unless no geometry was defined).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadPointData, *my_args)
        return ret

    def read_row_data(self, *args):
        """
        read_row_data(self, t:Table, numEdges:int) -> int
        C++: int read_row_data(Table *t, IdType numEdges)
        Read the row data of a vtk data file.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadRowData, *my_args)
        return ret

    def read_string(self, *args):
        """
        read_string(self, result:[str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str, str, str, str, str,
            str, str, str, str, str, str, str, str]) -> int
        C++: int read_string(char result[256])
        Internal function to read in a string up to 256 characters.
        Returns zero if there was an error.
        """
        ret = self._wrap_call(self._vtk_obj.ReadString, *args)
        return ret

    def read_vertex_data(self, *args):
        """
        read_vertex_data(self, g:Graph, numVertices:int) -> int
        C++: int read_vertex_data(Graph *g, IdType numVertices)
        Read the vertex data of a vtk data file. The number of vertices
        (from the graph) must match the number of vertices defined in
        vertex attributes (unless no geometry was defined).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadVertexData, *my_args)
        return ret

    def set_binary_input_string(self, *args):
        """
        set_binary_input_string(self, __a:str, len:int) -> None
        C++: void set_binary_input_string(const char *, int len)"""
        ret = self._wrap_call(self._vtk_obj.SetBinaryInputString, *args)
        return ret

    _updateable_traits_ = \
    (('read_all_color_scalars', 'GetReadAllColorScalars'),
    ('read_all_fields', 'GetReadAllFields'), ('read_all_normals',
    'GetReadAllNormals'), ('read_all_scalars', 'GetReadAllScalars'),
    ('read_all_t_coords', 'GetReadAllTCoords'), ('read_all_tensors',
    'GetReadAllTensors'), ('read_all_vectors', 'GetReadAllVectors'),
    ('read_from_input_string', 'GetReadFromInputString'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('field_data_name', 'GetFieldDataName'), ('file_name', 'GetFileName'),
    ('input_string', 'GetInputString'), ('lookup_table_name',
    'GetLookupTableName'), ('normals_name', 'GetNormalsName'),
    ('scalars_name', 'GetScalarsName'), ('t_coords_name',
    'GetTCoordsName'), ('tensors_name', 'GetTensorsName'),
    ('vectors_name', 'GetVectorsName'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'read_all_color_scalars', 'read_all_fields', 'read_all_normals',
    'read_all_scalars', 'read_all_t_coords', 'read_all_tensors',
    'read_all_vectors', 'read_from_input_string', 'release_data_flag',
    'field_data_name', 'file_name', 'input_string', 'lookup_table_name',
    'normals_name', 'progress_text', 'scalars_name', 't_coords_name',
    'tensors_name', 'vectors_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DataReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DataReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['read_all_color_scalars', 'read_all_fields',
            'read_all_normals', 'read_all_scalars', 'read_all_t_coords',
            'read_all_tensors', 'read_all_vectors', 'read_from_input_string'], [],
            ['field_data_name', 'file_name', 'input_string', 'lookup_table_name',
            'normals_name', 'scalars_name', 't_coords_name', 'tensors_name',
            'vectors_name']),
            title='Edit DataReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DataReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

