'\" t
.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbSetMap __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbSetMap \- Send a complete new set of values for entire components to the 
server. 
.SH SYNOPSIS
.HP
.B Bool XkbSetMap
.BI "(\^Display *" "dpy" "\^,"
.BI "unsigned int " "which" "\^,"
.BI "XkbDescPtr " "xkb" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I dpy
connection to X server
.TP
.I which
mask selecting subcomponents to update
.TP
.I xkb
description from which new values are taken
.SH DESCRIPTION
.LP
There are two ways to make changes to map components: either change a local copy 
of the keyboard map and call 
.I XkbSetMap 
to send the modified map to the server, or, to reduce network traffic, use an 
XkbMapChangesRec structure and call 
.I XkbChangeMap.

Use 
.I XkbSetMap 
to send a complete new set of values for entire components (for example, all 
symbols, all actions, and so on) to the server. The 
.I which 
parameter specifies the components to be sent to the server, and is a bitwise 
inclusive OR of the masks listed in Table 1. The 
.I xkb 
parameter is a pointer to an XkbDescRec structure and contains the information 
to be copied to the server. For each bit set in the 
.I which 
parameter, 
.I XkbSetMap 
takes the corresponding structure values from the 
.I xkb 
parameter and sends it to the server specified by 
.IR dpy . 

If any components specified by 
.I which 
are not present in the 
.I xkb 
parameter, 
.I XkbSetMap 
returns False. Otherwise, it sends the update request to the server and returns 
True. 
.I XkbSetMap 
can generate BadAlloc, BadLength, and BadValue protocol errors.

Key types, symbol maps, and actions are all interrelated; changes in one require 
changes in the others. Xkb provides functions to make it easier to edit these 
components and handle the interdependencies. Table 1 
lists these helper functions and provides a pointer to where they are defined.

.TS
c s s s s
c s s s s
l l l l l
l l l l l
lw(2i) l l lw(1i) lw(3i).
Table 1 Xkb Mapping Component Masks
and Convenience Functions
_
Mask	Value	Map	Fields	Convenience	
				Functions
_
T{
XkbKeyTypesMask
T}	(1<<0)	client	T{
types
.br
size_types
.br
num_types
T}	T{
XkbGetKeyTypes
.br
XkbResizeKeyType
.br
XkbCopyKeyType
.br
XkbCopyKeyTypes
T}
T{
XkbKeySymsMask
T}	(1<<1)	client	T{
syms
.br
size_syms
.br
num_syms
.br
key_sym_map
T}	T{
XkbGetKeySyms
.br
XkbResizeKeySyms
.br
XkbChangeTypesOfKey
T}
T{
XkbModifierMapMask
T}	(1<<2)	client	modmap	T{
XkbGetKeyModifierMap
T}
T{
XkbExplicitComponentsMask
T}	(1<<3)	server	T{
explicit
T}	T{
XkbGetKeyExplicitComponents
T}
T{
XkbKeyActionsMask
T}	(1<<4)	server	T{
key_acts
.br
acts
.br
num_acts
.br
size_acts
T}	T{
XkbGetKeyActions
.br
XkbResizeKeyActions
T}
T{
XkbKeyBehaviorsMask
T}	(1<<5)	server	T{
behaviors
T}	T{
XkbGetKeyBehaviors
T}
T{
XkbVirtualModsMask
T}	(1<<6)	server	T{
vmods
T}	T{
XkbGetVirtualMods
T}
T{
XkbVirtualModMapMask
T}	(1<<7)	server	T{
vmodmap
T}	T{
XkbGetVirtualModMap
T}
.TE

The 
.I changed 
field identifies the map components that have changed in an XkbDescRec structure 
and may contain any of the 
bits in Table 1, which are also shown in Table 2. Every 1 bit in 
.I changed 
also identifies which other fields in the XkbMapChangesRec structure contain 
valid values, as indicated in 
Table 2. The 
.I min_key_code 
and 
.I max_key_code 
fields are for reference only; they are ignored on any requests sent to the 
server and are always updated 
by the server whenever it returns the data for an XkbMapChangesRec.  
.bp
.TS
c s s 
l l l
l l l
l l l
l lw(2i) lw(3i).
Table 2 XkbMapChangesRec Masks
_
	Valid
Mask	XkbMapChangesRec	XkbDescRec Field Containing
	Fields	Changed Data
_
XkbKeyTypesMask	first_type,	map->type[first_type] ..
	num_types	map->type[first_type + num_types - 1]
.sp
XkbKeySymsMask	first_key_sym,	map->key_sym_map[first_key_sym] ..
	num_key_syms	map->key_sym_map[first_key_sym +
		num_key_syms - 1]
XkbModifierMapMask	first_modmap_key,	map->modmap[first_modmap_key] ..
	num_modmap_keys	map->modmap[first_modmap_key +
		num_modmap_keys-1]
XkbExplicitComponentsMask	first_key_explicit,	
server->explicit[first_key_explicit] ..
	num_key_explicit	server->explicit[first_key_explicit +
		num_key_explicit - 1]
XkbKeyActionsMask	first_key_act,	server->key_acts[first_key_act] ..
	num_key_acts	server->key_acts[first_key_act +
		num_key_acts - 1]
XkbKeyBehaviorsMask	first_key_behavior,	
server->behaviors[first_key_behavior] ..
	num_key_behaviors	server->behaviors[first_key_behavior +
		num_key_behaviors - 1]
XkbVirtualModsMask	vmods	server->vmods[*]
XkbVirtualModMapMask	first_vmodmap_key,	
server->vmodmap[first_vmodmap_key]
	num_vmodmap_keys	 ..
		server->vmodmap[first_vmodmap_key
		+ num_vmodmap_keys - 1]
.TE
.SH "RETURN VALUES"
.TP 15
True
The 
.I XkbSetMap 
function returns True all components specified by 
.I which 
are present in the 
.I xkb 
parameter.
.TP 15
False
The 
.I XkbSetMap 
function returns False if any component specified by 
.I which 
is not present in the 
.I xkb 
parameter.
.SH STRUCTURES
Use the XkbMapChangesRec structure to identify and track partial modifications 
to the mapping components 
and to reduce the amount of traffic between the server and clients.
.nf

typedef struct _XkbMapChanges {
    unsigned short   changed;            /\&* identifies valid components in structure */
    KeyCode          min_key_code;       /\&* lowest numbered keycode for device */
    KeyCode          max_key_code;       /\&* highest numbered keycode for device */
    unsigned char    first_type;         /\&* index of first key type modified */
    unsigned char    num_types;          /\&* # types modified */
    KeyCode          first_key_sym;      /\&* first key whose key_sym_map changed */
    unsigned char    num_key_syms;       /\&* # key_sym_map entries changed */
    KeyCode          first_key_act;      /\&* first key whose key_acts entry changed */
    unsigned char    num_key_acts;       /\&* # key_acts entries changed */
    KeyCode          first_key_behavior; /\&* first key whose behaviors changed */
    unsigned char    num_key_behaviors;  /\&* # behaviors entries changed */
    KeyCode          first_key_explicit; /\&* first key whose explicit entry changed */
    unsigned char    num_key_explicit;   /\&* # explicit entries changed */
    KeyCode          first_modmap_key;   /\&* first key whose modmap entry changed */
    unsigned char    num_modmap_keys;    /\&* # modmap entries changed */
    KeyCode          first_vmodmap_key;  /\&* first key whose vmodmap changed */
    unsigned char    num_vmodmap_keys;   /\&* # vmodmap entries changed */
    unsigned char    pad1;               /\&* reserved */
    unsigned short   vmods;              /\&* mask indicating which vmods changed */
} XkbMapChangesRec,*XkbMapChangesPtr;

.fi

The complete description of an Xkb keyboard is given by an XkbDescRec. The 
component 
structures in the XkbDescRec represent the major Xkb components.

.nf
typedef struct {
   struct _XDisplay * display;      /\&* connection to X server */
   unsigned short     flags;        /\&* private to Xkb, do not modify */
   unsigned short     device_spec;  /\&* device of interest */
   KeyCode            min_key_code; /\&* minimum keycode for device */
   KeyCode            max_key_code; /\&* maximum keycode for device */
   XkbControlsPtr     ctrls;        /\&* controls */
   XkbServerMapPtr    server;       /\&* server keymap */
   XkbClientMapPtr    map;          /\&* client keymap */
   XkbIndicatorPtr    indicators;   /\&* indicator map */
   XkbNamesPtr        names;        /\&* names for all components */
   XkbCompatMapPtr    compat;       /\&* compatibility map */
   XkbGeometryPtr     geom;         /\&* physical geometry of keyboard */
} XkbDescRec, *XkbDescPtr;

.fi
The 
.I display 
field points to an X display structure. The 
.I flags field is private to the library: modifying 
.I flags 
may yield unpredictable results. The 
.I device_spec 
field specifies the device identifier of the keyboard input device, or 
XkbUseCoreKeyboard, which specifies the core keyboard device. The 
.I min_key_code
and 
.I max_key_code 
fields specify the least and greatest keycode that can be returned by the 
keyboard. 

Each structure component has a corresponding mask bit that is used in function 
calls to indicate that the structure should be manipulated in some manner, such as 
allocating it or freeing it. These masks and their relationships to the fields in the 
XkbDescRec are shown in Table 3.
.bp
.TS
c s s
l l l
l l l.
Table 3 Mask Bits for XkbDescRec
_
Mask Bit	XkbDescRec Field	Value
_
XkbControlsMask	ctrls	(1L<<0)
XkbServerMapMask	server	(1L<<1)
XkbIClientMapMask	map	(1L<<2)
XkbIndicatorMapMask	indicators	(1L<<3)
XkbNamesMask	names	(1L<<4)
XkbCompatMapMask	compat	(1L<<5)
XkbGeometryMask	geom	(1L<<6)
XkbAllComponentsMask	All Fields	(0x7f)
.TE
.SH DIAGNOSTICS
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadLength
The length of a request is shorter or longer than that required to minimally 
contain the arguments
.TP 15
.B BadValue
An argument is out of range
.SH "SEE ALSO"
.BR XkbChangeMap (__libmansuffix__),
.BR XkbChangeTypesOfKey (__libmansuffix__),
.BR XkbCopyKeyType (__libmansuffix__),
.BR XkbCopyKeyTypes (__libmansuffix__),
.BR XkbGetKeyActions (__libmansuffix__),
.BR XkbGetKeyBehaviors (__libmansuffix__),
.BR XkbGetKeyExplicitComponents (__libmansuffix__),
.BR XkbGetKeyModifierMap (__libmansuffix__),
.BR XkbGetKeySyms (__libmansuffix__),
.BR XkbGetKeyTypes (__libmansuffix__),
.BR XkbResizeKeyActions (__libmansuffix__),
.BR XkbResizeKeySyms (__libmansuffix__),
.BR XkbResizeKeyType (__libmansuffix__),
.BR XkbGetVirtualModMap (__libmansuffix__),
.BR XkbGetVirtualMods (__libmansuffix__)
