/*
 *  Copyright (C) 2005-2021 Team Kodi (https://kodi.tv)
 *
 *  SPDX-License-Identifier: GPL-2.0-or-later
 *  See LICENSE.md for more information.
 */

#pragma once

#include "kodi/AddonBase.h"

#include <memory>
#include <mutex>

namespace tvheadend
{
class AddonSettings;
}

class ATTR_DLL_LOCAL CHTSAddon : public kodi::addon::CAddonBase
{
public:
  CHTSAddon() = default;

  ADDON_STATUS Create() override;
  ADDON_STATUS SetSetting(const std::string& settingName,
                          const kodi::addon::CSettingValue& settingValue) override;
  ADDON_STATUS CreateInstance(const kodi::addon::IInstanceInfo& instance,
                              KODI_ADDON_INSTANCE_HDL& hdl) override;

private:
  std::recursive_mutex m_mutex;
  std::shared_ptr<tvheadend::AddonSettings> m_settings;
};
