# SPDX-License-Identifier: BSD-3-Clause
# Copyright Contributors to the OpenEXR Project.

file(READ configure.ac CONFIGURE_AC_CONTENTS)
string(REGEX MATCH "AC_INIT\\(OpenEXR,[ ]*([0-9]+).([0-9]+).([0-9]+)" DUMMY ${CONFIGURE_AC_CONTENTS})
set(OPENEXR_VERSION_MAJOR ${CMAKE_MATCH_1})
set(OPENEXR_VERSION_MINOR ${CMAKE_MATCH_2})
set(OPENEXR_VERSION_PATCH ${CMAKE_MATCH_3})
set(OPENEXR_VERSION       ${OPENEXR_VERSION_MAJOR}.${OPENEXR_VERSION_MINOR}.${OPENEXR_VERSION_PATCH})
set(OPENEXR_VERSION_API   ${OPENEXR_VERSION_MAJOR}_${OPENEXR_VERSION_MINOR})
string(REGEX MATCH "LIBTOOL_CURRENT=([0-9]+)" DUMMY ${CONFIGURE_AC_CONTENTS})
set(OPENEXR_SOCURRENT ${CMAKE_MATCH_1})
string(REGEX MATCH "LIBTOOL_REVISION=([0-9]+)" DUMMY ${CONFIGURE_AC_CONTENTS})
set(OPENEXR_SOREVISION ${CMAKE_MATCH_1})
string(REGEX MATCH "LIBTOOL_AGE=([0-9]+)" DUMMY ${CONFIGURE_AC_CONTENTS})
set(OPENEXR_SOAGE ${CMAKE_MATCH_1})
math(EXPR OPENEXR_SOVERSION "${OPENEXR_SOCURRENT} - ${OPENEXR_SOAGE}")
set(OPENEXR_LIB_VERSION "${OPENEXR_SOVERSION}.${OPENEXR_SOAGE}.${OPENEXR_SOREVISION}")
message(STATUS "Configure OpenEXR Version: ${OPENEXR_VERSION} Lib API: ${OPENEXR_LIB_VERSION}")
unset(CONFIGURE_AC_CONTENTS)
