#define XERR "icmcomp"
#include "icmcomp.ih"

    // ScriptOpts sets dontCompile at -tdirname if the .bim file is 
    // younger than the script

    // by run.cc

bool IcmComp::doCompile(string const &src, string const &bimFile) const
{
    Stat statBim{bimFile};

    return
        d_skipCompile ?
            false
        :
            d_preCompOpts.forced()  
            or not statBim
            or statBim.size() == 0  // e.g., created empty by
                                    // sourceopts/addimandbim 
            or statBim.lastModification() <= Stat{src}.lastModification();
}
