# [React Bits](https://vasanthk.gitbooks.io/react-bits)

A compilation of React Patterns, techniques, tips and tricks.

**Gitbook format**: https://vasanthk.gitbooks.io/react-bits

> Your contributions are heartily ♡ welcome. (✿◠‿◠)

> **Translations by community:**
> - 中文版 (Chinese): [react-bits-cn](https://github.com/hateonion/react-bits-CN)


- Design Patterns and Techniques
  - [Conditional in JSX](./patterns/18.conditionals-in-jsx.md)
  - [Async Nature Of setState()](./patterns/19.async-nature-of-setState.md)
  - [Dependency Injection](./patterns/20.dependency-injection.md)
  - [Context Wrapper](./patterns/21.context-wrapper.md)
  - [Event Handlers](./patterns/22.event-handlers.md)
  - [Flux Pattern](./patterns/23.flux-pattern.md)
  - [One Way Data Flow](./patterns/24.one-way-data-flow.md)
  - [Presentational vs Container](./patterns/25.presentational-vs-container.md)
  - [Third Party Integration](./patterns/26.third-party-integration.md)
  - [Passing Function To setState()](./patterns/27.passing-function-to-setState.md)
  - [Decorators](./patterns/28.decorators.md)
  - [Feature Flags](./patterns/29.feature-flags-using-redux.md)
  - [Component Switch](./patterns/30.component-switch.md)
  - [Reaching Into A Component](./patterns/31.reaching-into-a-component.md)
  - [List Components](./patterns/32.list-components.md)
  - [Format Text via Component](./patterns/33.format-text-via-component.md)
  - [Share Tracking Logic](./patterns/34.share-tracking-logic.md)
- Anti-Patterns
  - [Introduction](./anti-patterns/README.md)
  - [Props In Initial State](./anti-patterns/01.props-in-initial-state.md)
  - [findDOMNode()](./anti-patterns/02.findDOMNode.md)
  - [Mixins](./anti-patterns/03.mixins.md)
  - [setState() in componentWillMount()](./anti-patterns/04.setState-in-componentWillMount.md)
  - [Mutating State](./anti-patterns/05.mutating-state.md)
  - [Using Indexes as Key](./anti-patterns/06.using-indexes-as-key.md)
  - [Spreading Props on DOM elements](./anti-patterns/07.spreading-props-dom.md)
- Handling UX Variations
  - [Introduction](./ux-variations/README.md)
  - [Composing UX Variations](./ux-variations/01.composing-variations.md)
  - [Toggle UI Elements](./ux-variations/02.toggle-ui-elements.md)
  - [HOC for Feature Toggles](./ux-variations/03.HOC-feature-toggles.md)
  - [HOC props proxy](./ux-variations/04.HOC-props-proxy.md)
  - [Wrapper Components](./ux-variations/05.wrapper-components.md)
  - [Display Order Variations](./ux-variations/06.display-order-variations.md)
- Perf Tips
  - [Introduction](./perf-tips/README.md)
  - [shouldComponentUpdate() check](./perf-tips/01.shouldComponentUpdate-check.md)
  - [Using Pure Components](./perf-tips/02.pure-component.md)
  - [Using reselect](./perf-tips/03.reselect.md)
- Styling
  - [Introduction](./styling/README.md)
  - [Stateless UI Components](./styling/01.stateless-ui-components.md)
  - [Styles Module](./styling/02.styles-module.md)
  - [Style Functions](./styling/03.style-functions.md)
  - [NPM Modules](./styling/04.using-npm-modules.md)
  - [Base Component](./styling/05.base-component.md)
  - [Layout Component](./styling/06.layout-component.md)
  - [Typography Component](./styling/07.typography-component.md)
  - [HOC for Styling](./styling/08.HOC-for-styling.md)
- Gotchas
  - [Introduction](./gotchas/README.md)
  - [Pure render checks](./gotchas/01.pure-render-checks.md)
  - [Synthetic Events](./gotchas/02.synthetic-events.md)
- [Related Links](./READINGS.md)
