// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package path

import "strings"

func NewPathString() PathString {
	return &pathString{
		elements: make([]string, 0, 10),
	}
}

type pathString struct {
	elements []string
}

func (o pathString) Empty() bool {
	return len(o.elements) == 0
}

func (o pathString) Join() string {
	return strings.Join(o.elements, "/")
}

func (o *pathString) Append(element string) {
	o.elements = append(o.elements, element)
}

func (o pathString) Elements() []string {
	return o.elements
}
