// Code generated by smithy-go-codegen DO NOT EDIT.

package elasticache

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/elasticache/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns details of the service updates
func (c *Client) DescribeServiceUpdates(ctx context.Context, params *DescribeServiceUpdatesInput, optFns ...func(*Options)) (*DescribeServiceUpdatesOutput, error) {
	if params == nil {
		params = &DescribeServiceUpdatesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeServiceUpdates", params, optFns, c.addOperationDescribeServiceUpdatesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeServiceUpdatesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeServiceUpdatesInput struct {

	// An optional marker returned from a prior request. Use this marker for
	// pagination of results from this operation. If this parameter is specified, the
	// response includes only records beyond the marker, up to the value specified by
	// MaxRecords .
	Marker *string

	// The maximum number of records to include in the response
	MaxRecords *int32

	// The unique ID of the service update
	ServiceUpdateName *string

	// The status of the service update
	ServiceUpdateStatus []types.ServiceUpdateStatus

	noSmithyDocumentSerde
}

type DescribeServiceUpdatesOutput struct {

	// An optional marker returned from a prior request. Use this marker for
	// pagination of results from this operation. If this parameter is specified, the
	// response includes only records beyond the marker, up to the value specified by
	// MaxRecords .
	Marker *string

	// A list of service updates
	ServiceUpdates []types.ServiceUpdate

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeServiceUpdatesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDescribeServiceUpdates{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDescribeServiceUpdates{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeServiceUpdates"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeServiceUpdates(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeServiceUpdatesAPIClient is a client that implements the
// DescribeServiceUpdates operation.
type DescribeServiceUpdatesAPIClient interface {
	DescribeServiceUpdates(context.Context, *DescribeServiceUpdatesInput, ...func(*Options)) (*DescribeServiceUpdatesOutput, error)
}

var _ DescribeServiceUpdatesAPIClient = (*Client)(nil)

// DescribeServiceUpdatesPaginatorOptions is the paginator options for
// DescribeServiceUpdates
type DescribeServiceUpdatesPaginatorOptions struct {
	// The maximum number of records to include in the response
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeServiceUpdatesPaginator is a paginator for DescribeServiceUpdates
type DescribeServiceUpdatesPaginator struct {
	options   DescribeServiceUpdatesPaginatorOptions
	client    DescribeServiceUpdatesAPIClient
	params    *DescribeServiceUpdatesInput
	nextToken *string
	firstPage bool
}

// NewDescribeServiceUpdatesPaginator returns a new DescribeServiceUpdatesPaginator
func NewDescribeServiceUpdatesPaginator(client DescribeServiceUpdatesAPIClient, params *DescribeServiceUpdatesInput, optFns ...func(*DescribeServiceUpdatesPaginatorOptions)) *DescribeServiceUpdatesPaginator {
	if params == nil {
		params = &DescribeServiceUpdatesInput{}
	}

	options := DescribeServiceUpdatesPaginatorOptions{}
	if params.MaxRecords != nil {
		options.Limit = *params.MaxRecords
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeServiceUpdatesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeServiceUpdatesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeServiceUpdates page.
func (p *DescribeServiceUpdatesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeServiceUpdatesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxRecords = limit

	result, err := p.client.DescribeServiceUpdates(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.Marker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeServiceUpdates(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeServiceUpdates",
	}
}
