//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpolicyinsights

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
	"time"
)

// PolicyEventsClient contains the methods for the PolicyEvents group.
// Don't use this type directly, use NewPolicyEventsClient() instead.
type PolicyEventsClient struct {
	host string
	pl   runtime.Pipeline
}

// NewPolicyEventsClient creates a new instance of PolicyEventsClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewPolicyEventsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*PolicyEventsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &PolicyEventsClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// NewListQueryResultsForManagementGroupPager - Queries policy events for the resources under the management group.
// Generated from API version 2019-10-01
// policyEventsResource - The name of the virtual resource under PolicyEvents resource type; only "default" is allowed.
// managementGroupName - Management group name.
// QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
// method.
// options - PolicyEventsClientListQueryResultsForManagementGroupOptions contains the optional parameters for the PolicyEventsClient.ListQueryResultsForManagementGroup
// method.
func (client *PolicyEventsClient) NewListQueryResultsForManagementGroupPager(policyEventsResource PolicyEventsResourceType, managementGroupName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForManagementGroupOptions) *runtime.Pager[PolicyEventsClientListQueryResultsForManagementGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyEventsClientListQueryResultsForManagementGroupResponse]{
		More: func(page PolicyEventsClientListQueryResultsForManagementGroupResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyEventsClientListQueryResultsForManagementGroupResponse) (PolicyEventsClientListQueryResultsForManagementGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listQueryResultsForManagementGroupCreateRequest(ctx, policyEventsResource, managementGroupName, queryOptions, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.ODataNextLink)
			}
			if err != nil {
				return PolicyEventsClientListQueryResultsForManagementGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return PolicyEventsClientListQueryResultsForManagementGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return PolicyEventsClientListQueryResultsForManagementGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listQueryResultsForManagementGroupHandleResponse(resp)
		},
	})
}

// listQueryResultsForManagementGroupCreateRequest creates the ListQueryResultsForManagementGroup request.
func (client *PolicyEventsClient) listQueryResultsForManagementGroupCreateRequest(ctx context.Context, policyEventsResource PolicyEventsResourceType, managementGroupName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults"
	if policyEventsResource == "" {
		return nil, errors.New("parameter policyEventsResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyEventsResource}", url.PathEscape(string(policyEventsResource)))
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupsNamespace}", url.PathEscape("Microsoft.Management"))
	if managementGroupName == "" {
		return nil, errors.New("parameter managementGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupName}", url.PathEscape(managementGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForManagementGroupHandleResponse handles the ListQueryResultsForManagementGroup response.
func (client *PolicyEventsClient) listQueryResultsForManagementGroupHandleResponse(resp *http.Response) (PolicyEventsClientListQueryResultsForManagementGroupResponse, error) {
	result := PolicyEventsClientListQueryResultsForManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyEventsQueryResults); err != nil {
		return PolicyEventsClientListQueryResultsForManagementGroupResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForPolicyDefinitionPager - Queries policy events for the subscription level policy definition.
// Generated from API version 2019-10-01
// policyEventsResource - The name of the virtual resource under PolicyEvents resource type; only "default" is allowed.
// subscriptionID - Microsoft Azure subscription ID.
// policyDefinitionName - Policy definition name.
// QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
// method.
// options - PolicyEventsClientListQueryResultsForPolicyDefinitionOptions contains the optional parameters for the PolicyEventsClient.ListQueryResultsForPolicyDefinition
// method.
func (client *PolicyEventsClient) NewListQueryResultsForPolicyDefinitionPager(policyEventsResource PolicyEventsResourceType, subscriptionID string, policyDefinitionName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForPolicyDefinitionOptions) *runtime.Pager[PolicyEventsClientListQueryResultsForPolicyDefinitionResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyEventsClientListQueryResultsForPolicyDefinitionResponse]{
		More: func(page PolicyEventsClientListQueryResultsForPolicyDefinitionResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyEventsClientListQueryResultsForPolicyDefinitionResponse) (PolicyEventsClientListQueryResultsForPolicyDefinitionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listQueryResultsForPolicyDefinitionCreateRequest(ctx, policyEventsResource, subscriptionID, policyDefinitionName, queryOptions, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.ODataNextLink)
			}
			if err != nil {
				return PolicyEventsClientListQueryResultsForPolicyDefinitionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return PolicyEventsClientListQueryResultsForPolicyDefinitionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return PolicyEventsClientListQueryResultsForPolicyDefinitionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listQueryResultsForPolicyDefinitionHandleResponse(resp)
		},
	})
}

// listQueryResultsForPolicyDefinitionCreateRequest creates the ListQueryResultsForPolicyDefinition request.
func (client *PolicyEventsClient) listQueryResultsForPolicyDefinitionCreateRequest(ctx context.Context, policyEventsResource PolicyEventsResourceType, subscriptionID string, policyDefinitionName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForPolicyDefinitionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults"
	if policyEventsResource == "" {
		return nil, errors.New("parameter policyEventsResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyEventsResource}", url.PathEscape(string(policyEventsResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	urlPath = strings.ReplaceAll(urlPath, "{authorizationNamespace}", url.PathEscape("Microsoft.Authorization"))
	if policyDefinitionName == "" {
		return nil, errors.New("parameter policyDefinitionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyDefinitionName}", url.PathEscape(policyDefinitionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForPolicyDefinitionHandleResponse handles the ListQueryResultsForPolicyDefinition response.
func (client *PolicyEventsClient) listQueryResultsForPolicyDefinitionHandleResponse(resp *http.Response) (PolicyEventsClientListQueryResultsForPolicyDefinitionResponse, error) {
	result := PolicyEventsClientListQueryResultsForPolicyDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyEventsQueryResults); err != nil {
		return PolicyEventsClientListQueryResultsForPolicyDefinitionResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForPolicySetDefinitionPager - Queries policy events for the subscription level policy set definition.
// Generated from API version 2019-10-01
// policyEventsResource - The name of the virtual resource under PolicyEvents resource type; only "default" is allowed.
// subscriptionID - Microsoft Azure subscription ID.
// policySetDefinitionName - Policy set definition name.
// QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
// method.
// options - PolicyEventsClientListQueryResultsForPolicySetDefinitionOptions contains the optional parameters for the PolicyEventsClient.ListQueryResultsForPolicySetDefinition
// method.
func (client *PolicyEventsClient) NewListQueryResultsForPolicySetDefinitionPager(policyEventsResource PolicyEventsResourceType, subscriptionID string, policySetDefinitionName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForPolicySetDefinitionOptions) *runtime.Pager[PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse]{
		More: func(page PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse) (PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listQueryResultsForPolicySetDefinitionCreateRequest(ctx, policyEventsResource, subscriptionID, policySetDefinitionName, queryOptions, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.ODataNextLink)
			}
			if err != nil {
				return PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listQueryResultsForPolicySetDefinitionHandleResponse(resp)
		},
	})
}

// listQueryResultsForPolicySetDefinitionCreateRequest creates the ListQueryResultsForPolicySetDefinition request.
func (client *PolicyEventsClient) listQueryResultsForPolicySetDefinitionCreateRequest(ctx context.Context, policyEventsResource PolicyEventsResourceType, subscriptionID string, policySetDefinitionName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForPolicySetDefinitionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults"
	if policyEventsResource == "" {
		return nil, errors.New("parameter policyEventsResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyEventsResource}", url.PathEscape(string(policyEventsResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	urlPath = strings.ReplaceAll(urlPath, "{authorizationNamespace}", url.PathEscape("Microsoft.Authorization"))
	if policySetDefinitionName == "" {
		return nil, errors.New("parameter policySetDefinitionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policySetDefinitionName}", url.PathEscape(policySetDefinitionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForPolicySetDefinitionHandleResponse handles the ListQueryResultsForPolicySetDefinition response.
func (client *PolicyEventsClient) listQueryResultsForPolicySetDefinitionHandleResponse(resp *http.Response) (PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse, error) {
	result := PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyEventsQueryResults); err != nil {
		return PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForResourcePager - Queries policy events for the resource.
// Generated from API version 2019-10-01
// policyEventsResource - The name of the virtual resource under PolicyEvents resource type; only "default" is allowed.
// resourceID - Resource ID.
// QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
// method.
// options - PolicyEventsClientListQueryResultsForResourceOptions contains the optional parameters for the PolicyEventsClient.ListQueryResultsForResource
// method.
func (client *PolicyEventsClient) NewListQueryResultsForResourcePager(policyEventsResource PolicyEventsResourceType, resourceID string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForResourceOptions) *runtime.Pager[PolicyEventsClientListQueryResultsForResourceResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyEventsClientListQueryResultsForResourceResponse]{
		More: func(page PolicyEventsClientListQueryResultsForResourceResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyEventsClientListQueryResultsForResourceResponse) (PolicyEventsClientListQueryResultsForResourceResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listQueryResultsForResourceCreateRequest(ctx, policyEventsResource, resourceID, queryOptions, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.ODataNextLink)
			}
			if err != nil {
				return PolicyEventsClientListQueryResultsForResourceResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return PolicyEventsClientListQueryResultsForResourceResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return PolicyEventsClientListQueryResultsForResourceResponse{}, runtime.NewResponseError(resp)
			}
			return client.listQueryResultsForResourceHandleResponse(resp)
		},
	})
}

// listQueryResultsForResourceCreateRequest creates the ListQueryResultsForResource request.
func (client *PolicyEventsClient) listQueryResultsForResourceCreateRequest(ctx context.Context, policyEventsResource PolicyEventsResourceType, resourceID string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForResourceOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults"
	if policyEventsResource == "" {
		return nil, errors.New("parameter policyEventsResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyEventsResource}", url.PathEscape(string(policyEventsResource)))
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.Expand != nil {
		reqQP.Set("$expand", *queryOptions.Expand)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForResourceHandleResponse handles the ListQueryResultsForResource response.
func (client *PolicyEventsClient) listQueryResultsForResourceHandleResponse(resp *http.Response) (PolicyEventsClientListQueryResultsForResourceResponse, error) {
	result := PolicyEventsClientListQueryResultsForResourceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyEventsQueryResults); err != nil {
		return PolicyEventsClientListQueryResultsForResourceResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForResourceGroupPager - Queries policy events for the resources under the resource group.
// Generated from API version 2019-10-01
// policyEventsResource - The name of the virtual resource under PolicyEvents resource type; only "default" is allowed.
// subscriptionID - Microsoft Azure subscription ID.
// resourceGroupName - Resource group name.
// QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
// method.
// options - PolicyEventsClientListQueryResultsForResourceGroupOptions contains the optional parameters for the PolicyEventsClient.ListQueryResultsForResourceGroup
// method.
func (client *PolicyEventsClient) NewListQueryResultsForResourceGroupPager(policyEventsResource PolicyEventsResourceType, subscriptionID string, resourceGroupName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForResourceGroupOptions) *runtime.Pager[PolicyEventsClientListQueryResultsForResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyEventsClientListQueryResultsForResourceGroupResponse]{
		More: func(page PolicyEventsClientListQueryResultsForResourceGroupResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyEventsClientListQueryResultsForResourceGroupResponse) (PolicyEventsClientListQueryResultsForResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listQueryResultsForResourceGroupCreateRequest(ctx, policyEventsResource, subscriptionID, resourceGroupName, queryOptions, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.ODataNextLink)
			}
			if err != nil {
				return PolicyEventsClientListQueryResultsForResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return PolicyEventsClientListQueryResultsForResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return PolicyEventsClientListQueryResultsForResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listQueryResultsForResourceGroupHandleResponse(resp)
		},
	})
}

// listQueryResultsForResourceGroupCreateRequest creates the ListQueryResultsForResourceGroup request.
func (client *PolicyEventsClient) listQueryResultsForResourceGroupCreateRequest(ctx context.Context, policyEventsResource PolicyEventsResourceType, subscriptionID string, resourceGroupName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults"
	if policyEventsResource == "" {
		return nil, errors.New("parameter policyEventsResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyEventsResource}", url.PathEscape(string(policyEventsResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForResourceGroupHandleResponse handles the ListQueryResultsForResourceGroup response.
func (client *PolicyEventsClient) listQueryResultsForResourceGroupHandleResponse(resp *http.Response) (PolicyEventsClientListQueryResultsForResourceGroupResponse, error) {
	result := PolicyEventsClientListQueryResultsForResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyEventsQueryResults); err != nil {
		return PolicyEventsClientListQueryResultsForResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager - Queries policy events for the resource group level policy
// assignment.
// Generated from API version 2019-10-01
// policyEventsResource - The name of the virtual resource under PolicyEvents resource type; only "default" is allowed.
// subscriptionID - Microsoft Azure subscription ID.
// resourceGroupName - Resource group name.
// policyAssignmentName - Policy assignment name.
// QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
// method.
// options - PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentOptions contains the optional parameters
// for the PolicyEventsClient.ListQueryResultsForResourceGroupLevelPolicyAssignment method.
func (client *PolicyEventsClient) NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager(policyEventsResource PolicyEventsResourceType, subscriptionID string, resourceGroupName string, policyAssignmentName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentOptions) *runtime.Pager[PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse]{
		More: func(page PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse) (PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listQueryResultsForResourceGroupLevelPolicyAssignmentCreateRequest(ctx, policyEventsResource, subscriptionID, resourceGroupName, policyAssignmentName, queryOptions, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.ODataNextLink)
			}
			if err != nil {
				return PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse{}, runtime.NewResponseError(resp)
			}
			return client.listQueryResultsForResourceGroupLevelPolicyAssignmentHandleResponse(resp)
		},
	})
}

// listQueryResultsForResourceGroupLevelPolicyAssignmentCreateRequest creates the ListQueryResultsForResourceGroupLevelPolicyAssignment request.
func (client *PolicyEventsClient) listQueryResultsForResourceGroupLevelPolicyAssignmentCreateRequest(ctx context.Context, policyEventsResource PolicyEventsResourceType, subscriptionID string, resourceGroupName string, policyAssignmentName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults"
	if policyEventsResource == "" {
		return nil, errors.New("parameter policyEventsResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyEventsResource}", url.PathEscape(string(policyEventsResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	urlPath = strings.ReplaceAll(urlPath, "{authorizationNamespace}", url.PathEscape("Microsoft.Authorization"))
	if policyAssignmentName == "" {
		return nil, errors.New("parameter policyAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyAssignmentName}", url.PathEscape(policyAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForResourceGroupLevelPolicyAssignmentHandleResponse handles the ListQueryResultsForResourceGroupLevelPolicyAssignment response.
func (client *PolicyEventsClient) listQueryResultsForResourceGroupLevelPolicyAssignmentHandleResponse(resp *http.Response) (PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse, error) {
	result := PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyEventsQueryResults); err != nil {
		return PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForSubscriptionPager - Queries policy events for the resources under the subscription.
// Generated from API version 2019-10-01
// policyEventsResource - The name of the virtual resource under PolicyEvents resource type; only "default" is allowed.
// subscriptionID - Microsoft Azure subscription ID.
// QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
// method.
// options - PolicyEventsClientListQueryResultsForSubscriptionOptions contains the optional parameters for the PolicyEventsClient.ListQueryResultsForSubscription
// method.
func (client *PolicyEventsClient) NewListQueryResultsForSubscriptionPager(policyEventsResource PolicyEventsResourceType, subscriptionID string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForSubscriptionOptions) *runtime.Pager[PolicyEventsClientListQueryResultsForSubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyEventsClientListQueryResultsForSubscriptionResponse]{
		More: func(page PolicyEventsClientListQueryResultsForSubscriptionResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyEventsClientListQueryResultsForSubscriptionResponse) (PolicyEventsClientListQueryResultsForSubscriptionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listQueryResultsForSubscriptionCreateRequest(ctx, policyEventsResource, subscriptionID, queryOptions, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.ODataNextLink)
			}
			if err != nil {
				return PolicyEventsClientListQueryResultsForSubscriptionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return PolicyEventsClientListQueryResultsForSubscriptionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return PolicyEventsClientListQueryResultsForSubscriptionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listQueryResultsForSubscriptionHandleResponse(resp)
		},
	})
}

// listQueryResultsForSubscriptionCreateRequest creates the ListQueryResultsForSubscription request.
func (client *PolicyEventsClient) listQueryResultsForSubscriptionCreateRequest(ctx context.Context, policyEventsResource PolicyEventsResourceType, subscriptionID string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults"
	if policyEventsResource == "" {
		return nil, errors.New("parameter policyEventsResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyEventsResource}", url.PathEscape(string(policyEventsResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForSubscriptionHandleResponse handles the ListQueryResultsForSubscription response.
func (client *PolicyEventsClient) listQueryResultsForSubscriptionHandleResponse(resp *http.Response) (PolicyEventsClientListQueryResultsForSubscriptionResponse, error) {
	result := PolicyEventsClientListQueryResultsForSubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyEventsQueryResults); err != nil {
		return PolicyEventsClientListQueryResultsForSubscriptionResponse{}, err
	}
	return result, nil
}

// NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager - Queries policy events for the subscription level policy
// assignment.
// Generated from API version 2019-10-01
// policyEventsResource - The name of the virtual resource under PolicyEvents resource type; only "default" is allowed.
// subscriptionID - Microsoft Azure subscription ID.
// policyAssignmentName - Policy assignment name.
// QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
// method.
// options - PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentOptions contains the optional parameters
// for the PolicyEventsClient.ListQueryResultsForSubscriptionLevelPolicyAssignment method.
func (client *PolicyEventsClient) NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager(policyEventsResource PolicyEventsResourceType, subscriptionID string, policyAssignmentName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentOptions) *runtime.Pager[PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse] {
	return runtime.NewPager(runtime.PagingHandler[PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse]{
		More: func(page PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse) bool {
			return page.ODataNextLink != nil && len(*page.ODataNextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse) (PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listQueryResultsForSubscriptionLevelPolicyAssignmentCreateRequest(ctx, policyEventsResource, subscriptionID, policyAssignmentName, queryOptions, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.ODataNextLink)
			}
			if err != nil {
				return PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse{}, runtime.NewResponseError(resp)
			}
			return client.listQueryResultsForSubscriptionLevelPolicyAssignmentHandleResponse(resp)
		},
	})
}

// listQueryResultsForSubscriptionLevelPolicyAssignmentCreateRequest creates the ListQueryResultsForSubscriptionLevelPolicyAssignment request.
func (client *PolicyEventsClient) listQueryResultsForSubscriptionLevelPolicyAssignmentCreateRequest(ctx context.Context, policyEventsResource PolicyEventsResourceType, subscriptionID string, policyAssignmentName string, queryOptions *QueryOptions, options *PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults"
	if policyEventsResource == "" {
		return nil, errors.New("parameter policyEventsResource cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyEventsResource}", url.PathEscape(string(policyEventsResource)))
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	urlPath = strings.ReplaceAll(urlPath, "{authorizationNamespace}", url.PathEscape("Microsoft.Authorization"))
	if policyAssignmentName == "" {
		return nil, errors.New("parameter policyAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{policyAssignmentName}", url.PathEscape(policyAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-10-01")
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.OrderBy != nil {
		reqQP.Set("$orderby", *queryOptions.OrderBy)
	}
	if queryOptions != nil && queryOptions.Select != nil {
		reqQP.Set("$select", *queryOptions.Select)
	}
	if queryOptions != nil && queryOptions.From != nil {
		reqQP.Set("$from", queryOptions.From.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.To != nil {
		reqQP.Set("$to", queryOptions.To.Format(time.RFC3339Nano))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	if queryOptions != nil && queryOptions.Apply != nil {
		reqQP.Set("$apply", *queryOptions.Apply)
	}
	if queryOptions != nil && queryOptions.SkipToken != nil {
		reqQP.Set("$skiptoken", *queryOptions.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listQueryResultsForSubscriptionLevelPolicyAssignmentHandleResponse handles the ListQueryResultsForSubscriptionLevelPolicyAssignment response.
func (client *PolicyEventsClient) listQueryResultsForSubscriptionLevelPolicyAssignmentHandleResponse(resp *http.Response) (PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse, error) {
	result := PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PolicyEventsQueryResults); err != nil {
		return PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse{}, err
	}
	return result, nil
}
