/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-10-07 20:09
 */
 
#include "BitSet.h"

CBitSet::CBitSet()
{
}

CBitSet::~CBitSet()
{
}

void CBitSet::alloc(unsigned int size)
{
	_size = size;
	
	if(size%8 == 0)
	{
		_data.resize(size/8);
	}
	else
	{
		_data.resize(size/8 + 1);
	}

	for(size_t i = 0; i<_data.size(); ++i)
	{
		_data[i] = 0;
	}
}

void CBitSet::alloc(std::string& stream, unsigned int size)
{
	_size = size;
	_data = stream;
}

bool CBitSet::isSet(unsigned int index)
{
	char b = _data[index/8];
	int bit = index % 8;
	
	unsigned char mask = 128;
	mask = mask >> bit;
	
	if((b & mask) != 0)
	{
		return true;
	}
	
	return false;
}

void CBitSet::set(unsigned int index, bool set)
{
	char b = _data[index/8];
	int bit = index % 8;
	
	unsigned char mask = 128;
	mask = mask >> bit;
	
	if(set)
	{
		b = b |  mask;
	}
	else
	{
		mask = ~mask;
		b = b & mask;
	}
	
	_data[index/8] = b;
}

std::string& CBitSet::getStream()
{
	return _data;
}

bool CBitSet::isAllSet()
{
	for(size_t i = 0; i<_data.size()-1; ++i)
	{
		if((unsigned char)(_data[i]) != 255)
		{
			return false;
		}
	}
	
	unsigned char b = (unsigned char)_data[_data.size()-1];
	
	for(unsigned int i=0; i<_size-(_data.size()-1)*8; ++i)
	{
		unsigned char mask = 128;
		mask = mask >> i;
		if((b & mask) == 0)
		{
			return false;
		}
	}
	
	return true;
}

bool CBitSet::isEmpty()
{
	for(size_t i = 0; i<_data.size(); ++i)
	{
		if(_data[i] != 0)
		{
			return false;
		}
	}	
	
	return true;
}

unsigned int CBitSet::getSize()
{
	return _size;
}

unsigned int CBitSet::getSetedCount()
{
	unsigned int result = 0;
	for(unsigned int i=0; i< _size; ++i)
	{
		if(isSet(i))
		{
			result++;
		}
	}
	
	return result;
}
