/* SPDX-License-Identifier: GPL-2.0+ OR BSD-3-Clause */
/*
 * Copyright (C) 2017-2022, STMicroelectronics - All Rights Reserved
 */

#ifndef _DT_BINDINGS_CLOCK_STM32MP15_CLKSRC_H_
#define _DT_BINDINGS_CLOCK_STM32MP15_CLKSRC_H_

/* PLL output is enable when x=1, with x=p,q or r */
#define PQR(p, q, r)	(((p) & 1) | (((q) & 1) << 1) | (((r) & 1) << 2))

/* st,clksrc: mandatory clock source */
#define CLK_MPU_HSI		0x00000200
#define CLK_MPU_HSE		0x00000201
#define CLK_MPU_PLL1P		0x00000202
#define CLK_MPU_PLL1P_DIV	0x00000203

#define CLK_AXI_HSI		0x00000240
#define CLK_AXI_HSE		0x00000241
#define CLK_AXI_PLL2P		0x00000242

#define CLK_MCU_HSI		0x00000480
#define CLK_MCU_HSE		0x00000481
#define CLK_MCU_CSI		0x00000482
#define CLK_MCU_PLL3P		0x00000483

#define CLK_PLL12_HSI		0x00000280
#define CLK_PLL12_HSE		0x00000281

#define CLK_PLL3_HSI		0x00008200
#define CLK_PLL3_HSE		0x00008201
#define CLK_PLL3_CSI		0x00008202

#define CLK_PLL4_HSI		0x00008240
#define CLK_PLL4_HSE		0x00008241
#define CLK_PLL4_CSI		0x00008242
#define CLK_PLL4_I2SCKIN	0x00008243

#define CLK_RTC_DISABLED	0x00001400
#define CLK_RTC_LSE		0x00001401
#define CLK_RTC_LSI		0x00001402
#define CLK_RTC_HSE		0x00001403

#define CLK_MCO1_HSI		0x00008000
#define CLK_MCO1_HSE		0x00008001
#define CLK_MCO1_CSI		0x00008002
#define CLK_MCO1_LSI		0x00008003
#define CLK_MCO1_LSE		0x00008004
#define CLK_MCO1_DISABLED	0x0000800F

#define CLK_MCO2_MPU		0x00008040
#define CLK_MCO2_AXI		0x00008041
#define CLK_MCO2_MCU		0x00008042
#define CLK_MCO2_PLL4P		0x00008043
#define CLK_MCO2_HSE		0x00008044
#define CLK_MCO2_HSI		0x00008045
#define CLK_MCO2_DISABLED	0x0000804F

/* st,pkcs: peripheral kernel clock source */

#define CLK_I2C12_PCLK1		0x00008C00
#define CLK_I2C12_PLL4R		0x00008C01
#define CLK_I2C12_HSI		0x00008C02
#define CLK_I2C12_CSI		0x00008C03
#define CLK_I2C12_DISABLED	0x00008C07

#define CLK_I2C35_PCLK1		0x00008C40
#define CLK_I2C35_PLL4R		0x00008C41
#define CLK_I2C35_HSI		0x00008C42
#define CLK_I2C35_CSI		0x00008C43
#define CLK_I2C35_DISABLED	0x00008C47

#define CLK_I2C46_PCLK5		0x00000C00
#define CLK_I2C46_PLL3Q		0x00000C01
#define CLK_I2C46_HSI		0x00000C02
#define CLK_I2C46_CSI		0x00000C03
#define CLK_I2C46_DISABLED	0x00000C07

#define CLK_SAI1_PLL4Q		0x00008C80
#define CLK_SAI1_PLL3Q		0x00008C81
#define CLK_SAI1_I2SCKIN	0x00008C82
#define CLK_SAI1_CKPER		0x00008C83
#define CLK_SAI1_PLL3R		0x00008C84
#define CLK_SAI1_DISABLED	0x00008C87

#define CLK_SAI2_PLL4Q		0x00008CC0
#define CLK_SAI2_PLL3Q		0x00008CC1
#define CLK_SAI2_I2SCKIN	0x00008CC2
#define CLK_SAI2_CKPER		0x00008CC3
#define CLK_SAI2_SPDIF		0x00008CC4
#define CLK_SAI2_PLL3R		0x00008CC5
#define CLK_SAI2_DISABLED	0x00008CC7

#define CLK_SAI3_PLL4Q		0x00008D00
#define CLK_SAI3_PLL3Q		0x00008D01
#define CLK_SAI3_I2SCKIN	0x00008D02
#define CLK_SAI3_CKPER		0x00008D03
#define CLK_SAI3_PLL3R		0x00008D04
#define CLK_SAI3_DISABLED	0x00008D07

#define CLK_SAI4_PLL4Q		0x00008D40
#define CLK_SAI4_PLL3Q		0x00008D41
#define CLK_SAI4_I2SCKIN	0x00008D42
#define CLK_SAI4_CKPER		0x00008D43
#define CLK_SAI4_PLL3R		0x00008D44
#define CLK_SAI4_DISABLED	0x00008D47

#define CLK_SPI2S1_PLL4P	0x00008D80
#define CLK_SPI2S1_PLL3Q	0x00008D81
#define CLK_SPI2S1_I2SCKIN	0x00008D82
#define CLK_SPI2S1_CKPER	0x00008D83
#define CLK_SPI2S1_PLL3R	0x00008D84
#define CLK_SPI2S1_DISABLED	0x00008D87

#define CLK_SPI2S23_PLL4P	0x00008DC0
#define CLK_SPI2S23_PLL3Q	0x00008DC1
#define CLK_SPI2S23_I2SCKIN	0x00008DC2
#define CLK_SPI2S23_CKPER	0x00008DC3
#define CLK_SPI2S23_PLL3R	0x00008DC4
#define CLK_SPI2S23_DISABLED	0x00008DC7

#define CLK_SPI45_PCLK2		0x00008E00
#define CLK_SPI45_PLL4Q		0x00008E01
#define CLK_SPI45_HSI		0x00008E02
#define CLK_SPI45_CSI		0x00008E03
#define CLK_SPI45_HSE		0x00008E04
#define CLK_SPI45_DISABLED	0x00008E07

#define CLK_SPI6_PCLK5		0x00000C40
#define CLK_SPI6_PLL4Q		0x00000C41
#define CLK_SPI6_HSI		0x00000C42
#define CLK_SPI6_CSI		0x00000C43
#define CLK_SPI6_HSE		0x00000C44
#define CLK_SPI6_PLL3Q		0x00000C45
#define CLK_SPI6_DISABLED	0x00000C47

#define CLK_UART6_PCLK2		0x00008E40
#define CLK_UART6_PLL4Q		0x00008E41
#define CLK_UART6_HSI		0x00008E42
#define CLK_UART6_CSI		0x00008E43
#define CLK_UART6_HSE		0x00008E44
#define CLK_UART6_DISABLED	0x00008E47

#define CLK_UART24_PCLK1	0x00008E80
#define CLK_UART24_PLL4Q	0x00008E81
#define CLK_UART24_HSI		0x00008E82
#define CLK_UART24_CSI		0x00008E83
#define CLK_UART24_HSE		0x00008E84
#define CLK_UART24_DISABLED	0x00008E87

#define CLK_UART35_PCLK1	0x00008EC0
#define CLK_UART35_PLL4Q	0x00008EC1
#define CLK_UART35_HSI		0x00008EC2
#define CLK_UART35_CSI		0x00008EC3
#define CLK_UART35_HSE		0x00008EC4
#define CLK_UART35_DISABLED	0x00008EC7

#define CLK_UART78_PCLK1	0x00008F00
#define CLK_UART78_PLL4Q	0x00008F01
#define CLK_UART78_HSI		0x00008F02
#define CLK_UART78_CSI		0x00008F03
#define CLK_UART78_HSE		0x00008F04
#define CLK_UART78_DISABLED	0x00008F07

#define CLK_UART1_PCLK5		0x00000C80
#define CLK_UART1_PLL3Q		0x00000C81
#define CLK_UART1_HSI		0x00000C82
#define CLK_UART1_CSI		0x00000C83
#define CLK_UART1_PLL4Q		0x00000C84
#define CLK_UART1_HSE		0x00000C85
#define CLK_UART1_DISABLED	0x00000C87

#define CLK_SDMMC12_HCLK6	0x00008F40
#define CLK_SDMMC12_PLL3R	0x00008F41
#define CLK_SDMMC12_PLL4P	0x00008F42
#define CLK_SDMMC12_HSI		0x00008F43
#define CLK_SDMMC12_DISABLED	0x00008F47

#define CLK_SDMMC3_HCLK2	0x00008F80
#define CLK_SDMMC3_PLL3R	0x00008F81
#define CLK_SDMMC3_PLL4P	0x00008F82
#define CLK_SDMMC3_HSI		0x00008F83
#define CLK_SDMMC3_DISABLED	0x00008F87

#define CLK_ETH_PLL4P		0x00008FC0
#define CLK_ETH_PLL3Q		0x00008FC1
#define CLK_ETH_DISABLED	0x00008FC3

#define CLK_QSPI_ACLK		0x00009000
#define CLK_QSPI_PLL3R		0x00009001
#define CLK_QSPI_PLL4P		0x00009002
#define CLK_QSPI_CKPER		0x00009003

#define CLK_FMC_ACLK		0x00009040
#define CLK_FMC_PLL3R		0x00009041
#define CLK_FMC_PLL4P		0x00009042
#define CLK_FMC_CKPER		0x00009043

#define CLK_FDCAN_HSE		0x000090C0
#define CLK_FDCAN_PLL3Q		0x000090C1
#define CLK_FDCAN_PLL4Q		0x000090C2
#define CLK_FDCAN_PLL4R		0x000090C3

#define CLK_SPDIF_PLL4P		0x00009140
#define CLK_SPDIF_PLL3Q		0x00009141
#define CLK_SPDIF_HSI		0x00009142
#define CLK_SPDIF_DISABLED	0x00009143

#define CLK_CEC_LSE		0x00009180
#define CLK_CEC_LSI		0x00009181
#define CLK_CEC_CSI_DIV122	0x00009182
#define CLK_CEC_DISABLED	0x00009183

#define CLK_USBPHY_HSE		0x000091C0
#define CLK_USBPHY_PLL4R	0x000091C1
#define CLK_USBPHY_HSE_DIV2	0x000091C2
#define CLK_USBPHY_DISABLED	0x000091C3

#define CLK_USBO_PLL4R		0x800091C0
#define CLK_USBO_USBPHY		0x800091C1

#define CLK_RNG1_CSI		0x00000CC0
#define CLK_RNG1_PLL4R		0x00000CC1
#define CLK_RNG1_LSE		0x00000CC2
#define CLK_RNG1_LSI		0x00000CC3

#define CLK_RNG2_CSI		0x00009200
#define CLK_RNG2_PLL4R		0x00009201
#define CLK_RNG2_LSE		0x00009202
#define CLK_RNG2_LSI		0x00009203

#define CLK_CKPER_HSI		0x00000D00
#define CLK_CKPER_CSI		0x00000D01
#define CLK_CKPER_HSE		0x00000D02
#define CLK_CKPER_DISABLED	0x00000D03

#define CLK_STGEN_HSI		0x00000D40
#define CLK_STGEN_HSE		0x00000D41
#define CLK_STGEN_DISABLED	0x00000D43

#define CLK_DSI_DSIPLL		0x00009240
#define CLK_DSI_PLL4P		0x00009241

#define CLK_ADC_PLL4R		0x00009280
#define CLK_ADC_CKPER		0x00009281
#define CLK_ADC_PLL3Q		0x00009282
#define CLK_ADC_DISABLED	0x00009283

#define CLK_LPTIM45_PCLK3	0x000092C0
#define CLK_LPTIM45_PLL4P	0x000092C1
#define CLK_LPTIM45_PLL3Q	0x000092C2
#define CLK_LPTIM45_LSE		0x000092C3
#define CLK_LPTIM45_LSI		0x000092C4
#define CLK_LPTIM45_CKPER	0x000092C5
#define CLK_LPTIM45_DISABLED	0x000092C7

#define CLK_LPTIM23_PCLK3	0x00009300
#define CLK_LPTIM23_PLL4Q	0x00009301
#define CLK_LPTIM23_CKPER	0x00009302
#define CLK_LPTIM23_LSE		0x00009303
#define CLK_LPTIM23_LSI		0x00009304
#define CLK_LPTIM23_DISABLED	0x00009307

#define CLK_LPTIM1_PCLK1	0x00009340
#define CLK_LPTIM1_PLL4P	0x00009341
#define CLK_LPTIM1_PLL3Q	0x00009342
#define CLK_LPTIM1_LSE		0x00009343
#define CLK_LPTIM1_LSI		0x00009344
#define CLK_LPTIM1_CKPER	0x00009345
#define CLK_LPTIM1_DISABLED	0x00009347

/* define for st,pll /csg */
#define SSCG_MODE_CENTER_SPREAD	0
#define SSCG_MODE_DOWN_SPREAD	1

/* define for st,drive */
#define LSEDRV_LOWEST		0
#define LSEDRV_MEDIUM_LOW	1
#define LSEDRV_MEDIUM_HIGH	2
#define LSEDRV_HIGHEST		3

#endif
