/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgColumn;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgType;
import java.text.MessageFormat;

public class CreateTypeParser {
    public static void parse(PgDatabase pgDatabase, String string) {
        Parser parser = new Parser(string);
        parser.expect("CREATE", "TYPE");
        String string2 = parser.parseIdentifier();
        PgType pgType = new PgType(ParserUtils.getObjectName(string2));
        String string3 = ParserUtils.getSchemaName(string2, pgDatabase);
        PgSchema pgSchema = pgDatabase.getSchema(string3);
        if (pgSchema == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), string3, string));
        }
        pgSchema.addType(pgType);
        parser.expect("AS");
        if (parser.expectOptional("ENUM")) {
            pgType.setIsEnum(true);
        }
        parser.expect("(");
        while (!parser.expectOptional(")")) {
            if (pgType.getIsEnum()) {
                String string4 = parser.getExpression();
                pgType.addEnumValue(string4);
                if (parser.expectOptional(")")) break;
                parser.expect(",");
                continue;
            }
            CreateTypeParser.parseColumn(parser, pgType);
            if (parser.expectOptional(")")) break;
            parser.expect(",");
        }
        while (!parser.expectOptional(";")) {
        }
    }

    private static void parseColumn(Parser parser, PgType pgType) {
        PgColumn pgColumn = new PgColumn(ParserUtils.getObjectName(parser.parseIdentifier()));
        pgType.addColumn(pgColumn);
        pgColumn.parseDefinition(parser.getExpression());
    }

    private CreateTypeParser() {
    }
}

