; Poseidon Library
;
;    Copyright 2024 Provable Inc.
;
;    Licensed under the Apache License, Version 2.0 (the "License");
;    you may not use this file except in compliance with the License.
;    You may obtain a copy of the License at
;
;      http://www.apache.org/licenses/LICENSE-2.0
;
;    Unless required by applicable law or agreed to in writing, software
;    distributed under the License is distributed on an "AS IS" BASIS,
;    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
;    See the License for the specific language governing permissions and
;    limitations under the License.

; Authors: Alessandro Coglio (www.alessandrocoglio.info)
;          Eric McCarthy (bendyarm on GitHub)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "POSEIDON")

(include-book "rate-8-alpha-17")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Tests.
; Checked against the snarkVM console Rust implementation.

(assert-equal
 (hash8 '())
 1567761742253784763517697634212670888744157690807242184088612393580063919530)

(assert-equal
 (hash8 '(0))
 4116380618505203139735709763188062899546807129226239980574382125889245087784)

(assert-equal
 (hash8 '(1))
 1602821949296022806146270121391383580291702991974340780933114647223620852779)

(assert-equal
 (hash8 '(0 1))
 4504853075224575973859580682353724684440391731949662062689299393698522574250)

(assert-equal
 (hash8 '(7 6))
 2011084681212961452311333305005509211229919616031257660941313625311987279984)

(assert-equal
 (hash8 '(3801852864665033841774715284518384682376829752661853198612247855579120198106
          8354898322875240371401674517397790035008442020361740574117886421279083828480
          4810388512520169167962815122521832339992376865086300759308552937986944510606))
 2441207636122714306371856624370101512638654024941597476504350040586876819967)

(assert-equal
 (hash8 '(3801852864665033841774715284518384682376829752661853198612247855579120198106
          8354898322875240371401674517397790035008442020361740574117886421279083828480
          4810388512520169167962815122521832339992376865086300759308552937986944510606
          1806278863067630397941269234951941896370617486625414347832536440203404317871))
 6088573564989104999418724140351215790250870264476768543870720179680005600079)

(assert-equal
 (hash8 '(3801852864665033841774715284518384682376829752661853198612247855579120198106
          8354898322875240371401674517397790035008442020361740574117886421279083828480
          4810388512520169167962815122521832339992376865086300759308552937986944510606
          1806278863067630397941269234951941896370617486625414347832536440203404317871
          4017177598231920767921734423139954103557056461408532722673217828464276314809))
 5831342285401093988805641165492026817697793896414496472388751494052459296879)

(assert-equal
 (hash8 '(2241061724039470158487229089505123379386376040366677537043719491567584322339
          4450395467941419565906844040025562669400620759737863109185235386261110553073
          3763549180544198711495347718218896634621699987767108409942867882747700142403
          1834649076610684411560795826346579299134200286711220272747136514724202486145
          3330794675297759513930533281299019673013197332462213086257974185952740704073
          5929621997900969559642343088519370677943323262633114245367700983937202243619
          8211311402459203356251863974142333868284569297703150729090604853345946857386))
 1444892038274156943837009734886522214149622494611671083296024163883829362979)

(assert-equal
 (hash8 '(160895951580389706659907027483151875213333010019551276998320919296228647317
          8334099740396373026754940038411748941117628023990297711605274995172393663866
          6508516067551208838086421306235504440162527555399726948591414865066786644888
          5260580011132523115913756761919139190330166964648541423363604516046903841683
          1066299182733912299977577599302716102002738653010828827086884529157392046228
          1977519953625589014039847898215240724041194773120013187722954068145627219929
          1618348632868002512910764605250139381231860094469042556990470848701700964713
          1157459381876765943377450451674060447297483544491073402235960067133285590974))
 1194605944695343789228228597749032243744971209446840517486291637780197055440)

(assert-equal
 (hash8 '(3912308888616251672812272013988802988420414245857866136212784631403027079860
          4100923705771018951561873336835055979905965765839649442185404560120892958216
          5701101373789959818781445339314572139971317958997296225671698446757742149719
          5785597627944719799683455467917641287692417422465938462034769734951914291948
          214818498460401597228033958287537426429167258531438668351703993840760770582
          4497884203527978976088488455523871581608892729212445595385399904032800522087
          4010331535874074900042223641934450423780782982190514529696596753456937384201
          6067637133445382691713836557146174628934072680692724940823629181144890569742
          5966421531117752671625849775894572561179958822813329961720805067254995723444))
 305373231140119141495771730195166660114047796312466197355241017473154264594)
