![bcbio banner](contents/images/banner.png)

A python toolkit providing best-practice pipelines for fully automated
high throughput sequencing analysis. You write a high level configuration file
specifying your inputs and analysis parameters. This input drives a parallel pipeline
that handles distributed execution, idempotent processing restarts and safe transactional steps.
The goal is to provide a shared community resource that handles
the data processing component of sequencing analysis, providing researchers with more time to focus on the downstream biology.

## Contents
* [Getting started](contents/intro)
* [----------User stories----------](https://bcbio-nextgen.readthedocs.io/en/latest/)
* [Somatic variants](contents/somatic_variants)
* [Bulk RNA-seq expression](contents/bulk_rnaseq)
* [Single cell RNA-seq](contents/single_cell)
* [PureCN analysis](contents/purecn)
* [HLA typing](contents/hla_typing)
* [Germline small variants](contents/germline_variants)
* [3prime digital gene expression](contents/3prime_dge)
* [Structural variants](contents/structural_variants)
* [ChIP/ATAC-seq](contents/atac)
* [Methylation](contents/methylation)
* [Bulk RNA-seq variants](contents/rnaseq_variants)
* [Bulk RNA-seq fusions](contents/rnaseq_fusions)
* [fast RNA-seq](contents/fast_rnaseq)
* [human/mouse disambiguation](contents/disambiguation)
* [small RNA-seq](contents/small_rnaseq)
* [----------Infrastructure----------](https://bcbio-nextgen.readthedocs.io/en/latest/)
* [Installation](contents/installation)
* [Configuration](contents/configuration)
* [Parallel execution](contents/parallel)
* [Outputs](contents/outputs)
* [Common Workflow Language (CWL)](contents/cwl)
* [Cloud](contents/cloud)
* [Development](contents/development)
* [----------Misc----------](https://bcbio-nextgen.readthedocs.io/en/latest/)
* [Users](contents/users)
* [Internals](contents/internals)
* [Presentations](contents/presentations)
* [Teaching](contents/teaching)
* [Citations](contents/citations)
